/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.camunda.community.rest.client.dto.TelemetryProductDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * TelemetryDataDto
 */
@JsonPropertyOrder({
  TelemetryDataDto.JSON_PROPERTY_INSTALLATION,
  TelemetryDataDto.JSON_PROPERTY_PRODUCT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class TelemetryDataDto {
  public static final String JSON_PROPERTY_INSTALLATION = "installation";
  private JsonNullable<String> installation = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PRODUCT = "product";
  private TelemetryProductDto product;

  public TelemetryDataDto() {
  }

  public TelemetryDataDto installation(String installation) {
    this.installation = JsonNullable.<String>of(installation);
    
    return this;
  }

   /**
   * An id which is unique for each installation of Camunda. It is stored once per database so all engines connected to the same database will have the same installation ID. The ID is used to identify a single installation of Camunda Platform.
   * @return installation
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getInstallation() {
        return installation.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INSTALLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getInstallation_JsonNullable() {
    return installation;
  }
  
  @JsonProperty(JSON_PROPERTY_INSTALLATION)
  public void setInstallation_JsonNullable(JsonNullable<String> installation) {
    this.installation = installation;
  }

  public void setInstallation(String installation) {
    this.installation = JsonNullable.<String>of(installation);
  }


  public TelemetryDataDto product(TelemetryProductDto product) {
    
    this.product = product;
    return this;
  }

   /**
   * Get product
   * @return product
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRODUCT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TelemetryProductDto getProduct() {
    return product;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProduct(TelemetryProductDto product) {
    this.product = product;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TelemetryDataDto telemetryDataDto = (TelemetryDataDto) o;
    return equalsNullable(this.installation, telemetryDataDto.installation) &&
        Objects.equals(this.product, telemetryDataDto.product);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(installation), product);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TelemetryDataDto {\n");
    sb.append("    installation: ").append(toIndentedString(installation)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `installation` to the URL query string
    if (getInstallation() != null) {
      try {
        joiner.add(String.format("%sinstallation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInstallation()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `product` to the URL query string
    if (getProduct() != null) {
      joiner.add(getProduct().toUrlQueryString(prefix + "product" + suffix));
    }

    return joiner.toString();
  }

}

