/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.AbstractVendorVersionInformationDto;
import org.camunda.community.rest.client.dto.TelemetryCountDto;
import org.camunda.community.rest.client.dto.TelemetryLicenseKeyDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * TelemetryInternalsDto
 */
@JsonPropertyOrder({
  TelemetryInternalsDto.JSON_PROPERTY_DATABASE,
  TelemetryInternalsDto.JSON_PROPERTY_APPLICATION_SERVER,
  TelemetryInternalsDto.JSON_PROPERTY_LICENSE_KEY,
  TelemetryInternalsDto.JSON_PROPERTY_CAMUNDA_INTEGRATION,
  TelemetryInternalsDto.JSON_PROPERTY_COMMANDS,
  TelemetryInternalsDto.JSON_PROPERTY_METRICS,
  TelemetryInternalsDto.JSON_PROPERTY_WEBAPPS,
  TelemetryInternalsDto.JSON_PROPERTY_JDK,
  TelemetryInternalsDto.JSON_PROPERTY_DATA_COLLECTION_START_DATE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class TelemetryInternalsDto {
  public static final String JSON_PROPERTY_DATABASE = "database";
  private AbstractVendorVersionInformationDto database;

  public static final String JSON_PROPERTY_APPLICATION_SERVER = "application-server";
  private AbstractVendorVersionInformationDto applicationServer;

  public static final String JSON_PROPERTY_LICENSE_KEY = "license-key";
  private TelemetryLicenseKeyDto licenseKey;

  public static final String JSON_PROPERTY_CAMUNDA_INTEGRATION = "camunda-integration";
  private JsonNullable<List<String>> camundaIntegration = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_COMMANDS = "commands";
  private JsonNullable<Map<String, TelemetryCountDto>> commands = JsonNullable.<Map<String, TelemetryCountDto>>undefined();

  public static final String JSON_PROPERTY_METRICS = "metrics";
  private JsonNullable<Map<String, TelemetryCountDto>> metrics = JsonNullable.<Map<String, TelemetryCountDto>>undefined();

  public static final String JSON_PROPERTY_WEBAPPS = "webapps";
  private JsonNullable<List<String>> webapps = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_JDK = "jdk";
  private AbstractVendorVersionInformationDto jdk;

  public static final String JSON_PROPERTY_DATA_COLLECTION_START_DATE = "data-collection-start-date";
  private OffsetDateTime dataCollectionStartDate;

  public TelemetryInternalsDto() {
  }

  public TelemetryInternalsDto database(AbstractVendorVersionInformationDto database) {
    
    this.database = database;
    return this;
  }

   /**
   * Get database
   * @return database
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATABASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AbstractVendorVersionInformationDto getDatabase() {
    return database;
  }


  @JsonProperty(JSON_PROPERTY_DATABASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDatabase(AbstractVendorVersionInformationDto database) {
    this.database = database;
  }


  public TelemetryInternalsDto applicationServer(AbstractVendorVersionInformationDto applicationServer) {
    
    this.applicationServer = applicationServer;
    return this;
  }

   /**
   * Get applicationServer
   * @return applicationServer
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_APPLICATION_SERVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AbstractVendorVersionInformationDto getApplicationServer() {
    return applicationServer;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION_SERVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationServer(AbstractVendorVersionInformationDto applicationServer) {
    this.applicationServer = applicationServer;
  }


  public TelemetryInternalsDto licenseKey(TelemetryLicenseKeyDto licenseKey) {
    
    this.licenseKey = licenseKey;
    return this;
  }

   /**
   * Get licenseKey
   * @return licenseKey
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LICENSE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TelemetryLicenseKeyDto getLicenseKey() {
    return licenseKey;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseKey(TelemetryLicenseKeyDto licenseKey) {
    this.licenseKey = licenseKey;
  }


  public TelemetryInternalsDto camundaIntegration(List<String> camundaIntegration) {
    this.camundaIntegration = JsonNullable.<List<String>>of(camundaIntegration);
    
    return this;
  }

  public TelemetryInternalsDto addCamundaIntegrationItem(String camundaIntegrationItem) {
    if (this.camundaIntegration == null || !this.camundaIntegration.isPresent()) {
      this.camundaIntegration = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.camundaIntegration.get().add(camundaIntegrationItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * List of Camunda integrations used (e.g., Camunda Spring Boot Starter, Camunda Run, WildFly/JBoss subsystem, Camunda EJB).
   * @return camundaIntegration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getCamundaIntegration() {
        return camundaIntegration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CAMUNDA_INTEGRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getCamundaIntegration_JsonNullable() {
    return camundaIntegration;
  }
  
  @JsonProperty(JSON_PROPERTY_CAMUNDA_INTEGRATION)
  public void setCamundaIntegration_JsonNullable(JsonNullable<List<String>> camundaIntegration) {
    this.camundaIntegration = camundaIntegration;
  }

  public void setCamundaIntegration(List<String> camundaIntegration) {
    this.camundaIntegration = JsonNullable.<List<String>>of(camundaIntegration);
  }


  public TelemetryInternalsDto commands(Map<String, TelemetryCountDto> commands) {
    this.commands = JsonNullable.<Map<String, TelemetryCountDto>>of(commands);
    
    return this;
  }

  public TelemetryInternalsDto putCommandsItem(String key, TelemetryCountDto commandsItem) {
    if (this.commands == null || !this.commands.isPresent()) {
      this.commands = JsonNullable.<Map<String, TelemetryCountDto>>of(new HashMap<>());
    }
    try {
      this.commands.get().put(key, commandsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The count of executed commands after the last retrieved data.
   * @return commands
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, TelemetryCountDto> getCommands() {
        return commands.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMMANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, TelemetryCountDto>> getCommands_JsonNullable() {
    return commands;
  }
  
  @JsonProperty(JSON_PROPERTY_COMMANDS)
  public void setCommands_JsonNullable(JsonNullable<Map<String, TelemetryCountDto>> commands) {
    this.commands = commands;
  }

  public void setCommands(Map<String, TelemetryCountDto> commands) {
    this.commands = JsonNullable.<Map<String, TelemetryCountDto>>of(commands);
  }


  public TelemetryInternalsDto metrics(Map<String, TelemetryCountDto> metrics) {
    this.metrics = JsonNullable.<Map<String, TelemetryCountDto>>of(metrics);
    
    return this;
  }

  public TelemetryInternalsDto putMetricsItem(String key, TelemetryCountDto metricsItem) {
    if (this.metrics == null || !this.metrics.isPresent()) {
      this.metrics = JsonNullable.<Map<String, TelemetryCountDto>>of(new HashMap<>());
    }
    try {
      this.metrics.get().put(key, metricsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The collected metrics are the number of root process instance executions started, the number of activity instances started or also known as flow node instances, and the number of executed decision instances and elements.
   * @return metrics
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, TelemetryCountDto> getMetrics() {
        return metrics.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, TelemetryCountDto>> getMetrics_JsonNullable() {
    return metrics;
  }
  
  @JsonProperty(JSON_PROPERTY_METRICS)
  public void setMetrics_JsonNullable(JsonNullable<Map<String, TelemetryCountDto>> metrics) {
    this.metrics = metrics;
  }

  public void setMetrics(Map<String, TelemetryCountDto> metrics) {
    this.metrics = JsonNullable.<Map<String, TelemetryCountDto>>of(metrics);
  }


  public TelemetryInternalsDto webapps(List<String> webapps) {
    this.webapps = JsonNullable.<List<String>>of(webapps);
    
    return this;
  }

  public TelemetryInternalsDto addWebappsItem(String webappsItem) {
    if (this.webapps == null || !this.webapps.isPresent()) {
      this.webapps = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.webapps.get().add(webappsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The webapps enabled in this installation of Camunda.
   * @return webapps
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getWebapps() {
        return webapps.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WEBAPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getWebapps_JsonNullable() {
    return webapps;
  }
  
  @JsonProperty(JSON_PROPERTY_WEBAPPS)
  public void setWebapps_JsonNullable(JsonNullable<List<String>> webapps) {
    this.webapps = webapps;
  }

  public void setWebapps(List<String> webapps) {
    this.webapps = JsonNullable.<List<String>>of(webapps);
  }


  public TelemetryInternalsDto jdk(AbstractVendorVersionInformationDto jdk) {
    
    this.jdk = jdk;
    return this;
  }

   /**
   * Get jdk
   * @return jdk
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JDK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AbstractVendorVersionInformationDto getJdk() {
    return jdk;
  }


  @JsonProperty(JSON_PROPERTY_JDK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJdk(AbstractVendorVersionInformationDto jdk) {
    this.jdk = jdk;
  }


  public TelemetryInternalsDto dataCollectionStartDate(OffsetDateTime dataCollectionStartDate) {
    
    this.dataCollectionStartDate = dataCollectionStartDate;
    return this;
  }

   /**
   * The date when the engine started to collect dynamic data, such as command executions and metrics. If telemetry sending is enabled, dynamic data resets on sending the data to Camunda. Dynamic data and the date returned by this method are reset in three cases: engine startup, after engine start when sending telemetry data to Camunda is enabled via API, after sending telemetry data to Camunda (only when this was enabled) The date is in the format &lt;code&gt;YYYY-MM-DD&#39;T&#39;HH:mm:ss.SSSZ&lt;/code&gt;.
   * @return dataCollectionStartDate
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATA_COLLECTION_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDataCollectionStartDate() {
    return dataCollectionStartDate;
  }


  @JsonProperty(JSON_PROPERTY_DATA_COLLECTION_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataCollectionStartDate(OffsetDateTime dataCollectionStartDate) {
    this.dataCollectionStartDate = dataCollectionStartDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TelemetryInternalsDto telemetryInternalsDto = (TelemetryInternalsDto) o;
    return Objects.equals(this.database, telemetryInternalsDto.database) &&
        Objects.equals(this.applicationServer, telemetryInternalsDto.applicationServer) &&
        Objects.equals(this.licenseKey, telemetryInternalsDto.licenseKey) &&
        equalsNullable(this.camundaIntegration, telemetryInternalsDto.camundaIntegration) &&
        equalsNullable(this.commands, telemetryInternalsDto.commands) &&
        equalsNullable(this.metrics, telemetryInternalsDto.metrics) &&
        equalsNullable(this.webapps, telemetryInternalsDto.webapps) &&
        Objects.equals(this.jdk, telemetryInternalsDto.jdk) &&
        Objects.equals(this.dataCollectionStartDate, telemetryInternalsDto.dataCollectionStartDate);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(database, applicationServer, licenseKey, hashCodeNullable(camundaIntegration), hashCodeNullable(commands), hashCodeNullable(metrics), hashCodeNullable(webapps), jdk, dataCollectionStartDate);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TelemetryInternalsDto {\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    applicationServer: ").append(toIndentedString(applicationServer)).append("\n");
    sb.append("    licenseKey: ").append(toIndentedString(licenseKey)).append("\n");
    sb.append("    camundaIntegration: ").append(toIndentedString(camundaIntegration)).append("\n");
    sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    webapps: ").append(toIndentedString(webapps)).append("\n");
    sb.append("    jdk: ").append(toIndentedString(jdk)).append("\n");
    sb.append("    dataCollectionStartDate: ").append(toIndentedString(dataCollectionStartDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `database` to the URL query string
    if (getDatabase() != null) {
      joiner.add(getDatabase().toUrlQueryString(prefix + "database" + suffix));
    }

    // add `application-server` to the URL query string
    if (getApplicationServer() != null) {
      joiner.add(getApplicationServer().toUrlQueryString(prefix + "application-server" + suffix));
    }

    // add `license-key` to the URL query string
    if (getLicenseKey() != null) {
      joiner.add(getLicenseKey().toUrlQueryString(prefix + "license-key" + suffix));
    }

    // add `camunda-integration` to the URL query string
    if (getCamundaIntegration() != null) {
      for (int i = 0; i < getCamundaIntegration().size(); i++) {
        try {
          joiner.add(String.format("%scamunda-integration%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCamundaIntegration().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `commands` to the URL query string
    if (getCommands() != null) {
      for (String _key : getCommands().keySet()) {
        if (getCommands().get(_key) != null) {
          joiner.add(getCommands().get(_key).toUrlQueryString(String.format("%scommands%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `metrics` to the URL query string
    if (getMetrics() != null) {
      for (String _key : getMetrics().keySet()) {
        if (getMetrics().get(_key) != null) {
          joiner.add(getMetrics().get(_key).toUrlQueryString(String.format("%smetrics%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `webapps` to the URL query string
    if (getWebapps() != null) {
      for (int i = 0; i < getWebapps().size(); i++) {
        try {
          joiner.add(String.format("%swebapps%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getWebapps().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `jdk` to the URL query string
    if (getJdk() != null) {
      joiner.add(getJdk().toUrlQueryString(prefix + "jdk" + suffix));
    }

    // add `data-collection-start-date` to the URL query string
    if (getDataCollectionStartDate() != null) {
      try {
        joiner.add(String.format("%sdata-collection-start-date%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDataCollectionStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

