/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * TelemetryLicenseKeyDto
 */
@JsonPropertyOrder({
  TelemetryLicenseKeyDto.JSON_PROPERTY_CUSTOMER,
  TelemetryLicenseKeyDto.JSON_PROPERTY_TYPE,
  TelemetryLicenseKeyDto.JSON_PROPERTY_VALID_UNTIL,
  TelemetryLicenseKeyDto.JSON_PROPERTY_UNLIMITED,
  TelemetryLicenseKeyDto.JSON_PROPERTY_FEATURES,
  TelemetryLicenseKeyDto.JSON_PROPERTY_RAW
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class TelemetryLicenseKeyDto {
  public static final String JSON_PROPERTY_CUSTOMER = "customer";
  private JsonNullable<String> customer = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TYPE = "type";
  private JsonNullable<String> type = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VALID_UNTIL = "valid-until";
  private JsonNullable<LocalDate> validUntil = JsonNullable.<LocalDate>undefined();

  public static final String JSON_PROPERTY_UNLIMITED = "unlimited";
  private JsonNullable<Boolean> unlimited = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FEATURES = "features";
  private Map<String, String> features = new HashMap<>();

  public static final String JSON_PROPERTY_RAW = "raw";
  private JsonNullable<String> raw = JsonNullable.<String>undefined();

  public TelemetryLicenseKeyDto() {
  }

  public TelemetryLicenseKeyDto customer(String customer) {
    this.customer = JsonNullable.<String>of(customer);
    
    return this;
  }

   /**
   * The name of the customer the license was issued for.
   * @return customer
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCustomer() {
        return customer.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CUSTOMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCustomer_JsonNullable() {
    return customer;
  }
  
  @JsonProperty(JSON_PROPERTY_CUSTOMER)
  public void setCustomer_JsonNullable(JsonNullable<String> customer) {
    this.customer = customer;
  }

  public void setCustomer(String customer) {
    this.customer = JsonNullable.<String>of(customer);
  }


  public TelemetryLicenseKeyDto type(String type) {
    this.type = JsonNullable.<String>of(type);
    
    return this;
  }

   /**
   * The license type.
   * @return type
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getType() {
        return type.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getType_JsonNullable() {
    return type;
  }
  
  @JsonProperty(JSON_PROPERTY_TYPE)
  public void setType_JsonNullable(JsonNullable<String> type) {
    this.type = type;
  }

  public void setType(String type) {
    this.type = JsonNullable.<String>of(type);
  }


  public TelemetryLicenseKeyDto validUntil(LocalDate validUntil) {
    this.validUntil = JsonNullable.<LocalDate>of(validUntil);
    
    return this;
  }

   /**
   * The expiration date of the license.
   * @return validUntil
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public LocalDate getValidUntil() {
        return validUntil.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VALID_UNTIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<LocalDate> getValidUntil_JsonNullable() {
    return validUntil;
  }
  
  @JsonProperty(JSON_PROPERTY_VALID_UNTIL)
  public void setValidUntil_JsonNullable(JsonNullable<LocalDate> validUntil) {
    this.validUntil = validUntil;
  }

  public void setValidUntil(LocalDate validUntil) {
    this.validUntil = JsonNullable.<LocalDate>of(validUntil);
  }


  public TelemetryLicenseKeyDto unlimited(Boolean unlimited) {
    this.unlimited = JsonNullable.<Boolean>of(unlimited);
    
    return this;
  }

   /**
   * Flag that indicates if the license is unlimited.
   * @return unlimited
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUnlimited() {
        return unlimited.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UNLIMITED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUnlimited_JsonNullable() {
    return unlimited;
  }
  
  @JsonProperty(JSON_PROPERTY_UNLIMITED)
  public void setUnlimited_JsonNullable(JsonNullable<Boolean> unlimited) {
    this.unlimited = unlimited;
  }

  public void setUnlimited(Boolean unlimited) {
    this.unlimited = JsonNullable.<Boolean>of(unlimited);
  }


  public TelemetryLicenseKeyDto features(Map<String, String> features) {
    
    this.features = features;
    return this;
  }

  public TelemetryLicenseKeyDto putFeaturesItem(String key, String featuresItem) {
    if (this.features == null) {
      this.features = new HashMap<>();
    }
    this.features.put(key, featuresItem);
    return this;
  }

   /**
   * A map of features included in the license.
   * @return features
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getFeatures() {
    return features;
  }


  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatures(Map<String, String> features) {
    this.features = features;
  }


  public TelemetryLicenseKeyDto raw(String raw) {
    this.raw = JsonNullable.<String>of(raw);
    
    return this;
  }

   /**
   * The raw license information.
   * @return raw
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRaw() {
        return raw.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRaw_JsonNullable() {
    return raw;
  }
  
  @JsonProperty(JSON_PROPERTY_RAW)
  public void setRaw_JsonNullable(JsonNullable<String> raw) {
    this.raw = raw;
  }

  public void setRaw(String raw) {
    this.raw = JsonNullable.<String>of(raw);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TelemetryLicenseKeyDto telemetryLicenseKeyDto = (TelemetryLicenseKeyDto) o;
    return equalsNullable(this.customer, telemetryLicenseKeyDto.customer) &&
        equalsNullable(this.type, telemetryLicenseKeyDto.type) &&
        equalsNullable(this.validUntil, telemetryLicenseKeyDto.validUntil) &&
        equalsNullable(this.unlimited, telemetryLicenseKeyDto.unlimited) &&
        Objects.equals(this.features, telemetryLicenseKeyDto.features) &&
        equalsNullable(this.raw, telemetryLicenseKeyDto.raw);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(customer), hashCodeNullable(type), hashCodeNullable(validUntil), hashCodeNullable(unlimited), features, hashCodeNullable(raw));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TelemetryLicenseKeyDto {\n");
    sb.append("    customer: ").append(toIndentedString(customer)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validUntil: ").append(toIndentedString(validUntil)).append("\n");
    sb.append("    unlimited: ").append(toIndentedString(unlimited)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    raw: ").append(toIndentedString(raw)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `customer` to the URL query string
    if (getCustomer() != null) {
      try {
        joiner.add(String.format("%scustomer%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCustomer()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `valid-until` to the URL query string
    if (getValidUntil() != null) {
      try {
        joiner.add(String.format("%svalid-until%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValidUntil()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unlimited` to the URL query string
    if (getUnlimited() != null) {
      try {
        joiner.add(String.format("%sunlimited%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnlimited()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `features` to the URL query string
    if (getFeatures() != null) {
      for (String _key : getFeatures().keySet()) {
        try {
          joiner.add(String.format("%sfeatures%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getFeatures().get(_key), URLEncoder.encode(String.valueOf(getFeatures().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `raw` to the URL query string
    if (getRaw() != null) {
      try {
        joiner.add(String.format("%sraw%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRaw()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

