/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.ActivityInstanceIncidentDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A JSON object corresponding to the Activity Instance tree of the given process instance.
 */
@JsonPropertyOrder({
  TransitionInstanceDto.JSON_PROPERTY_ID,
  TransitionInstanceDto.JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID,
  TransitionInstanceDto.JSON_PROPERTY_ACTIVITY_ID,
  TransitionInstanceDto.JSON_PROPERTY_ACTIVITY_NAME,
  TransitionInstanceDto.JSON_PROPERTY_ACTIVITY_TYPE,
  TransitionInstanceDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  TransitionInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  TransitionInstanceDto.JSON_PROPERTY_EXECUTION_ID,
  TransitionInstanceDto.JSON_PROPERTY_INCIDENT_IDS,
  TransitionInstanceDto.JSON_PROPERTY_INCIDENTS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class TransitionInstanceDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID = "parentActivityInstanceId";
  private JsonNullable<String> parentActivityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_NAME = "activityName";
  private JsonNullable<String> activityName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_TYPE = "activityType";
  private JsonNullable<String> activityType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INCIDENT_IDS = "incidentIds";
  private JsonNullable<List<String>> incidentIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_INCIDENTS = "incidents";
  private JsonNullable<List<ActivityInstanceIncidentDto>> incidents = JsonNullable.<List<ActivityInstanceIncidentDto>>undefined();

  public TransitionInstanceDto() {
  }

  public TransitionInstanceDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the transition instance.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public TransitionInstanceDto parentActivityInstanceId(String parentActivityInstanceId) {
    this.parentActivityInstanceId = JsonNullable.<String>of(parentActivityInstanceId);
    
    return this;
  }

   /**
   * The id of the parent activity instance, for example a sub process instance.
   * @return parentActivityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getParentActivityInstanceId() {
        return parentActivityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getParentActivityInstanceId_JsonNullable() {
    return parentActivityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID)
  public void setParentActivityInstanceId_JsonNullable(JsonNullable<String> parentActivityInstanceId) {
    this.parentActivityInstanceId = parentActivityInstanceId;
  }

  public void setParentActivityInstanceId(String parentActivityInstanceId) {
    this.parentActivityInstanceId = JsonNullable.<String>of(parentActivityInstanceId);
  }


  public TransitionInstanceDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public TransitionInstanceDto activityName(String activityName) {
    this.activityName = JsonNullable.<String>of(activityName);
    
    return this;
  }

   /**
   * The name of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)
   * @return activityName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityName() {
        return activityName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityName_JsonNullable() {
    return activityName;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_NAME)
  public void setActivityName_JsonNullable(JsonNullable<String> activityName) {
    this.activityName = activityName;
  }

  public void setActivityName(String activityName) {
    this.activityName = JsonNullable.<String>of(activityName);
  }


  public TransitionInstanceDto activityType(String activityType) {
    this.activityType = JsonNullable.<String>of(activityType);
    
    return this;
  }

   /**
   * The type of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)
   * @return activityType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityType() {
        return activityType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityType_JsonNullable() {
    return activityType;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_TYPE)
  public void setActivityType_JsonNullable(JsonNullable<String> activityType) {
    this.activityType = activityType;
  }

  public void setActivityType(String activityType) {
    this.activityType = JsonNullable.<String>of(activityType);
  }


  public TransitionInstanceDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance this instance is part of.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public TransitionInstanceDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public TransitionInstanceDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The execution id.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public TransitionInstanceDto incidentIds(List<String> incidentIds) {
    this.incidentIds = JsonNullable.<List<String>>of(incidentIds);
    
    return this;
  }

  public TransitionInstanceDto addIncidentIdsItem(String incidentIdsItem) {
    if (this.incidentIds == null || !this.incidentIds.isPresent()) {
      this.incidentIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.incidentIds.get().add(incidentIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of incident ids.
   * @return incidentIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getIncidentIds() {
        return incidentIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getIncidentIds_JsonNullable() {
    return incidentIds;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_IDS)
  public void setIncidentIds_JsonNullable(JsonNullable<List<String>> incidentIds) {
    this.incidentIds = incidentIds;
  }

  public void setIncidentIds(List<String> incidentIds) {
    this.incidentIds = JsonNullable.<List<String>>of(incidentIds);
  }


  public TransitionInstanceDto incidents(List<ActivityInstanceIncidentDto> incidents) {
    this.incidents = JsonNullable.<List<ActivityInstanceIncidentDto>>of(incidents);
    
    return this;
  }

  public TransitionInstanceDto addIncidentsItem(ActivityInstanceIncidentDto incidentsItem) {
    if (this.incidents == null || !this.incidents.isPresent()) {
      this.incidents = JsonNullable.<List<ActivityInstanceIncidentDto>>of(new ArrayList<>());
    }
    try {
      this.incidents.get().add(incidentsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of JSON objects containing incident specific properties: * &#x60;id&#x60;: the id of the incident * &#x60;activityId&#x60;: the activity id in which the incident occurred
   * @return incidents
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<ActivityInstanceIncidentDto> getIncidents() {
        return incidents.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<ActivityInstanceIncidentDto>> getIncidents_JsonNullable() {
    return incidents;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENTS)
  public void setIncidents_JsonNullable(JsonNullable<List<ActivityInstanceIncidentDto>> incidents) {
    this.incidents = incidents;
  }

  public void setIncidents(List<ActivityInstanceIncidentDto> incidents) {
    this.incidents = JsonNullable.<List<ActivityInstanceIncidentDto>>of(incidents);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransitionInstanceDto transitionInstanceDto = (TransitionInstanceDto) o;
    return equalsNullable(this.id, transitionInstanceDto.id) &&
        equalsNullable(this.parentActivityInstanceId, transitionInstanceDto.parentActivityInstanceId) &&
        equalsNullable(this.activityId, transitionInstanceDto.activityId) &&
        equalsNullable(this.activityName, transitionInstanceDto.activityName) &&
        equalsNullable(this.activityType, transitionInstanceDto.activityType) &&
        equalsNullable(this.processInstanceId, transitionInstanceDto.processInstanceId) &&
        equalsNullable(this.processDefinitionId, transitionInstanceDto.processDefinitionId) &&
        equalsNullable(this.executionId, transitionInstanceDto.executionId) &&
        equalsNullable(this.incidentIds, transitionInstanceDto.incidentIds) &&
        equalsNullable(this.incidents, transitionInstanceDto.incidents);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(parentActivityInstanceId), hashCodeNullable(activityId), hashCodeNullable(activityName), hashCodeNullable(activityType), hashCodeNullable(processInstanceId), hashCodeNullable(processDefinitionId), hashCodeNullable(executionId), hashCodeNullable(incidentIds), hashCodeNullable(incidents));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransitionInstanceDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    parentActivityInstanceId: ").append(toIndentedString(parentActivityInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityName: ").append(toIndentedString(activityName)).append("\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    incidentIds: ").append(toIndentedString(incidentIds)).append("\n");
    sb.append("    incidents: ").append(toIndentedString(incidents)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parentActivityInstanceId` to the URL query string
    if (getParentActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sparentActivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityName` to the URL query string
    if (getActivityName() != null) {
      try {
        joiner.add(String.format("%sactivityName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityType` to the URL query string
    if (getActivityType() != null) {
      try {
        joiner.add(String.format("%sactivityType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentIds` to the URL query string
    if (getIncidentIds() != null) {
      for (int i = 0; i < getIncidentIds().size(); i++) {
        try {
          joiner.add(String.format("%sincidentIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getIncidentIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `incidents` to the URL query string
    if (getIncidents() != null) {
      for (int i = 0; i < getIncidents().size(); i++) {
        if (getIncidents().get(i) != null) {
          joiner.add(getIncidents().get(i).toUrlQueryString(String.format("%sincidents%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

