/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeleteHistoricProcessInstancesDto;
import org.camunda.community.rest.client.dto.DurationReportResultDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricProcessInstancesDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class HistoricProcessInstanceApi {
    private ApiClient apiClient;

    public HistoricProcessInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricProcessInstanceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteHistoricProcessInstance(String id, Boolean failIfNotExists) throws ApiException {
        this.deleteHistoricProcessInstance(id, failIfNotExists, Collections.emptyMap());
    }

    public void deleteHistoricProcessInstance(String id, Boolean failIfNotExists, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteHistoricProcessInstance");
        }
        String localVarPath = "/history/process-instance/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failIfNotExists", failIfNotExists));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BatchDto deleteHistoricProcessInstancesAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto) throws ApiException {
        return this.deleteHistoricProcessInstancesAsync(deleteHistoricProcessInstancesDto, Collections.emptyMap());
    }

    public BatchDto deleteHistoricProcessInstancesAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
        DeleteHistoricProcessInstancesDto localVarPostBody = deleteHistoricProcessInstancesDto;
        String localVarPath = "/history/process-instance/delete";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteHistoricVariableInstancesOfHistoricProcessInstance(String id) throws ApiException {
        this.deleteHistoricVariableInstancesOfHistoricProcessInstance(id, Collections.emptyMap());
    }

    public void deleteHistoricVariableInstancesOfHistoricProcessInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteHistoricVariableInstancesOfHistoricProcessInstance");
        }
        String localVarPath = "/history/process-instance/{id}/variable-instances".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public HistoricProcessInstanceDto getHistoricProcessInstance(String id) throws ApiException {
        return this.getHistoricProcessInstance(id, Collections.emptyMap());
    }

    public HistoricProcessInstanceDto getHistoricProcessInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricProcessInstance");
        }
        String localVarPath = "/history/process-instance/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<HistoricProcessInstanceDto> localVarReturnType = new TypeReference<HistoricProcessInstanceDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DurationReportResultDto> getHistoricProcessInstanceDurationReport(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, OffsetDateTime startedBefore, OffsetDateTime startedAfter) throws ApiException {
        return this.getHistoricProcessInstanceDurationReport(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, Collections.emptyMap());
    }

    public List<DurationReportResultDto> getHistoricProcessInstanceDurationReport(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (reportType == null) {
            throw new ApiException(400, "Missing the required parameter 'reportType' when calling getHistoricProcessInstanceDurationReport");
        }
        if (periodUnit == null) {
            throw new ApiException(400, "Missing the required parameter 'periodUnit' when calling getHistoricProcessInstanceDurationReport");
        }
        String localVarPath = "/history/process-instance/report";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("reportType", reportType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("periodUnit", periodUnit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/csv", "text/csv"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<DurationReportResultDto>> localVarReturnType = new TypeReference<List<DurationReportResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<HistoricProcessInstanceDto> getHistoricProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        return this.getHistoricProcessInstances(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
    }

    public List<HistoricProcessInstanceDto> getHistoricProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIds", processInstanceIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionName", processDefinitionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finished", finished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("unfinished", unfinished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withIncidents", withIncidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withRootIncidents", withRootIncidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentStatus", incidentStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedBefore", finishedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedAfter", finishedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedJobAfter", executedJobAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedJobBefore", executedJobBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBy", startedBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceId", caseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("completed", completed));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("externallyTerminated", externallyTerminated));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("internallyTerminated", internallyTerminated));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variables", variables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<HistoricProcessInstanceDto>> localVarReturnType = new TypeReference<List<HistoricProcessInstanceDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getHistoricProcessInstancesCount(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        return this.getHistoricProcessInstancesCount(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
    }

    public CountResultDto getHistoricProcessInstancesCount(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIds", processInstanceIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionName", processDefinitionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finished", finished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("unfinished", unfinished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withIncidents", withIncidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withRootIncidents", withRootIncidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentStatus", incidentStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedBefore", finishedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedAfter", finishedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedJobAfter", executedJobAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedJobBefore", executedJobBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBy", startedBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceId", caseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("completed", completed));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("externallyTerminated", externallyTerminated));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("internallyTerminated", internallyTerminated));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variables", variables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        return this.queryHistoricProcessInstances(firstResult, maxResults, historicProcessInstanceQueryDto, Collections.emptyMap());
    }

    public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoricProcessInstanceQueryDto localVarPostBody = historicProcessInstanceQueryDto;
        String localVarPath = "/history/process-instance";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<HistoricProcessInstanceDto>> localVarReturnType = new TypeReference<List<HistoricProcessInstanceDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        return this.queryHistoricProcessInstancesCount(historicProcessInstanceQueryDto, Collections.emptyMap());
    }

    public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoricProcessInstanceQueryDto localVarPostBody = historicProcessInstanceQueryDto;
        String localVarPath = "/history/process-instance/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto) throws ApiException {
        return this.setRemovalTimeAsync(setRemovalTimeToHistoricProcessInstancesDto, Collections.emptyMap());
    }

    public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
        SetRemovalTimeToHistoricProcessInstancesDto localVarPostBody = setRemovalTimeToHistoricProcessInstancesDto;
        String localVarPath = "/history/process-instance/set-removal-time";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

