/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.MetricsIntervalResultDto;
import org.camunda.community.rest.client.dto.MetricsResultDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class MetricsApi {
    private ApiClient apiClient;

    public MetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteTaskMetrics(OffsetDateTime date) throws ApiException {
        this.deleteTaskMetrics(date, Collections.emptyMap());
    }

    public void deleteTaskMetrics(OffsetDateTime date, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/metrics/task-worker";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("date", date));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public MetricsResultDto getMetrics(String metricsName, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        return this.getMetrics(metricsName, startDate, endDate, Collections.emptyMap());
    }

    public MetricsResultDto getMetrics(String metricsName, OffsetDateTime startDate, OffsetDateTime endDate, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (metricsName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricsName' when calling getMetrics");
        }
        String localVarPath = "/metrics/{metrics-name}/sum".replaceAll("\\{metrics-name\\}", this.apiClient.escapeString(metricsName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<MetricsResultDto> localVarReturnType = new TypeReference<MetricsResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<MetricsIntervalResultDto> interval(String name, String reporter, OffsetDateTime startDate, OffsetDateTime endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter) throws ApiException {
        return this.interval(name, reporter, startDate, endDate, firstResult, maxResults, interval, aggregateByReporter, Collections.emptyMap());
    }

    public List<MetricsIntervalResultDto> interval(String name, String reporter, OffsetDateTime startDate, OffsetDateTime endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/metrics";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("reporter", reporter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("interval", interval));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("aggregateByReporter", aggregateByReporter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<MetricsIntervalResultDto>> localVarReturnType = new TypeReference<List<MetricsIntervalResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

