/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CompleteTaskDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.FormDto;
import org.camunda.community.rest.client.dto.TaskBpmnErrorDto;
import org.camunda.community.rest.client.dto.TaskCountByCandidateGroupResultDto;
import org.camunda.community.rest.client.dto.TaskDto;
import org.camunda.community.rest.client.dto.TaskEscalationDto;
import org.camunda.community.rest.client.dto.TaskQueryDto;
import org.camunda.community.rest.client.dto.UserIdDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class TaskApi {
    private ApiClient apiClient;

    public TaskApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void claim(String id, UserIdDto userIdDto) throws ApiException {
        this.claim(id, userIdDto, Collections.emptyMap());
    }

    public void claim(String id, UserIdDto userIdDto, Map<String, String> additionalHeaders) throws ApiException {
        UserIdDto localVarPostBody = userIdDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling claim");
        }
        String localVarPath = "/task/{id}/claim".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Map<String, VariableValueDto> complete(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        return this.complete(id, completeTaskDto, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> complete(String id, CompleteTaskDto completeTaskDto, Map<String, String> additionalHeaders) throws ApiException {
        CompleteTaskDto localVarPostBody = completeTaskDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling complete");
        }
        String localVarPath = "/task/{id}/complete".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void createTask(TaskDto taskDto) throws ApiException {
        this.createTask(taskDto, Collections.emptyMap());
    }

    public void createTask(TaskDto taskDto, Map<String, String> additionalHeaders) throws ApiException {
        TaskDto localVarPostBody = taskDto;
        String localVarPath = "/task/create";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void delegateTask(String id, UserIdDto userIdDto) throws ApiException {
        this.delegateTask(id, userIdDto, Collections.emptyMap());
    }

    public void delegateTask(String id, UserIdDto userIdDto, Map<String, String> additionalHeaders) throws ApiException {
        UserIdDto localVarPostBody = userIdDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling delegateTask");
        }
        String localVarPath = "/task/{id}/delegate".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteTask(String id) throws ApiException {
        this.deleteTask(id, Collections.emptyMap());
    }

    public void deleteTask(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteTask");
        }
        String localVarPath = "/task/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public File getDeployedForm(String id) throws ApiException {
        return this.getDeployedForm(id, Collections.emptyMap());
    }

    public File getDeployedForm(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeployedForm");
        }
        String localVarPath = "/task/{id}/deployed-form".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FormDto getForm(String id) throws ApiException {
        return this.getForm(id, Collections.emptyMap());
    }

    public FormDto getForm(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getForm");
        }
        String localVarPath = "/task/{id}/form".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<FormDto> localVarReturnType = new TypeReference<FormDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, VariableValueDto> getFormVariables(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        return this.getFormVariables(id, variableNames, deserializeValues, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> getFormVariables(String id, String variableNames, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getFormVariables");
        }
        String localVarPath = "/task/{id}/form-variables".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNames", variableNames));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValues", deserializeValues));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getRenderedForm(String id) throws ApiException {
        return this.getRenderedForm(id, Collections.emptyMap());
    }

    public File getRenderedForm(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRenderedForm");
        }
        String localVarPath = "/task/{id}/rendered-form".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TaskDto getTask(String id) throws ApiException {
        return this.getTask(id, Collections.emptyMap());
    }

    public TaskDto getTask(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getTask");
        }
        String localVarPath = "/task/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<TaskDto> localVarReturnType = new TypeReference<TaskDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TaskCountByCandidateGroupResultDto> getTaskCountByCandidateGroup() throws ApiException {
        return this.getTaskCountByCandidateGroup(Collections.emptyMap());
    }

    public List<TaskCountByCandidateGroupResultDto> getTaskCountByCandidateGroup(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/report/candidate-group-count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/csv", "text/csv"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<TaskCountByCandidateGroupResultDto>> localVarReturnType = new TypeReference<List<TaskCountByCandidateGroupResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TaskDto> getTasks(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getTasks(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<TaskDto> getTasks(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskId", taskId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskIdIn", taskIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyExpression", processInstanceBusinessKeyExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyLikeExpression", processInstanceBusinessKeyLikeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionName", processDefinitionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceId", caseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceBusinessKey", caseInstanceBusinessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceBusinessKeyLike", caseInstanceBusinessKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionNameLike", caseDefinitionNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseExecutionId", caseExecutionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assignee", assignee));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeExpression", assigneeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeLike", assigneeLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeLikeExpression", assigneeLikeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeIn", assigneeIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeNotIn", assigneeNotIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("owner", owner));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ownerExpression", ownerExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroup", candidateGroup));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroupExpression", candidateGroupExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateUser", candidateUser));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateUserExpression", candidateUserExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeAssignedTasks", includeAssignedTasks));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("involvedUser", involvedUser));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("involvedUserExpression", involvedUserExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigned", assigned));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("unassigned", unassigned));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskDefinitionKeyLike", taskDefinitionKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameNotEqual", nameNotEqual));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameNotLike", nameNotLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("descriptionLike", descriptionLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priority", priority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxPriority", maxPriority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("minPriority", minPriority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueDate", dueDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueDateExpression", dueDateExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueAfter", dueAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueAfterExpression", dueAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueBefore", dueBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueBeforeExpression", dueBeforeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutDueDate", withoutDueDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpDate", followUpDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpDateExpression", followUpDateExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpAfter", followUpAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpAfterExpression", followUpAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBefore", followUpBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBeforeExpression", followUpBeforeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBeforeOrNotExistent", followUpBeforeOrNotExistent));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBeforeOrNotExistentExpression", followUpBeforeOrNotExistentExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdOn", createdOn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdOnExpression", createdOnExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfterExpression", createdAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBeforeExpression", createdBeforeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedAfter", updatedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedAfterExpression", updatedAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delegationState", delegationState));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroups", candidateGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroupsExpression", candidateGroupsExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withCandidateUsers", withCandidateUsers));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutCandidateUsers", withoutCandidateUsers));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskVariables", taskVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processVariables", processVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceVariables", caseInstanceVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("parentTaskId", parentTaskId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<TaskDto>> localVarReturnType = new TypeReference<List<TaskDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getTasksCount(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId) throws ApiException {
        return this.getTasksCount(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, Collections.emptyMap());
    }

    public CountResultDto getTasksCount(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskId", taskId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskIdIn", taskIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyExpression", processInstanceBusinessKeyExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceBusinessKeyLikeExpression", processInstanceBusinessKeyLikeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionName", processDefinitionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceId", caseInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceBusinessKey", caseInstanceBusinessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceBusinessKeyLike", caseInstanceBusinessKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseDefinitionNameLike", caseDefinitionNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseExecutionId", caseExecutionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assignee", assignee));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeExpression", assigneeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeLike", assigneeLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeLikeExpression", assigneeLikeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeIn", assigneeIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeNotIn", assigneeNotIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("owner", owner));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ownerExpression", ownerExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroup", candidateGroup));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroupExpression", candidateGroupExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateUser", candidateUser));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateUserExpression", candidateUserExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeAssignedTasks", includeAssignedTasks));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("involvedUser", involvedUser));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("involvedUserExpression", involvedUserExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("assigned", assigned));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("unassigned", unassigned));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskDefinitionKeyLike", taskDefinitionKeyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameNotEqual", nameNotEqual));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameNotLike", nameNotLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("descriptionLike", descriptionLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priority", priority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxPriority", maxPriority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("minPriority", minPriority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueDate", dueDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueDateExpression", dueDateExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueAfter", dueAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueAfterExpression", dueAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueBefore", dueBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueBeforeExpression", dueBeforeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutDueDate", withoutDueDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpDate", followUpDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpDateExpression", followUpDateExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpAfter", followUpAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpAfterExpression", followUpAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBefore", followUpBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBeforeExpression", followUpBeforeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBeforeOrNotExistent", followUpBeforeOrNotExistent));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("followUpBeforeOrNotExistentExpression", followUpBeforeOrNotExistentExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdOn", createdOn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdOnExpression", createdOnExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfterExpression", createdAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBeforeExpression", createdBeforeExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedAfter", updatedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedAfterExpression", updatedAfterExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delegationState", delegationState));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroups", candidateGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("candidateGroupsExpression", candidateGroupsExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withCandidateUsers", withCandidateUsers));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutCandidateUsers", withoutCandidateUsers));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskVariables", taskVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processVariables", processVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("caseInstanceVariables", caseInstanceVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("parentTaskId", parentTaskId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void handleBpmnError(String id, TaskBpmnErrorDto taskBpmnErrorDto) throws ApiException {
        this.handleBpmnError(id, taskBpmnErrorDto, Collections.emptyMap());
    }

    public void handleBpmnError(String id, TaskBpmnErrorDto taskBpmnErrorDto, Map<String, String> additionalHeaders) throws ApiException {
        TaskBpmnErrorDto localVarPostBody = taskBpmnErrorDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling handleBpmnError");
        }
        String localVarPath = "/task/{id}/bpmnError".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void handleEscalation(String id, TaskEscalationDto taskEscalationDto) throws ApiException {
        this.handleEscalation(id, taskEscalationDto, Collections.emptyMap());
    }

    public void handleEscalation(String id, TaskEscalationDto taskEscalationDto, Map<String, String> additionalHeaders) throws ApiException {
        TaskEscalationDto localVarPostBody = taskEscalationDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling handleEscalation");
        }
        String localVarPath = "/task/{id}/bpmnEscalation".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<TaskDto> queryTasks(Integer firstResult, Integer maxResults, TaskQueryDto taskQueryDto) throws ApiException {
        return this.queryTasks(firstResult, maxResults, taskQueryDto, Collections.emptyMap());
    }

    public List<TaskDto> queryTasks(Integer firstResult, Integer maxResults, TaskQueryDto taskQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        TaskQueryDto localVarPostBody = taskQueryDto;
        String localVarPath = "/task";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<TaskDto>> localVarReturnType = new TypeReference<List<TaskDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto queryTasksCount(TaskQueryDto taskQueryDto) throws ApiException {
        return this.queryTasksCount(taskQueryDto, Collections.emptyMap());
    }

    public CountResultDto queryTasksCount(TaskQueryDto taskQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        TaskQueryDto localVarPostBody = taskQueryDto;
        String localVarPath = "/task/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void resolve(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        this.resolve(id, completeTaskDto, Collections.emptyMap());
    }

    public void resolve(String id, CompleteTaskDto completeTaskDto, Map<String, String> additionalHeaders) throws ApiException {
        CompleteTaskDto localVarPostBody = completeTaskDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling resolve");
        }
        String localVarPath = "/task/{id}/resolve".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setAssignee(String id, UserIdDto userIdDto) throws ApiException {
        this.setAssignee(id, userIdDto, Collections.emptyMap());
    }

    public void setAssignee(String id, UserIdDto userIdDto, Map<String, String> additionalHeaders) throws ApiException {
        UserIdDto localVarPostBody = userIdDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setAssignee");
        }
        String localVarPath = "/task/{id}/assignee".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Map<String, VariableValueDto> submit(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        return this.submit(id, completeTaskDto, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> submit(String id, CompleteTaskDto completeTaskDto, Map<String, String> additionalHeaders) throws ApiException {
        CompleteTaskDto localVarPostBody = completeTaskDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling submit");
        }
        String localVarPath = "/task/{id}/submit-form".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unclaim(String id) throws ApiException {
        this.unclaim(id, Collections.emptyMap());
    }

    public void unclaim(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling unclaim");
        }
        String localVarPath = "/task/{id}/unclaim".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateTask(String id, TaskDto taskDto) throws ApiException {
        this.updateTask(id, taskDto, Collections.emptyMap());
    }

    public void updateTask(String id, TaskDto taskDto, Map<String, String> additionalHeaders) throws ApiException {
        TaskDto localVarPostBody = taskDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateTask");
        }
        String localVarPath = "/task/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

