/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.PatchVariablesDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class TaskVariableApi {
    private ApiClient apiClient;

    public TaskVariableApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskVariableApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteTaskVariable(String id, String varName) throws ApiException {
        this.deleteTaskVariable(id, varName, Collections.emptyMap());
    }

    public void deleteTaskVariable(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteTaskVariable");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling deleteTaskVariable");
        }
        String localVarPath = "/task/{id}/variables/{varName}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.apiClient.escapeString(varName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public VariableValueDto getTaskVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
        return this.getTaskVariable(id, varName, deserializeValue, Collections.emptyMap());
    }

    public VariableValueDto getTaskVariable(String id, String varName, Boolean deserializeValue, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getTaskVariable");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling getTaskVariable");
        }
        String localVarPath = "/task/{id}/variables/{varName}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.apiClient.escapeString(varName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValue", deserializeValue));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<VariableValueDto> localVarReturnType = new TypeReference<VariableValueDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getTaskVariableBinary(String id, String varName) throws ApiException {
        return this.getTaskVariableBinary(id, varName, Collections.emptyMap());
    }

    public File getTaskVariableBinary(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getTaskVariableBinary");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling getTaskVariableBinary");
        }
        String localVarPath = "/task/{id}/variables/{varName}/data".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.apiClient.escapeString(varName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "text/plain", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, VariableValueDto> getTaskVariables(String id, Boolean deserializeValues) throws ApiException {
        return this.getTaskVariables(id, deserializeValues, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> getTaskVariables(String id, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getTaskVariables");
        }
        String localVarPath = "/task/{id}/variables".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValues", deserializeValues));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void modifyTaskVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        this.modifyTaskVariables(id, patchVariablesDto, Collections.emptyMap());
    }

    public void modifyTaskVariables(String id, PatchVariablesDto patchVariablesDto, Map<String, String> additionalHeaders) throws ApiException {
        PatchVariablesDto localVarPostBody = patchVariablesDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling modifyTaskVariables");
        }
        String localVarPath = "/task/{id}/variables".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void putTaskVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        this.putTaskVariable(id, varName, variableValueDto, Collections.emptyMap());
    }

    public void putTaskVariable(String id, String varName, VariableValueDto variableValueDto, Map<String, String> additionalHeaders) throws ApiException {
        VariableValueDto localVarPostBody = variableValueDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling putTaskVariable");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling putTaskVariable");
        }
        String localVarPath = "/task/{id}/variables/{varName}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.apiClient.escapeString(varName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setBinaryTaskVariable(String id, String varName, File data, String valueType) throws ApiException {
        this.setBinaryTaskVariable(id, varName, data, valueType, Collections.emptyMap());
    }

    public void setBinaryTaskVariable(String id, String varName, File data, String valueType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setBinaryTaskVariable");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling setBinaryTaskVariable");
        }
        String localVarPath = "/task/{id}/variables/{varName}/data".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.apiClient.escapeString(varName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (valueType != null) {
            localVarFormParams.put("valueType", valueType);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

