/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ExecutionDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"resultType", "processInstance", "execution", "variables"})
public class MessageCorrelationResultWithVariableDto {
    public static final String JSON_PROPERTY_RESULT_TYPE = "resultType";
    private JsonNullable<ResultTypeEnum> resultType = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_INSTANCE = "processInstance";
    private ProcessInstanceDto processInstance;
    public static final String JSON_PROPERTY_EXECUTION = "execution";
    private ExecutionDto execution;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.undefined();

    public MessageCorrelationResultWithVariableDto resultType(ResultTypeEnum resultType) {
        this.resultType = JsonNullable.of((Object)((Object)resultType));
        return this;
    }

    @Nullable
    @JsonIgnore
    public ResultTypeEnum getResultType() {
        return (ResultTypeEnum)((Object)this.resultType.orElse(null));
    }

    @JsonProperty(value="resultType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ResultTypeEnum> getResultType_JsonNullable() {
        return this.resultType;
    }

    @JsonProperty(value="resultType")
    public void setResultType_JsonNullable(JsonNullable<ResultTypeEnum> resultType) {
        this.resultType = resultType;
    }

    public void setResultType(ResultTypeEnum resultType) {
        this.resultType = JsonNullable.of((Object)((Object)resultType));
    }

    public MessageCorrelationResultWithVariableDto processInstance(ProcessInstanceDto processInstance) {
        this.processInstance = processInstance;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessInstanceDto getProcessInstance() {
        return this.processInstance;
    }

    @JsonProperty(value="processInstance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstance(ProcessInstanceDto processInstance) {
        this.processInstance = processInstance;
    }

    public MessageCorrelationResultWithVariableDto execution(ExecutionDto execution) {
        this.execution = execution;
        return this;
    }

    @Nullable
    @JsonProperty(value="execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExecutionDto getExecution() {
        return this.execution;
    }

    @JsonProperty(value="execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecution(ExecutionDto execution) {
        this.execution = execution;
    }

    public MessageCorrelationResultWithVariableDto variables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
        return this;
    }

    public MessageCorrelationResultWithVariableDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null || !this.variables.isPresent()) {
            this.variables = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.variables.get()).put(key, variablesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public Map<String, VariableValueDto> getVariables() {
        return (Map)this.variables.orElse(null);
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageCorrelationResultWithVariableDto messageCorrelationResultWithVariableDto = (MessageCorrelationResultWithVariableDto)o;
        return MessageCorrelationResultWithVariableDto.equalsNullable(this.resultType, messageCorrelationResultWithVariableDto.resultType) && Objects.equals(this.processInstance, messageCorrelationResultWithVariableDto.processInstance) && Objects.equals(this.execution, messageCorrelationResultWithVariableDto.execution) && MessageCorrelationResultWithVariableDto.equalsNullable(this.variables, messageCorrelationResultWithVariableDto.variables);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(MessageCorrelationResultWithVariableDto.hashCodeNullable(this.resultType), this.processInstance, this.execution, MessageCorrelationResultWithVariableDto.hashCodeNullable(this.variables));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageCorrelationResultWithVariableDto {\n");
        sb.append("    resultType: ").append(this.toIndentedString(this.resultType)).append("\n");
        sb.append("    processInstance: ").append(this.toIndentedString(this.processInstance)).append("\n");
        sb.append("    execution: ").append(this.toIndentedString(this.execution)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getResultType() != null) {
            try {
                joiner.add(String.format("%sresultType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getResultType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessInstance() != null) {
            joiner.add(this.getProcessInstance().toUrlQueryString(prefix + JSON_PROPERTY_PROCESS_INSTANCE + suffix));
        }
        if (this.getExecution() != null) {
            joiner.add(this.getExecution().toUrlQueryString(prefix + JSON_PROPERTY_EXECUTION + suffix));
        }
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                if (this.getVariables().get(_key) == null) continue;
                joiner.add(this.getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum ResultTypeEnum {
        EXECUTION("Execution"),
        PROCESSDEFINITION("ProcessDefinition");

        private String value;

        private ResultTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultTypeEnum fromValue(String value) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

