/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"processInstanceIds", "processInstanceQuery", "historicProcessInstanceQuery", "variables"})
public class SetVariablesAsyncDto {
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_IDS = "processInstanceIds";
    private JsonNullable<List<String>> processInstanceIds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
    private ProcessInstanceQueryDto processInstanceQuery;
    public static final String JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
    private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.undefined();

    public SetVariablesAsyncDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = JsonNullable.of(processInstanceIds);
        return this;
    }

    public SetVariablesAsyncDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null || !this.processInstanceIds.isPresent()) {
            this.processInstanceIds = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.processInstanceIds.get()).add(processInstanceIdsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getProcessInstanceIds() {
        return (List)this.processInstanceIds.orElse(null);
    }

    @JsonProperty(value="processInstanceIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getProcessInstanceIds_JsonNullable() {
        return this.processInstanceIds;
    }

    @JsonProperty(value="processInstanceIds")
    public void setProcessInstanceIds_JsonNullable(JsonNullable<List<String>> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = JsonNullable.of(processInstanceIds);
    }

    public SetVariablesAsyncDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    @JsonProperty(value="processInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public SetVariablesAsyncDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="historicProcessInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    @JsonProperty(value="historicProcessInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public SetVariablesAsyncDto variables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
        return this;
    }

    public SetVariablesAsyncDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null || !this.variables.isPresent()) {
            this.variables = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.variables.get()).put(key, variablesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public Map<String, VariableValueDto> getVariables() {
        return (Map)this.variables.orElse(null);
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetVariablesAsyncDto setVariablesAsyncDto = (SetVariablesAsyncDto)o;
        return SetVariablesAsyncDto.equalsNullable(this.processInstanceIds, setVariablesAsyncDto.processInstanceIds) && Objects.equals(this.processInstanceQuery, setVariablesAsyncDto.processInstanceQuery) && Objects.equals(this.historicProcessInstanceQuery, setVariablesAsyncDto.historicProcessInstanceQuery) && SetVariablesAsyncDto.equalsNullable(this.variables, setVariablesAsyncDto.variables);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(SetVariablesAsyncDto.hashCodeNullable(this.processInstanceIds), this.processInstanceQuery, this.historicProcessInstanceQuery, SetVariablesAsyncDto.hashCodeNullable(this.variables));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetVariablesAsyncDto {\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    processInstanceQuery: ").append(this.toIndentedString(this.processInstanceQuery)).append("\n");
        sb.append("    historicProcessInstanceQuery: ").append(this.toIndentedString(this.historicProcessInstanceQuery)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getProcessInstanceIds() != null) {
            for (int i = 0; i < this.getProcessInstanceIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sprocessInstanceIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getProcessInstanceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getProcessInstanceQuery() != null) {
            joiner.add(this.getProcessInstanceQuery().toUrlQueryString(prefix + JSON_PROPERTY_PROCESS_INSTANCE_QUERY + suffix));
        }
        if (this.getHistoricProcessInstanceQuery() != null) {
            joiner.add(this.getHistoricProcessInstanceQuery().toUrlQueryString(prefix + JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY + suffix));
        }
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                if (this.getVariables().get(_key) == null) continue;
                joiner.add(this.getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

