/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.AbstractVendorVersionInformationDto;
import org.camunda.community.rest.client.dto.TelemetryCountDto;
import org.camunda.community.rest.client.dto.TelemetryLicenseKeyDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"database", "application-server", "license-key", "camunda-integration", "commands", "metrics", "webapps", "jdk", "data-collection-start-date"})
public class TelemetryInternalsDto {
    public static final String JSON_PROPERTY_DATABASE = "database";
    private AbstractVendorVersionInformationDto database;
    public static final String JSON_PROPERTY_APPLICATION_SERVER = "application-server";
    private AbstractVendorVersionInformationDto applicationServer;
    public static final String JSON_PROPERTY_LICENSE_KEY = "license-key";
    private TelemetryLicenseKeyDto licenseKey;
    public static final String JSON_PROPERTY_CAMUNDA_INTEGRATION = "camunda-integration";
    private JsonNullable<List<String>> camundaIntegration = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COMMANDS = "commands";
    private JsonNullable<Map<String, TelemetryCountDto>> commands = JsonNullable.undefined();
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private JsonNullable<Map<String, TelemetryCountDto>> metrics = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WEBAPPS = "webapps";
    private JsonNullable<List<String>> webapps = JsonNullable.undefined();
    public static final String JSON_PROPERTY_JDK = "jdk";
    private AbstractVendorVersionInformationDto jdk;
    public static final String JSON_PROPERTY_DATA_COLLECTION_START_DATE = "data-collection-start-date";
    private OffsetDateTime dataCollectionStartDate;

    public TelemetryInternalsDto database(AbstractVendorVersionInformationDto database) {
        this.database = database;
        return this;
    }

    @Nullable
    @JsonProperty(value="database")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AbstractVendorVersionInformationDto getDatabase() {
        return this.database;
    }

    @JsonProperty(value="database")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatabase(AbstractVendorVersionInformationDto database) {
        this.database = database;
    }

    public TelemetryInternalsDto applicationServer(AbstractVendorVersionInformationDto applicationServer) {
        this.applicationServer = applicationServer;
        return this;
    }

    @Nullable
    @JsonProperty(value="application-server")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AbstractVendorVersionInformationDto getApplicationServer() {
        return this.applicationServer;
    }

    @JsonProperty(value="application-server")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationServer(AbstractVendorVersionInformationDto applicationServer) {
        this.applicationServer = applicationServer;
    }

    public TelemetryInternalsDto licenseKey(TelemetryLicenseKeyDto licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="license-key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TelemetryLicenseKeyDto getLicenseKey() {
        return this.licenseKey;
    }

    @JsonProperty(value="license-key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseKey(TelemetryLicenseKeyDto licenseKey) {
        this.licenseKey = licenseKey;
    }

    public TelemetryInternalsDto camundaIntegration(List<String> camundaIntegration) {
        this.camundaIntegration = JsonNullable.of(camundaIntegration);
        return this;
    }

    public TelemetryInternalsDto addCamundaIntegrationItem(String camundaIntegrationItem) {
        if (this.camundaIntegration == null || !this.camundaIntegration.isPresent()) {
            this.camundaIntegration = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.camundaIntegration.get()).add(camundaIntegrationItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getCamundaIntegration() {
        return (List)this.camundaIntegration.orElse(null);
    }

    @JsonProperty(value="camunda-integration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getCamundaIntegration_JsonNullable() {
        return this.camundaIntegration;
    }

    @JsonProperty(value="camunda-integration")
    public void setCamundaIntegration_JsonNullable(JsonNullable<List<String>> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    public void setCamundaIntegration(List<String> camundaIntegration) {
        this.camundaIntegration = JsonNullable.of(camundaIntegration);
    }

    public TelemetryInternalsDto commands(Map<String, TelemetryCountDto> commands) {
        this.commands = JsonNullable.of(commands);
        return this;
    }

    public TelemetryInternalsDto putCommandsItem(String key, TelemetryCountDto commandsItem) {
        if (this.commands == null || !this.commands.isPresent()) {
            this.commands = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.commands.get()).put(key, commandsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public Map<String, TelemetryCountDto> getCommands() {
        return (Map)this.commands.orElse(null);
    }

    @JsonProperty(value="commands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, TelemetryCountDto>> getCommands_JsonNullable() {
        return this.commands;
    }

    @JsonProperty(value="commands")
    public void setCommands_JsonNullable(JsonNullable<Map<String, TelemetryCountDto>> commands) {
        this.commands = commands;
    }

    public void setCommands(Map<String, TelemetryCountDto> commands) {
        this.commands = JsonNullable.of(commands);
    }

    public TelemetryInternalsDto metrics(Map<String, TelemetryCountDto> metrics) {
        this.metrics = JsonNullable.of(metrics);
        return this;
    }

    public TelemetryInternalsDto putMetricsItem(String key, TelemetryCountDto metricsItem) {
        if (this.metrics == null || !this.metrics.isPresent()) {
            this.metrics = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.metrics.get()).put(key, metricsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public Map<String, TelemetryCountDto> getMetrics() {
        return (Map)this.metrics.orElse(null);
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, TelemetryCountDto>> getMetrics_JsonNullable() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    public void setMetrics_JsonNullable(JsonNullable<Map<String, TelemetryCountDto>> metrics) {
        this.metrics = metrics;
    }

    public void setMetrics(Map<String, TelemetryCountDto> metrics) {
        this.metrics = JsonNullable.of(metrics);
    }

    public TelemetryInternalsDto webapps(List<String> webapps) {
        this.webapps = JsonNullable.of(webapps);
        return this;
    }

    public TelemetryInternalsDto addWebappsItem(String webappsItem) {
        if (this.webapps == null || !this.webapps.isPresent()) {
            this.webapps = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.webapps.get()).add(webappsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getWebapps() {
        return (List)this.webapps.orElse(null);
    }

    @JsonProperty(value="webapps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getWebapps_JsonNullable() {
        return this.webapps;
    }

    @JsonProperty(value="webapps")
    public void setWebapps_JsonNullable(JsonNullable<List<String>> webapps) {
        this.webapps = webapps;
    }

    public void setWebapps(List<String> webapps) {
        this.webapps = JsonNullable.of(webapps);
    }

    public TelemetryInternalsDto jdk(AbstractVendorVersionInformationDto jdk) {
        this.jdk = jdk;
        return this;
    }

    @Nullable
    @JsonProperty(value="jdk")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AbstractVendorVersionInformationDto getJdk() {
        return this.jdk;
    }

    @JsonProperty(value="jdk")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJdk(AbstractVendorVersionInformationDto jdk) {
        this.jdk = jdk;
    }

    public TelemetryInternalsDto dataCollectionStartDate(OffsetDateTime dataCollectionStartDate) {
        this.dataCollectionStartDate = dataCollectionStartDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="data-collection-start-date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDataCollectionStartDate() {
        return this.dataCollectionStartDate;
    }

    @JsonProperty(value="data-collection-start-date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataCollectionStartDate(OffsetDateTime dataCollectionStartDate) {
        this.dataCollectionStartDate = dataCollectionStartDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryInternalsDto telemetryInternalsDto = (TelemetryInternalsDto)o;
        return Objects.equals(this.database, telemetryInternalsDto.database) && Objects.equals(this.applicationServer, telemetryInternalsDto.applicationServer) && Objects.equals(this.licenseKey, telemetryInternalsDto.licenseKey) && TelemetryInternalsDto.equalsNullable(this.camundaIntegration, telemetryInternalsDto.camundaIntegration) && TelemetryInternalsDto.equalsNullable(this.commands, telemetryInternalsDto.commands) && TelemetryInternalsDto.equalsNullable(this.metrics, telemetryInternalsDto.metrics) && TelemetryInternalsDto.equalsNullable(this.webapps, telemetryInternalsDto.webapps) && Objects.equals(this.jdk, telemetryInternalsDto.jdk) && Objects.equals(this.dataCollectionStartDate, telemetryInternalsDto.dataCollectionStartDate);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.database, this.applicationServer, this.licenseKey, TelemetryInternalsDto.hashCodeNullable(this.camundaIntegration), TelemetryInternalsDto.hashCodeNullable(this.commands), TelemetryInternalsDto.hashCodeNullable(this.metrics), TelemetryInternalsDto.hashCodeNullable(this.webapps), this.jdk, this.dataCollectionStartDate);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryInternalsDto {\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    applicationServer: ").append(this.toIndentedString(this.applicationServer)).append("\n");
        sb.append("    licenseKey: ").append(this.toIndentedString(this.licenseKey)).append("\n");
        sb.append("    camundaIntegration: ").append(this.toIndentedString(this.camundaIntegration)).append("\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    webapps: ").append(this.toIndentedString(this.webapps)).append("\n");
        sb.append("    jdk: ").append(this.toIndentedString(this.jdk)).append("\n");
        sb.append("    dataCollectionStartDate: ").append(this.toIndentedString(this.dataCollectionStartDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDatabase() != null) {
            joiner.add(this.getDatabase().toUrlQueryString(prefix + JSON_PROPERTY_DATABASE + suffix));
        }
        if (this.getApplicationServer() != null) {
            joiner.add(this.getApplicationServer().toUrlQueryString(prefix + JSON_PROPERTY_APPLICATION_SERVER + suffix));
        }
        if (this.getLicenseKey() != null) {
            joiner.add(this.getLicenseKey().toUrlQueryString(prefix + JSON_PROPERTY_LICENSE_KEY + suffix));
        }
        if (this.getCamundaIntegration() != null) {
            for (i = 0; i < this.getCamundaIntegration().size(); ++i) {
                try {
                    joiner.add(String.format("%scamunda-integration%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCamundaIntegration().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCommands() != null) {
            for (String _key : this.getCommands().keySet()) {
                if (this.getCommands().get(_key) == null) continue;
                joiner.add(this.getCommands().get(_key).toUrlQueryString(String.format("%scommands%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getMetrics() != null) {
            for (String _key : this.getMetrics().keySet()) {
                if (this.getMetrics().get(_key) == null) continue;
                joiner.add(this.getMetrics().get(_key).toUrlQueryString(String.format("%smetrics%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getWebapps() != null) {
            for (i = 0; i < this.getWebapps().size(); ++i) {
                try {
                    joiner.add(String.format("%swebapps%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getWebapps().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getJdk() != null) {
            joiner.add(this.getJdk().toUrlQueryString(prefix + JSON_PROPERTY_JDK + suffix));
        }
        if (this.getDataCollectionStartDate() != null) {
            try {
                joiner.add(String.format("%sdata-collection-start-date%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDataCollectionStartDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

