/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.AnnotationDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.IncidentDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class IncidentApi {
    private ApiClient apiClient;

    public IncidentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void clearIncidentAnnotation(String id) throws ApiException {
        this.clearIncidentAnnotation(id, Collections.emptyMap());
    }

    public void clearIncidentAnnotation(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling clearIncidentAnnotation");
        }
        String localVarPath = "/incident/{id}/annotation".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public IncidentDto getIncident(String id) throws ApiException {
        return this.getIncident(id, Collections.emptyMap());
    }

    public IncidentDto getIncident(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getIncident");
        }
        String localVarPath = "/incident/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<IncidentDto> localVarReturnType = new TypeReference<IncidentDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IncidentDto> getIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getIncidents(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<IncidentDto> getIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/incident";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentId", incidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedActivityId", failedActivityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("causeIncidentId", causeIncidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("configuration", _configuration));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<IncidentDto>> localVarReturnType = new TypeReference<List<IncidentDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn) throws ApiException {
        return this.getIncidentsCount(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, Collections.emptyMap());
    }

    public CountResultDto getIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/incident/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentId", incidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedActivityId", failedActivityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("causeIncidentId", causeIncidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("configuration", _configuration));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void resolveIncident(String id) throws ApiException {
        this.resolveIncident(id, Collections.emptyMap());
    }

    public void resolveIncident(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling resolveIncident");
        }
        String localVarPath = "/incident/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setIncidentAnnotation(String id, AnnotationDto annotationDto) throws ApiException {
        this.setIncidentAnnotation(id, annotationDto, Collections.emptyMap());
    }

    public void setIncidentAnnotation(String id, AnnotationDto annotationDto, Map<String, String> additionalHeaders) throws ApiException {
        AnnotationDto localVarPostBody = annotationDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setIncidentAnnotation");
        }
        String localVarPath = "/incident/{id}/annotation".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

