/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.JobDto;
import org.camunda.community.rest.client.dto.JobDuedateDto;
import org.camunda.community.rest.client.dto.JobQueryDto;
import org.camunda.community.rest.client.dto.JobRetriesDto;
import org.camunda.community.rest.client.dto.JobSuspensionStateDto;
import org.camunda.community.rest.client.dto.PriorityDto;
import org.camunda.community.rest.client.dto.SetJobRetriesDto;
import org.camunda.community.rest.client.dto.SuspensionStateDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class JobApi {
    private ApiClient apiClient;

    public JobApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JobApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteJob(String id) throws ApiException {
        this.deleteJob(id, Collections.emptyMap());
    }

    public void deleteJob(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteJob");
        }
        String localVarPath = "/job/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void executeJob(String id) throws ApiException {
        this.executeJob(id, Collections.emptyMap());
    }

    public void executeJob(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling executeJob");
        }
        String localVarPath = "/job/{id}/execute".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public JobDto getJob(String id) throws ApiException {
        return this.getJob(id, Collections.emptyMap());
    }

    public JobDto getJob(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getJob");
        }
        String localVarPath = "/job/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<JobDto> localVarReturnType = new TypeReference<JobDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JobDto> getJobs(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getJobs(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<JobDto> getJobs(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobId", jobId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobIds", jobIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIds", processInstanceIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executable", executable));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("timers", timers));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("messages", messages));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueDates", dueDates));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createTimes", createTimes));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withException", withException));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("exceptionMessage", exceptionMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedActivityId", failedActivityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<JobDto>> localVarReturnType = new TypeReference<List<JobDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getJobsCount(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId) throws ApiException {
        return this.getJobsCount(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, Collections.emptyMap());
    }

    public CountResultDto getJobsCount(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobId", jobId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobIds", jobIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIds", processInstanceIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executable", executable));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("timers", timers));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("messages", messages));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dueDates", dueDates));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createTimes", createTimes));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withException", withException));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("exceptionMessage", exceptionMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedActivityId", failedActivityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object getStacktrace(String id) throws ApiException {
        return this.getStacktrace(id, Collections.emptyMap());
    }

    public Object getStacktrace(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getStacktrace");
        }
        String localVarPath = "/job/{id}/stacktrace".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/plain", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Object> localVarReturnType = new TypeReference<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JobDto> queryJobs(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto) throws ApiException {
        return this.queryJobs(firstResult, maxResults, jobQueryDto, Collections.emptyMap());
    }

    public List<JobDto> queryJobs(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        JobQueryDto localVarPostBody = jobQueryDto;
        String localVarPath = "/job";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<JobDto>> localVarReturnType = new TypeReference<List<JobDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto queryJobsCount(JobQueryDto jobQueryDto) throws ApiException {
        return this.queryJobsCount(jobQueryDto, Collections.emptyMap());
    }

    public CountResultDto queryJobsCount(JobQueryDto jobQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        JobQueryDto localVarPostBody = jobQueryDto;
        String localVarPath = "/job/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void recalculateDuedate(String id, Boolean creationDateBased) throws ApiException {
        this.recalculateDuedate(id, creationDateBased, Collections.emptyMap());
    }

    public void recalculateDuedate(String id, Boolean creationDateBased, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling recalculateDuedate");
        }
        String localVarPath = "/job/{id}/duedate/recalculate".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("creationDateBased", creationDateBased));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setJobDuedate(String id, JobDuedateDto jobDuedateDto) throws ApiException {
        this.setJobDuedate(id, jobDuedateDto, Collections.emptyMap());
    }

    public void setJobDuedate(String id, JobDuedateDto jobDuedateDto, Map<String, String> additionalHeaders) throws ApiException {
        JobDuedateDto localVarPostBody = jobDuedateDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setJobDuedate");
        }
        String localVarPath = "/job/{id}/duedate".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setJobPriority(String id, PriorityDto priorityDto) throws ApiException {
        this.setJobPriority(id, priorityDto, Collections.emptyMap());
    }

    public void setJobPriority(String id, PriorityDto priorityDto, Map<String, String> additionalHeaders) throws ApiException {
        PriorityDto localVarPostBody = priorityDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setJobPriority");
        }
        String localVarPath = "/job/{id}/priority".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setJobRetries(String id, JobRetriesDto jobRetriesDto) throws ApiException {
        this.setJobRetries(id, jobRetriesDto, Collections.emptyMap());
    }

    public void setJobRetries(String id, JobRetriesDto jobRetriesDto, Map<String, String> additionalHeaders) throws ApiException {
        JobRetriesDto localVarPostBody = jobRetriesDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setJobRetries");
        }
        String localVarPath = "/job/{id}/retries".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BatchDto setJobRetriesAsyncOperation(SetJobRetriesDto setJobRetriesDto) throws ApiException {
        return this.setJobRetriesAsyncOperation(setJobRetriesDto, Collections.emptyMap());
    }

    public BatchDto setJobRetriesAsyncOperation(SetJobRetriesDto setJobRetriesDto, Map<String, String> additionalHeaders) throws ApiException {
        SetJobRetriesDto localVarPostBody = setJobRetriesDto;
        String localVarPath = "/job/retries";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateJobSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        this.updateJobSuspensionState(id, suspensionStateDto, Collections.emptyMap());
    }

    public void updateJobSuspensionState(String id, SuspensionStateDto suspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        SuspensionStateDto localVarPostBody = suspensionStateDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateJobSuspensionState");
        }
        String localVarPath = "/job/{id}/suspended".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateSuspensionStateBy(JobSuspensionStateDto jobSuspensionStateDto) throws ApiException {
        this.updateSuspensionStateBy(jobSuspensionStateDto, Collections.emptyMap());
    }

    public void updateSuspensionStateBy(JobSuspensionStateDto jobSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        JobSuspensionStateDto localVarPostBody = jobSuspensionStateDto;
        String localVarPath = "/job/suspended";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

