/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"authenticatedUser", "authenticated", "tenants", "groups"})
public class AuthenticationResult {
    public static final String JSON_PROPERTY_AUTHENTICATED_USER = "authenticatedUser";
    private JsonNullable<String> authenticatedUser = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AUTHENTICATED = "authenticated";
    private JsonNullable<Boolean> authenticated = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TENANTS = "tenants";
    private JsonNullable<List<String>> tenants = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private JsonNullable<List<String>> groups = JsonNullable.undefined();

    public AuthenticationResult authenticatedUser(String authenticatedUser) {
        this.authenticatedUser = JsonNullable.of((Object)authenticatedUser);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getAuthenticatedUser() {
        return (String)this.authenticatedUser.orElse(null);
    }

    @JsonProperty(value="authenticatedUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAuthenticatedUser_JsonNullable() {
        return this.authenticatedUser;
    }

    @JsonProperty(value="authenticatedUser")
    public void setAuthenticatedUser_JsonNullable(JsonNullable<String> authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public void setAuthenticatedUser(String authenticatedUser) {
        this.authenticatedUser = JsonNullable.of((Object)authenticatedUser);
    }

    public AuthenticationResult authenticated(Boolean authenticated) {
        this.authenticated = JsonNullable.of((Object)authenticated);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getAuthenticated() {
        return (Boolean)this.authenticated.orElse(null);
    }

    @JsonProperty(value="authenticated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getAuthenticated_JsonNullable() {
        return this.authenticated;
    }

    @JsonProperty(value="authenticated")
    public void setAuthenticated_JsonNullable(JsonNullable<Boolean> authenticated) {
        this.authenticated = authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = JsonNullable.of((Object)authenticated);
    }

    public AuthenticationResult tenants(List<String> tenants) {
        this.tenants = JsonNullable.of(tenants);
        return this;
    }

    public AuthenticationResult addTenantsItem(String tenantsItem) {
        if (this.tenants == null || !this.tenants.isPresent()) {
            this.tenants = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.tenants.get()).add(tenantsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getTenants() {
        return (List)this.tenants.orElse(null);
    }

    @JsonProperty(value="tenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getTenants_JsonNullable() {
        return this.tenants;
    }

    @JsonProperty(value="tenants")
    public void setTenants_JsonNullable(JsonNullable<List<String>> tenants) {
        this.tenants = tenants;
    }

    public void setTenants(List<String> tenants) {
        this.tenants = JsonNullable.of(tenants);
    }

    public AuthenticationResult groups(List<String> groups) {
        this.groups = JsonNullable.of(groups);
        return this;
    }

    public AuthenticationResult addGroupsItem(String groupsItem) {
        if (this.groups == null || !this.groups.isPresent()) {
            this.groups = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.groups.get()).add(groupsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getGroups() {
        return (List)this.groups.orElse(null);
    }

    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getGroups_JsonNullable() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    public void setGroups_JsonNullable(JsonNullable<List<String>> groups) {
        this.groups = groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = JsonNullable.of(groups);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationResult authenticationResult = (AuthenticationResult)o;
        return AuthenticationResult.equalsNullable(this.authenticatedUser, authenticationResult.authenticatedUser) && AuthenticationResult.equalsNullable(this.authenticated, authenticationResult.authenticated) && AuthenticationResult.equalsNullable(this.tenants, authenticationResult.tenants) && AuthenticationResult.equalsNullable(this.groups, authenticationResult.groups);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(AuthenticationResult.hashCodeNullable(this.authenticatedUser), AuthenticationResult.hashCodeNullable(this.authenticated), AuthenticationResult.hashCodeNullable(this.tenants), AuthenticationResult.hashCodeNullable(this.groups));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationResult {\n");
        sb.append("    authenticatedUser: ").append(this.toIndentedString(this.authenticatedUser)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("    tenants: ").append(this.toIndentedString(this.tenants)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAuthenticatedUser() != null) {
            try {
                joiner.add(String.format("%sauthenticatedUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthenticatedUser()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAuthenticated() != null) {
            try {
                joiner.add(String.format("%sauthenticated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthenticated()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTenants() != null) {
            for (i = 0; i < this.getTenants().size(); ++i) {
                try {
                    joiner.add(String.format("%stenants%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTenants().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getGroups() != null) {
            for (i = 0; i < this.getGroups().size(); ++i) {
                try {
                    joiner.add(String.format("%sgroups%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

