/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.TelemetryProductDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"installation", "product"})
public class TelemetryDataDto {
    public static final String JSON_PROPERTY_INSTALLATION = "installation";
    private JsonNullable<String> installation = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRODUCT = "product";
    private TelemetryProductDto product;

    public TelemetryDataDto installation(String installation) {
        this.installation = JsonNullable.of((Object)installation);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getInstallation() {
        return (String)this.installation.orElse(null);
    }

    @JsonProperty(value="installation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getInstallation_JsonNullable() {
        return this.installation;
    }

    @JsonProperty(value="installation")
    public void setInstallation_JsonNullable(JsonNullable<String> installation) {
        this.installation = installation;
    }

    public void setInstallation(String installation) {
        this.installation = JsonNullable.of((Object)installation);
    }

    public TelemetryDataDto product(TelemetryProductDto product) {
        this.product = product;
        return this;
    }

    @Nullable
    @JsonProperty(value="product")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TelemetryProductDto getProduct() {
        return this.product;
    }

    @JsonProperty(value="product")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProduct(TelemetryProductDto product) {
        this.product = product;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryDataDto telemetryDataDto = (TelemetryDataDto)o;
        return TelemetryDataDto.equalsNullable(this.installation, telemetryDataDto.installation) && Objects.equals(this.product, telemetryDataDto.product);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(TelemetryDataDto.hashCodeNullable(this.installation), this.product);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryDataDto {\n");
        sb.append("    installation: ").append(this.toIndentedString(this.installation)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInstallation() != null) {
            try {
                joiner.add(String.format("%sinstallation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getInstallation()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProduct() != null) {
            joiner.add(this.getProduct().toUrlQueryString(prefix + JSON_PROPERTY_PRODUCT + suffix));
        }
        return joiner.toString();
    }
}

