/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"customer", "type", "valid-until", "unlimited", "features", "raw"})
public class TelemetryLicenseKeyDto {
    public static final String JSON_PROPERTY_CUSTOMER = "customer";
    private JsonNullable<String> customer = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TYPE = "type";
    private JsonNullable<String> type = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VALID_UNTIL = "valid-until";
    private JsonNullable<LocalDate> validUntil = JsonNullable.undefined();
    public static final String JSON_PROPERTY_UNLIMITED = "unlimited";
    private JsonNullable<Boolean> unlimited = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FEATURES = "features";
    private Map<String, String> features = new HashMap<String, String>();
    public static final String JSON_PROPERTY_RAW = "raw";
    private JsonNullable<String> raw = JsonNullable.undefined();

    public TelemetryLicenseKeyDto customer(String customer) {
        this.customer = JsonNullable.of((Object)customer);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getCustomer() {
        return (String)this.customer.orElse(null);
    }

    @JsonProperty(value="customer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomer_JsonNullable() {
        return this.customer;
    }

    @JsonProperty(value="customer")
    public void setCustomer_JsonNullable(JsonNullable<String> customer) {
        this.customer = customer;
    }

    public void setCustomer(String customer) {
        this.customer = JsonNullable.of((Object)customer);
    }

    public TelemetryLicenseKeyDto type(String type) {
        this.type = JsonNullable.of((Object)type);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getType() {
        return (String)this.type.orElse(null);
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getType_JsonNullable() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType_JsonNullable(JsonNullable<String> type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = JsonNullable.of((Object)type);
    }

    public TelemetryLicenseKeyDto validUntil(LocalDate validUntil) {
        this.validUntil = JsonNullable.of((Object)validUntil);
        return this;
    }

    @Nullable
    @JsonIgnore
    public LocalDate getValidUntil() {
        return (LocalDate)this.validUntil.orElse(null);
    }

    @JsonProperty(value="valid-until")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDate> getValidUntil_JsonNullable() {
        return this.validUntil;
    }

    @JsonProperty(value="valid-until")
    public void setValidUntil_JsonNullable(JsonNullable<LocalDate> validUntil) {
        this.validUntil = validUntil;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = JsonNullable.of((Object)validUntil);
    }

    public TelemetryLicenseKeyDto unlimited(Boolean unlimited) {
        this.unlimited = JsonNullable.of((Object)unlimited);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getUnlimited() {
        return (Boolean)this.unlimited.orElse(null);
    }

    @JsonProperty(value="unlimited")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getUnlimited_JsonNullable() {
        return this.unlimited;
    }

    @JsonProperty(value="unlimited")
    public void setUnlimited_JsonNullable(JsonNullable<Boolean> unlimited) {
        this.unlimited = unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = JsonNullable.of((Object)unlimited);
    }

    public TelemetryLicenseKeyDto features(Map<String, String> features) {
        this.features = features;
        return this;
    }

    public TelemetryLicenseKeyDto putFeaturesItem(String key, String featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, String>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeatures(Map<String, String> features) {
        this.features = features;
    }

    public TelemetryLicenseKeyDto raw(String raw) {
        this.raw = JsonNullable.of((Object)raw);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getRaw() {
        return (String)this.raw.orElse(null);
    }

    @JsonProperty(value="raw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getRaw_JsonNullable() {
        return this.raw;
    }

    @JsonProperty(value="raw")
    public void setRaw_JsonNullable(JsonNullable<String> raw) {
        this.raw = raw;
    }

    public void setRaw(String raw) {
        this.raw = JsonNullable.of((Object)raw);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryLicenseKeyDto telemetryLicenseKeyDto = (TelemetryLicenseKeyDto)o;
        return TelemetryLicenseKeyDto.equalsNullable(this.customer, telemetryLicenseKeyDto.customer) && TelemetryLicenseKeyDto.equalsNullable(this.type, telemetryLicenseKeyDto.type) && TelemetryLicenseKeyDto.equalsNullable(this.validUntil, telemetryLicenseKeyDto.validUntil) && TelemetryLicenseKeyDto.equalsNullable(this.unlimited, telemetryLicenseKeyDto.unlimited) && Objects.equals(this.features, telemetryLicenseKeyDto.features) && TelemetryLicenseKeyDto.equalsNullable(this.raw, telemetryLicenseKeyDto.raw);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(TelemetryLicenseKeyDto.hashCodeNullable(this.customer), TelemetryLicenseKeyDto.hashCodeNullable(this.type), TelemetryLicenseKeyDto.hashCodeNullable(this.validUntil), TelemetryLicenseKeyDto.hashCodeNullable(this.unlimited), this.features, TelemetryLicenseKeyDto.hashCodeNullable(this.raw));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryLicenseKeyDto {\n");
        sb.append("    customer: ").append(this.toIndentedString(this.customer)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    validUntil: ").append(this.toIndentedString(this.validUntil)).append("\n");
        sb.append("    unlimited: ").append(this.toIndentedString(this.unlimited)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    raw: ").append(this.toIndentedString(this.raw)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCustomer() != null) {
            try {
                joiner.add(String.format("%scustomer%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCustomer()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getValidUntil() != null) {
            try {
                joiner.add(String.format("%svalid-until%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getValidUntil()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUnlimited() != null) {
            try {
                joiner.add(String.format("%sunlimited%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUnlimited()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFeatures() != null) {
            for (String _key : this.getFeatures().keySet()) {
                try {
                    joiner.add(String.format("%sfeatures%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getFeatures().get(_key), URLEncoder.encode(String.valueOf(this.getFeatures().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getRaw() != null) {
            try {
                joiner.add(String.format("%sraw%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRaw()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

