/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDiagramDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDto;
import org.camunda.community.rest.client.dto.EvaluateDecisionDto;
import org.camunda.community.rest.client.dto.HistoryTimeToLiveDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.BaseApi;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class DecisionDefinitionApi
extends BaseApi {
    public DecisionDefinitionApi() {
        super(Configuration.getDefaultApiClient());
    }

    public DecisionDefinitionApi(ApiClient apiClient) {
        super(apiClient);
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionById(String id, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        return this.evaluateDecisionById(id, evaluateDecisionDto, Collections.emptyMap());
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionById(String id, EvaluateDecisionDto evaluateDecisionDto, Map<String, String> additionalHeaders) throws ApiException {
        EvaluateDecisionDto localVarPostBody = evaluateDecisionDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling evaluateDecisionById");
        }
        String localVarPath = "/decision-definition/{id}/evaluate".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<Map<String, VariableValueDto>>> localVarReturnType = new TypeReference<List<Map<String, VariableValueDto>>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionByKey(String key, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        return this.evaluateDecisionByKey(key, evaluateDecisionDto, Collections.emptyMap());
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionByKey(String key, EvaluateDecisionDto evaluateDecisionDto, Map<String, String> additionalHeaders) throws ApiException {
        EvaluateDecisionDto localVarPostBody = evaluateDecisionDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling evaluateDecisionByKey");
        }
        String localVarPath = "/decision-definition/key/{key}/evaluate".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<Map<String, VariableValueDto>>> localVarReturnType = new TypeReference<List<Map<String, VariableValueDto>>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionByKeyAndTenant(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        return this.evaluateDecisionByKeyAndTenant(key, tenantId, evaluateDecisionDto, Collections.emptyMap());
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionByKeyAndTenant(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, Map<String, String> additionalHeaders) throws ApiException {
        EvaluateDecisionDto localVarPostBody = evaluateDecisionDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling evaluateDecisionByKeyAndTenant");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling evaluateDecisionByKeyAndTenant");
        }
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/evaluate".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<Map<String, VariableValueDto>>> localVarReturnType = new TypeReference<List<Map<String, VariableValueDto>>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DecisionDefinitionDto getDecisionDefinitionById(String id) throws ApiException {
        return this.getDecisionDefinitionById(id, Collections.emptyMap());
    }

    public DecisionDefinitionDto getDecisionDefinitionById(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionDefinitionById");
        }
        String localVarPath = "/decision-definition/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DecisionDefinitionDto> localVarReturnType = new TypeReference<DecisionDefinitionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DecisionDefinitionDto getDecisionDefinitionByKey(String key) throws ApiException {
        return this.getDecisionDefinitionByKey(key, Collections.emptyMap());
    }

    public DecisionDefinitionDto getDecisionDefinitionByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionByKey");
        }
        String localVarPath = "/decision-definition/key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DecisionDefinitionDto> localVarReturnType = new TypeReference<DecisionDefinitionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DecisionDefinitionDto getDecisionDefinitionByKeyAndTenantId(String key, String tenantId) throws ApiException {
        return this.getDecisionDefinitionByKeyAndTenantId(key, tenantId, Collections.emptyMap());
    }

    public DecisionDefinitionDto getDecisionDefinitionByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionDefinitionByKeyAndTenantId");
        }
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DecisionDefinitionDto> localVarReturnType = new TypeReference<DecisionDefinitionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getDecisionDefinitionDiagram(String id) throws ApiException {
        return this.getDecisionDefinitionDiagram(id, Collections.emptyMap());
    }

    public File getDecisionDefinitionDiagram(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionDefinitionDiagram");
        }
        String localVarPath = "/decision-definition/{id}/diagram".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getDecisionDefinitionDiagramByKey(String key) throws ApiException {
        return this.getDecisionDefinitionDiagramByKey(key, Collections.emptyMap());
    }

    public File getDecisionDefinitionDiagramByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKey");
        }
        String localVarPath = "/decision-definition/key/{key}/diagram".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getDecisionDefinitionDiagramByKeyAndTenant(String key, String tenantId) throws ApiException {
        return this.getDecisionDefinitionDiagramByKeyAndTenant(key, tenantId, Collections.emptyMap());
    }

    public File getDecisionDefinitionDiagramByKeyAndTenant(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKeyAndTenant");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionDefinitionDiagramByKeyAndTenant");
        }
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/diagram".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlById(String id) throws ApiException {
        return this.getDecisionDefinitionDmnXmlById(id, Collections.emptyMap());
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlById(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionDefinitionDmnXmlById");
        }
        String localVarPath = "/decision-definition/{id}/xml".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DecisionDefinitionDiagramDto> localVarReturnType = new TypeReference<DecisionDefinitionDiagramDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKey(String key) throws ApiException {
        return this.getDecisionDefinitionDmnXmlByKey(key, Collections.emptyMap());
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKey");
        }
        String localVarPath = "/decision-definition/key/{key}/xml".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DecisionDefinitionDiagramDto> localVarReturnType = new TypeReference<DecisionDefinitionDiagramDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKeyAndTenant(String key, String tenantId) throws ApiException {
        return this.getDecisionDefinitionDmnXmlByKeyAndTenant(key, tenantId, Collections.emptyMap());
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKeyAndTenant(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKeyAndTenant");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionDefinitionDmnXmlByKeyAndTenant");
        }
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/xml".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DecisionDefinitionDiagramDto> localVarReturnType = new TypeReference<DecisionDefinitionDiagramDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DecisionDefinitionDto> getDecisionDefinitions(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        return this.getDecisionDefinitions(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, Collections.emptyMap());
    }

    public List<DecisionDefinitionDto> getDecisionDefinitions(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deploymentId", deploymentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAfter", deployedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAt", deployedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("keyLike", keyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("categoryLike", categoryLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("latestVersion", latestVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceName", resourceName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceNameLike", resourceNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTag", versionTag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTagLike", versionTagLike));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<DecisionDefinitionDto>> localVarReturnType = new TypeReference<List<DecisionDefinitionDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getDecisionDefinitionsCount(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        return this.getDecisionDefinitionsCount(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, Collections.emptyMap());
    }

    public CountResultDto getDecisionDefinitionsCount(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deploymentId", deploymentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAfter", deployedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAt", deployedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("keyLike", keyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("categoryLike", categoryLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("latestVersion", latestVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceName", resourceName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceNameLike", resourceNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTag", versionTag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTagLike", versionTagLike));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByDecisionDefinitionId(id, historyTimeToLiveDto, Collections.emptyMap());
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateHistoryTimeToLiveByDecisionDefinitionId");
        }
        String localVarPath = "/decision-definition/{id}/history-time-to-live".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByDecisionDefinitionKey(key, historyTimeToLiveDto, Collections.emptyMap());
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKey");
        }
        String localVarPath = "/decision-definition/key/{key}/history-time-to-live".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(key, tenantId, historyTimeToLiveDto, Collections.emptyMap());
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant");
        }
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

