/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeploymentDto;
import org.camunda.community.rest.client.dto.DeploymentResourceDto;
import org.camunda.community.rest.client.dto.DeploymentWithDefinitionsDto;
import org.camunda.community.rest.client.dto.RedeploymentDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.BaseApi;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class DeploymentApi
extends BaseApi {
    public DeploymentApi() {
        super(Configuration.getDefaultApiClient());
    }

    public DeploymentApi(ApiClient apiClient) {
        super(apiClient);
    }

    public DeploymentWithDefinitionsDto createDeployment(String tenantId, String deploymentSource, Boolean deployChangedOnly, Boolean enableDuplicateFiltering, String deploymentName, OffsetDateTime deploymentActivationTime, File data) throws ApiException {
        return this.createDeployment(tenantId, deploymentSource, deployChangedOnly, enableDuplicateFiltering, deploymentName, deploymentActivationTime, data, Collections.emptyMap());
    }

    public DeploymentWithDefinitionsDto createDeployment(String tenantId, String deploymentSource, Boolean deployChangedOnly, Boolean enableDuplicateFiltering, String deploymentName, OffsetDateTime deploymentActivationTime, File data, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/create";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (tenantId != null) {
            localVarFormParams.put("tenant-id", tenantId);
        }
        if (deploymentSource != null) {
            localVarFormParams.put("deployment-source", deploymentSource);
        }
        if (deployChangedOnly != null) {
            localVarFormParams.put("deploy-changed-only", deployChangedOnly);
        }
        if (enableDuplicateFiltering != null) {
            localVarFormParams.put("enable-duplicate-filtering", enableDuplicateFiltering);
        }
        if (deploymentName != null) {
            localVarFormParams.put("deployment-name", deploymentName);
        }
        if (deploymentActivationTime != null) {
            localVarFormParams.put("deployment-activation-time", deploymentActivationTime);
        }
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DeploymentWithDefinitionsDto> localVarReturnType = new TypeReference<DeploymentWithDefinitionsDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteDeployment(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteDeployment(id, cascade, skipCustomListeners, skipIoMappings, Collections.emptyMap());
    }

    public void deleteDeployment(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteDeployment");
        }
        String localVarPath = "/deployment/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("cascade", cascade));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipIoMappings", skipIoMappings));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public DeploymentDto getDeployment(String id) throws ApiException {
        return this.getDeployment(id, Collections.emptyMap());
    }

    public DeploymentDto getDeployment(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeployment");
        }
        String localVarPath = "/deployment/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DeploymentDto> localVarReturnType = new TypeReference<DeploymentDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeploymentResourceDto getDeploymentResource(String id, String resourceId) throws ApiException {
        return this.getDeploymentResource(id, resourceId, Collections.emptyMap());
    }

    public DeploymentResourceDto getDeploymentResource(String id, String resourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeploymentResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling getDeploymentResource");
        }
        String localVarPath = "/deployment/{id}/resources/{resourceId}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{resourceId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(resourceId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DeploymentResourceDto> localVarReturnType = new TypeReference<DeploymentResourceDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getDeploymentResourceData(String id, String resourceId) throws ApiException {
        return this.getDeploymentResourceData(id, resourceId, Collections.emptyMap());
    }

    public File getDeploymentResourceData(String id, String resourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeploymentResourceData");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling getDeploymentResourceData");
        }
        String localVarPath = "/deployment/{id}/resources/{resourceId}/data".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{resourceId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(resourceId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DeploymentResourceDto> getDeploymentResources(String id) throws ApiException {
        return this.getDeploymentResources(id, Collections.emptyMap());
    }

    public List<DeploymentResourceDto> getDeploymentResources(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeploymentResources");
        }
        String localVarPath = "/deployment/{id}/resources".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<DeploymentResourceDto>> localVarReturnType = new TypeReference<List<DeploymentResourceDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DeploymentDto> getDeployments(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, OffsetDateTime after, OffsetDateTime before, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getDeployments(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<DeploymentDto> getDeployments(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, OffsetDateTime after, OffsetDateTime before, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("source", source));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutSource", withoutSource));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeDeploymentsWithoutTenantId", includeDeploymentsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<DeploymentDto>> localVarReturnType = new TypeReference<List<DeploymentDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getDeploymentsCount(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, OffsetDateTime after, OffsetDateTime before) throws ApiException {
        return this.getDeploymentsCount(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, Collections.emptyMap());
    }

    public CountResultDto getDeploymentsCount(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, OffsetDateTime after, OffsetDateTime before, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("source", source));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutSource", withoutSource));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeDeploymentsWithoutTenantId", includeDeploymentsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<String> getRegisteredDeployments() throws ApiException {
        return this.getRegisteredDeployments(Collections.emptyMap());
    }

    public List<String> getRegisteredDeployments(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/registered";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<String>> localVarReturnType = new TypeReference<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeploymentWithDefinitionsDto redeploy(String id, RedeploymentDto redeploymentDto) throws ApiException {
        return this.redeploy(id, redeploymentDto, Collections.emptyMap());
    }

    public DeploymentWithDefinitionsDto redeploy(String id, RedeploymentDto redeploymentDto, Map<String, String> additionalHeaders) throws ApiException {
        RedeploymentDto localVarPostBody = redeploymentDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling redeploy");
        }
        String localVarPath = "/deployment/{id}/redeploy".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<DeploymentWithDefinitionsDto> localVarReturnType = new TypeReference<DeploymentWithDefinitionsDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

