/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.CreateIncidentDto;
import org.camunda.community.rest.client.dto.EventSubscriptionDto;
import org.camunda.community.rest.client.dto.ExecutionDto;
import org.camunda.community.rest.client.dto.ExecutionQueryDto;
import org.camunda.community.rest.client.dto.ExecutionTriggerDto;
import org.camunda.community.rest.client.dto.IncidentDto;
import org.camunda.community.rest.client.dto.PatchVariablesDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.BaseApi;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class ExecutionApi
extends BaseApi {
    public ExecutionApi() {
        super(Configuration.getDefaultApiClient());
    }

    public ExecutionApi(ApiClient apiClient) {
        super(apiClient);
    }

    public IncidentDto createIncident(String id, CreateIncidentDto createIncidentDto) throws ApiException {
        return this.createIncident(id, createIncidentDto, Collections.emptyMap());
    }

    public IncidentDto createIncident(String id, CreateIncidentDto createIncidentDto, Map<String, String> additionalHeaders) throws ApiException {
        CreateIncidentDto localVarPostBody = createIncidentDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling createIncident");
        }
        String localVarPath = "/execution/{id}/create-incident".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<IncidentDto> localVarReturnType = new TypeReference<IncidentDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteLocalExecutionVariable(String id, String varName) throws ApiException {
        this.deleteLocalExecutionVariable(id, varName, Collections.emptyMap());
    }

    public void deleteLocalExecutionVariable(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteLocalExecutionVariable");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling deleteLocalExecutionVariable");
        }
        String localVarPath = "/execution/{id}/localVariables/{varName}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{varName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(varName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ExecutionDto getExecution(String id) throws ApiException {
        return this.getExecution(id, Collections.emptyMap());
    }

    public ExecutionDto getExecution(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getExecution");
        }
        String localVarPath = "/execution/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ExecutionDto> localVarReturnType = new TypeReference<ExecutionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ExecutionDto> getExecutions(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getExecutions(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<ExecutionDto> getExecutions(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/execution";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("businessKey", businessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("signalEventSubscriptionName", signalEventSubscriptionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("messageEventSubscriptionName", messageEventSubscriptionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentId", incidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variables", variables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processVariables", processVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ExecutionDto>> localVarReturnType = new TypeReference<List<ExecutionDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getExecutionsCount(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        return this.getExecutionsCount(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
    }

    public CountResultDto getExecutionsCount(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/execution/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("businessKey", businessKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("signalEventSubscriptionName", signalEventSubscriptionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("messageEventSubscriptionName", messageEventSubscriptionName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentId", incidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variables", variables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processVariables", processVariables));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VariableValueDto getLocalExecutionVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
        return this.getLocalExecutionVariable(id, varName, deserializeValue, Collections.emptyMap());
    }

    public VariableValueDto getLocalExecutionVariable(String id, String varName, Boolean deserializeValue, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getLocalExecutionVariable");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling getLocalExecutionVariable");
        }
        String localVarPath = "/execution/{id}/localVariables/{varName}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{varName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(varName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValue", deserializeValue));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<VariableValueDto> localVarReturnType = new TypeReference<VariableValueDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getLocalExecutionVariableBinary(String id, String varName) throws ApiException {
        return this.getLocalExecutionVariableBinary(id, varName, Collections.emptyMap());
    }

    public File getLocalExecutionVariableBinary(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getLocalExecutionVariableBinary");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling getLocalExecutionVariableBinary");
        }
        String localVarPath = "/execution/{id}/localVariables/{varName}/data".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{varName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(varName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "text/plain", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, VariableValueDto> getLocalExecutionVariables(String id, Boolean deserializeValues) throws ApiException {
        return this.getLocalExecutionVariables(id, deserializeValues, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> getLocalExecutionVariables(String id, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getLocalExecutionVariables");
        }
        String localVarPath = "/execution/{id}/localVariables".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValues", deserializeValues));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EventSubscriptionDto getMessageEventSubscription(String id, String messageName) throws ApiException {
        return this.getMessageEventSubscription(id, messageName, Collections.emptyMap());
    }

    public EventSubscriptionDto getMessageEventSubscription(String id, String messageName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getMessageEventSubscription");
        }
        if (messageName == null) {
            throw new ApiException(400, "Missing the required parameter 'messageName' when calling getMessageEventSubscription");
        }
        String localVarPath = "/execution/{id}/messageSubscriptions/{messageName}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{messageName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(messageName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<EventSubscriptionDto> localVarReturnType = new TypeReference<EventSubscriptionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void modifyLocalExecutionVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        this.modifyLocalExecutionVariables(id, patchVariablesDto, Collections.emptyMap());
    }

    public void modifyLocalExecutionVariables(String id, PatchVariablesDto patchVariablesDto, Map<String, String> additionalHeaders) throws ApiException {
        PatchVariablesDto localVarPostBody = patchVariablesDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling modifyLocalExecutionVariables");
        }
        String localVarPath = "/execution/{id}/localVariables".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void putLocalExecutionVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        this.putLocalExecutionVariable(id, varName, variableValueDto, Collections.emptyMap());
    }

    public void putLocalExecutionVariable(String id, String varName, VariableValueDto variableValueDto, Map<String, String> additionalHeaders) throws ApiException {
        VariableValueDto localVarPostBody = variableValueDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling putLocalExecutionVariable");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling putLocalExecutionVariable");
        }
        String localVarPath = "/execution/{id}/localVariables/{varName}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{varName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(varName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<ExecutionDto> queryExecutions(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto) throws ApiException {
        return this.queryExecutions(firstResult, maxResults, executionQueryDto, Collections.emptyMap());
    }

    public List<ExecutionDto> queryExecutions(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        ExecutionQueryDto localVarPostBody = executionQueryDto;
        String localVarPath = "/execution";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ExecutionDto>> localVarReturnType = new TypeReference<List<ExecutionDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto queryExecutionsCount(ExecutionQueryDto executionQueryDto) throws ApiException {
        return this.queryExecutionsCount(executionQueryDto, Collections.emptyMap());
    }

    public CountResultDto queryExecutionsCount(ExecutionQueryDto executionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        ExecutionQueryDto localVarPostBody = executionQueryDto;
        String localVarPath = "/execution/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void setLocalExecutionVariableBinary(String id, String varName, File data, String valueType) throws ApiException {
        this.setLocalExecutionVariableBinary(id, varName, data, valueType, Collections.emptyMap());
    }

    public void setLocalExecutionVariableBinary(String id, String varName, File data, String valueType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setLocalExecutionVariableBinary");
        }
        if (varName == null) {
            throw new ApiException(400, "Missing the required parameter 'varName' when calling setLocalExecutionVariableBinary");
        }
        String localVarPath = "/execution/{id}/localVariables/{varName}/data".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{varName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(varName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (valueType != null) {
            localVarFormParams.put("valueType", valueType);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void signalExecution(String id, ExecutionTriggerDto executionTriggerDto) throws ApiException {
        this.signalExecution(id, executionTriggerDto, Collections.emptyMap());
    }

    public void signalExecution(String id, ExecutionTriggerDto executionTriggerDto, Map<String, String> additionalHeaders) throws ApiException {
        ExecutionTriggerDto localVarPostBody = executionTriggerDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling signalExecution");
        }
        String localVarPath = "/execution/{id}/signal".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void triggerEvent(String id, String messageName, ExecutionTriggerDto executionTriggerDto) throws ApiException {
        this.triggerEvent(id, messageName, executionTriggerDto, Collections.emptyMap());
    }

    public void triggerEvent(String id, String messageName, ExecutionTriggerDto executionTriggerDto, Map<String, String> additionalHeaders) throws ApiException {
        ExecutionTriggerDto localVarPostBody = executionTriggerDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling triggerEvent");
        }
        if (messageName == null) {
            throw new ApiException(400, "Missing the required parameter 'messageName' when calling triggerEvent");
        }
        String localVarPath = "/execution/{id}/messageSubscriptions/{messageName}/trigger".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{messageName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(messageName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

