/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CompleteExternalTaskDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExtendLockOnExternalTaskDto;
import org.camunda.community.rest.client.dto.ExternalTaskBpmnError;
import org.camunda.community.rest.client.dto.ExternalTaskDto;
import org.camunda.community.rest.client.dto.ExternalTaskFailureDto;
import org.camunda.community.rest.client.dto.ExternalTaskQueryDto;
import org.camunda.community.rest.client.dto.FetchExternalTasksDto;
import org.camunda.community.rest.client.dto.LockExternalTaskDto;
import org.camunda.community.rest.client.dto.LockedExternalTaskDto;
import org.camunda.community.rest.client.dto.PriorityDto;
import org.camunda.community.rest.client.dto.RetriesDto;
import org.camunda.community.rest.client.dto.SetRetriesForExternalTasksDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.BaseApi;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class ExternalTaskApi
extends BaseApi {
    public ExternalTaskApi() {
        super(Configuration.getDefaultApiClient());
    }

    public ExternalTaskApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void completeExternalTaskResource(String id, CompleteExternalTaskDto completeExternalTaskDto) throws ApiException {
        this.completeExternalTaskResource(id, completeExternalTaskDto, Collections.emptyMap());
    }

    public void completeExternalTaskResource(String id, CompleteExternalTaskDto completeExternalTaskDto, Map<String, String> additionalHeaders) throws ApiException {
        CompleteExternalTaskDto localVarPostBody = completeExternalTaskDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling completeExternalTaskResource");
        }
        String localVarPath = "/external-task/{id}/complete".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void extendLock(String id, ExtendLockOnExternalTaskDto extendLockOnExternalTaskDto) throws ApiException {
        this.extendLock(id, extendLockOnExternalTaskDto, Collections.emptyMap());
    }

    public void extendLock(String id, ExtendLockOnExternalTaskDto extendLockOnExternalTaskDto, Map<String, String> additionalHeaders) throws ApiException {
        ExtendLockOnExternalTaskDto localVarPostBody = extendLockOnExternalTaskDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling extendLock");
        }
        String localVarPath = "/external-task/{id}/extendLock".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<LockedExternalTaskDto> fetchAndLock(FetchExternalTasksDto fetchExternalTasksDto) throws ApiException {
        return this.fetchAndLock(fetchExternalTasksDto, Collections.emptyMap());
    }

    public List<LockedExternalTaskDto> fetchAndLock(FetchExternalTasksDto fetchExternalTasksDto, Map<String, String> additionalHeaders) throws ApiException {
        FetchExternalTasksDto localVarPostBody = fetchExternalTasksDto;
        String localVarPath = "/external-task/fetchAndLock";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<LockedExternalTaskDto>> localVarReturnType = new TypeReference<List<LockedExternalTaskDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ExternalTaskDto getExternalTask(String id) throws ApiException {
        return this.getExternalTask(id, Collections.emptyMap());
    }

    public ExternalTaskDto getExternalTask(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getExternalTask");
        }
        String localVarPath = "/external-task/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ExternalTaskDto> localVarReturnType = new TypeReference<ExternalTaskDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getExternalTaskErrorDetails(String id) throws ApiException {
        return this.getExternalTaskErrorDetails(id, Collections.emptyMap());
    }

    public String getExternalTaskErrorDetails(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getExternalTaskErrorDetails");
        }
        String localVarPath = "/external-task/{id}/errorDetails".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/plain", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ExternalTaskDto> getExternalTasks(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, OffsetDateTime lockExpirationAfter, OffsetDateTime lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getExternalTasks(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<ExternalTaskDto> getExternalTasks(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, OffsetDateTime lockExpirationAfter, OffsetDateTime lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/external-task";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("externalTaskId", externalTaskId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("externalTaskIdIn", externalTaskIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("topicName", topicName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("workerId", workerId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("locked", locked));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("notLocked", notLocked));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("lockExpirationAfter", lockExpirationAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("lockExpirationBefore", lockExpirationBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityIdIn", activityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ExternalTaskDto>> localVarReturnType = new TypeReference<List<ExternalTaskDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getExternalTasksCount(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, OffsetDateTime lockExpirationAfter, OffsetDateTime lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals) throws ApiException {
        return this.getExternalTasksCount(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, Collections.emptyMap());
    }

    public CountResultDto getExternalTasksCount(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, OffsetDateTime lockExpirationAfter, OffsetDateTime lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/external-task/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("externalTaskId", externalTaskId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("externalTaskIdIn", externalTaskIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("topicName", topicName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("workerId", workerId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("locked", locked));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("notLocked", notLocked));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("lockExpirationAfter", lockExpirationAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("lockExpirationBefore", lockExpirationBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityIdIn", activityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<String> getTopicNames(Boolean withLockedTasks, Boolean withUnlockedTasks, Boolean withRetriesLeft) throws ApiException {
        return this.getTopicNames(withLockedTasks, withUnlockedTasks, withRetriesLeft, Collections.emptyMap());
    }

    public List<String> getTopicNames(Boolean withLockedTasks, Boolean withUnlockedTasks, Boolean withRetriesLeft, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/external-task/topic-names";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withLockedTasks", withLockedTasks));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withUnlockedTasks", withUnlockedTasks));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<String>> localVarReturnType = new TypeReference<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void handleExternalTaskBpmnError(String id, ExternalTaskBpmnError externalTaskBpmnError) throws ApiException {
        this.handleExternalTaskBpmnError(id, externalTaskBpmnError, Collections.emptyMap());
    }

    public void handleExternalTaskBpmnError(String id, ExternalTaskBpmnError externalTaskBpmnError, Map<String, String> additionalHeaders) throws ApiException {
        ExternalTaskBpmnError localVarPostBody = externalTaskBpmnError;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling handleExternalTaskBpmnError");
        }
        String localVarPath = "/external-task/{id}/bpmnError".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void handleFailure(String id, ExternalTaskFailureDto externalTaskFailureDto) throws ApiException {
        this.handleFailure(id, externalTaskFailureDto, Collections.emptyMap());
    }

    public void handleFailure(String id, ExternalTaskFailureDto externalTaskFailureDto, Map<String, String> additionalHeaders) throws ApiException {
        ExternalTaskFailureDto localVarPostBody = externalTaskFailureDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling handleFailure");
        }
        String localVarPath = "/external-task/{id}/failure".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void lock(String id, LockExternalTaskDto lockExternalTaskDto) throws ApiException {
        this.lock(id, lockExternalTaskDto, Collections.emptyMap());
    }

    public void lock(String id, LockExternalTaskDto lockExternalTaskDto, Map<String, String> additionalHeaders) throws ApiException {
        LockExternalTaskDto localVarPostBody = lockExternalTaskDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling lock");
        }
        String localVarPath = "/external-task/{id}/lock".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<ExternalTaskDto> queryExternalTasks(Integer firstResult, Integer maxResults, ExternalTaskQueryDto externalTaskQueryDto) throws ApiException {
        return this.queryExternalTasks(firstResult, maxResults, externalTaskQueryDto, Collections.emptyMap());
    }

    public List<ExternalTaskDto> queryExternalTasks(Integer firstResult, Integer maxResults, ExternalTaskQueryDto externalTaskQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        ExternalTaskQueryDto localVarPostBody = externalTaskQueryDto;
        String localVarPath = "/external-task";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ExternalTaskDto>> localVarReturnType = new TypeReference<List<ExternalTaskDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto queryExternalTasksCount(ExternalTaskQueryDto externalTaskQueryDto) throws ApiException {
        return this.queryExternalTasksCount(externalTaskQueryDto, Collections.emptyMap());
    }

    public CountResultDto queryExternalTasksCount(ExternalTaskQueryDto externalTaskQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        ExternalTaskQueryDto localVarPostBody = externalTaskQueryDto;
        String localVarPath = "/external-task/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void setExternalTaskResourcePriority(String id, PriorityDto priorityDto) throws ApiException {
        this.setExternalTaskResourcePriority(id, priorityDto, Collections.emptyMap());
    }

    public void setExternalTaskResourcePriority(String id, PriorityDto priorityDto, Map<String, String> additionalHeaders) throws ApiException {
        PriorityDto localVarPostBody = priorityDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setExternalTaskResourcePriority");
        }
        String localVarPath = "/external-task/{id}/priority".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setExternalTaskResourceRetries(String id, RetriesDto retriesDto) throws ApiException {
        this.setExternalTaskResourceRetries(id, retriesDto, Collections.emptyMap());
    }

    public void setExternalTaskResourceRetries(String id, RetriesDto retriesDto, Map<String, String> additionalHeaders) throws ApiException {
        RetriesDto localVarPostBody = retriesDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setExternalTaskResourceRetries");
        }
        String localVarPath = "/external-task/{id}/retries".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setExternalTaskRetries(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto) throws ApiException {
        this.setExternalTaskRetries(setRetriesForExternalTasksDto, Collections.emptyMap());
    }

    public void setExternalTaskRetries(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, Map<String, String> additionalHeaders) throws ApiException {
        SetRetriesForExternalTasksDto localVarPostBody = setRetriesForExternalTasksDto;
        String localVarPath = "/external-task/retries";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BatchDto setExternalTaskRetriesAsyncOperation(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto) throws ApiException {
        return this.setExternalTaskRetriesAsyncOperation(setRetriesForExternalTasksDto, Collections.emptyMap());
    }

    public BatchDto setExternalTaskRetriesAsyncOperation(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, Map<String, String> additionalHeaders) throws ApiException {
        SetRetriesForExternalTasksDto localVarPostBody = setRetriesForExternalTasksDto;
        String localVarPath = "/external-task/retries-async";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unlock(String id) throws ApiException {
        this.unlock(id, Collections.emptyMap());
    }

    public void unlock(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling unlock");
        }
        String localVarPath = "/external-task/{id}/unlock".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

