/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.CreateFilterDto;
import org.camunda.community.rest.client.dto.FilterDto;
import org.camunda.community.rest.client.dto.ResourceOptionsDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.BaseApi;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class FilterApi
extends BaseApi {
    public FilterApi() {
        super(Configuration.getDefaultApiClient());
    }

    public FilterApi(ApiClient apiClient) {
        super(apiClient);
    }

    public FilterDto createFilter(CreateFilterDto createFilterDto) throws ApiException {
        return this.createFilter(createFilterDto, Collections.emptyMap());
    }

    public FilterDto createFilter(CreateFilterDto createFilterDto, Map<String, String> additionalHeaders) throws ApiException {
        CreateFilterDto localVarPostBody = createFilterDto;
        String localVarPath = "/filter/create";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<FilterDto> localVarReturnType = new TypeReference<FilterDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteFilter(String id) throws ApiException {
        this.deleteFilter(id, Collections.emptyMap());
    }

    public void deleteFilter(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteFilter");
        }
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CountResultDto executeFilterCount(String id) throws ApiException {
        return this.executeFilterCount(id, Collections.emptyMap());
    }

    public CountResultDto executeFilterCount(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling executeFilterCount");
        }
        String localVarPath = "/filter/{id}/count".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Object> executeFilterList(String id, Integer firstResult, Integer maxResults) throws ApiException {
        return this.executeFilterList(id, firstResult, maxResults, Collections.emptyMap());
    }

    public List<Object> executeFilterList(String id, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling executeFilterList");
        }
        String localVarPath = "/filter/{id}/list".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<Object>> localVarReturnType = new TypeReference<List<Object>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object executeFilterSingleResult(String id) throws ApiException {
        return this.executeFilterSingleResult(id, Collections.emptyMap());
    }

    public Object executeFilterSingleResult(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling executeFilterSingleResult");
        }
        String localVarPath = "/filter/{id}/singleResult".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Object> localVarReturnType = new TypeReference<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceOptionsDto filterResourceOptions() throws ApiException {
        return this.filterResourceOptions(Collections.emptyMap());
    }

    public ResourceOptionsDto filterResourceOptions(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ResourceOptionsDto> localVarReturnType = new TypeReference<ResourceOptionsDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceOptionsDto filterResourceOptionsSingle(String id) throws ApiException {
        return this.filterResourceOptionsSingle(id, Collections.emptyMap());
    }

    public ResourceOptionsDto filterResourceOptionsSingle(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filterResourceOptionsSingle");
        }
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ResourceOptionsDto> localVarReturnType = new TypeReference<ResourceOptionsDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getFilterCount(String filterId, String resourceType, String name, String nameLike, String owner) throws ApiException {
        return this.getFilterCount(filterId, resourceType, name, nameLike, owner, Collections.emptyMap());
    }

    public CountResultDto getFilterCount(String filterId, String resourceType, String name, String nameLike, String owner, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filterId", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceType", resourceType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("owner", owner));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<FilterDto> getFilterList(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getFilterList(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<FilterDto> getFilterList(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filterId", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceType", resourceType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("owner", owner));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("itemCount", itemCount));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<FilterDto>> localVarReturnType = new TypeReference<List<FilterDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FilterDto getSingleFilter(String id, Boolean itemCount) throws ApiException {
        return this.getSingleFilter(id, itemCount, Collections.emptyMap());
    }

    public FilterDto getSingleFilter(String id, Boolean itemCount, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getSingleFilter");
        }
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("itemCount", itemCount));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<FilterDto> localVarReturnType = new TypeReference<FilterDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto postExecuteFilterCount(String id, Object body) throws ApiException {
        return this.postExecuteFilterCount(id, body, Collections.emptyMap());
    }

    public CountResultDto postExecuteFilterCount(String id, Object body, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling postExecuteFilterCount");
        }
        String localVarPath = "/filter/{id}/count".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Object> postExecuteFilterList(String id, Integer firstResult, Integer maxResults, Object body) throws ApiException {
        return this.postExecuteFilterList(id, firstResult, maxResults, body, Collections.emptyMap());
    }

    public List<Object> postExecuteFilterList(String id, Integer firstResult, Integer maxResults, Object body, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling postExecuteFilterList");
        }
        String localVarPath = "/filter/{id}/list".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<Object>> localVarReturnType = new TypeReference<List<Object>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object postExecuteFilterSingleResult(String id, Object body) throws ApiException {
        return this.postExecuteFilterSingleResult(id, body, Collections.emptyMap());
    }

    public Object postExecuteFilterSingleResult(String id, Object body, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling postExecuteFilterSingleResult");
        }
        String localVarPath = "/filter/{id}/singleResult".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Object> localVarReturnType = new TypeReference<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateFilter(String id, CreateFilterDto createFilterDto) throws ApiException {
        this.updateFilter(id, createFilterDto, Collections.emptyMap());
    }

    public void updateFilter(String id, CreateFilterDto createFilterDto, Map<String, String> additionalHeaders) throws ApiException {
        CreateFilterDto localVarPostBody = createFilterDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateFilter");
        }
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

