/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.JobDefinitionDto;
import org.camunda.community.rest.client.dto.JobDefinitionPriorityDto;
import org.camunda.community.rest.client.dto.JobDefinitionQueryDto;
import org.camunda.community.rest.client.dto.JobDefinitionSuspensionStateDto;
import org.camunda.community.rest.client.dto.JobDefinitionsSuspensionStateDto;
import org.camunda.community.rest.client.dto.RetriesDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.BaseApi;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class JobDefinitionApi
extends BaseApi {
    public JobDefinitionApi() {
        super(Configuration.getDefaultApiClient());
    }

    public JobDefinitionApi(ApiClient apiClient) {
        super(apiClient);
    }

    public JobDefinitionDto getJobDefinition(String id) throws ApiException {
        return this.getJobDefinition(id, Collections.emptyMap());
    }

    public JobDefinitionDto getJobDefinition(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getJobDefinition");
        }
        String localVarPath = "/job-definition/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<JobDefinitionDto> localVarReturnType = new TypeReference<JobDefinitionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JobDefinitionDto> getJobDefinitions(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getJobDefinitions(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<JobDefinitionDto> getJobDefinitions(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job-definition";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityIdIn", activityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobType", jobType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobConfiguration", jobConfiguration));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<JobDefinitionDto>> localVarReturnType = new TypeReference<List<JobDefinitionDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getJobDefinitionsCount(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId) throws ApiException {
        return this.getJobDefinitionsCount(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, Collections.emptyMap());
    }

    public CountResultDto getJobDefinitionsCount(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job-definition/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityIdIn", activityIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobType", jobType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("jobConfiguration", jobConfiguration));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JobDefinitionDto> queryJobDefinitions(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        return this.queryJobDefinitions(firstResult, maxResults, jobDefinitionQueryDto, Collections.emptyMap());
    }

    public List<JobDefinitionDto> queryJobDefinitions(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        JobDefinitionQueryDto localVarPostBody = jobDefinitionQueryDto;
        String localVarPath = "/job-definition";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<JobDefinitionDto>> localVarReturnType = new TypeReference<List<JobDefinitionDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto queryJobDefinitionsCount(JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        return this.queryJobDefinitionsCount(jobDefinitionQueryDto, Collections.emptyMap());
    }

    public CountResultDto queryJobDefinitionsCount(JobDefinitionQueryDto jobDefinitionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        JobDefinitionQueryDto localVarPostBody = jobDefinitionQueryDto;
        String localVarPath = "/job-definition/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void setJobPriorityJobDefinition(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto) throws ApiException {
        this.setJobPriorityJobDefinition(id, jobDefinitionPriorityDto, Collections.emptyMap());
    }

    public void setJobPriorityJobDefinition(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, Map<String, String> additionalHeaders) throws ApiException {
        JobDefinitionPriorityDto localVarPostBody = jobDefinitionPriorityDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setJobPriorityJobDefinition");
        }
        String localVarPath = "/job-definition/{id}/jobPriority".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setJobRetriesJobDefinition(String id, RetriesDto retriesDto) throws ApiException {
        this.setJobRetriesJobDefinition(id, retriesDto, Collections.emptyMap());
    }

    public void setJobRetriesJobDefinition(String id, RetriesDto retriesDto, Map<String, String> additionalHeaders) throws ApiException {
        RetriesDto localVarPostBody = retriesDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setJobRetriesJobDefinition");
        }
        String localVarPath = "/job-definition/{id}/retries".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateSuspensionStateJobDefinition(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto) throws ApiException {
        this.updateSuspensionStateJobDefinition(id, jobDefinitionSuspensionStateDto, Collections.emptyMap());
    }

    public void updateSuspensionStateJobDefinition(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        JobDefinitionSuspensionStateDto localVarPostBody = jobDefinitionSuspensionStateDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateSuspensionStateJobDefinition");
        }
        String localVarPath = "/job-definition/{id}/suspended".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateSuspensionStateJobDefinitions(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto) throws ApiException {
        this.updateSuspensionStateJobDefinitions(jobDefinitionsSuspensionStateDto, Collections.emptyMap());
    }

    public void updateSuspensionStateJobDefinitions(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        JobDefinitionsSuspensionStateDto localVarPostBody = jobDefinitionsSuspensionStateDto;
        String localVarPath = "/job-definition/suspended";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

