/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.ActivityStatisticsResultDto;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CalledProcessDefinitionDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.FormDto;
import org.camunda.community.rest.client.dto.HistoryTimeToLiveDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDiagramDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionStatisticsResultDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionSuspensionStateDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.ProcessInstanceWithVariablesDto;
import org.camunda.community.rest.client.dto.RestartProcessInstanceDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceFormDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.BaseApi;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class ProcessDefinitionApi
extends BaseApi {
    public ProcessDefinitionApi() {
        super(Configuration.getDefaultApiClient());
    }

    public ProcessDefinitionApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void deleteProcessDefinition(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteProcessDefinition(id, cascade, skipCustomListeners, skipIoMappings, Collections.emptyMap());
    }

    public void deleteProcessDefinition(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteProcessDefinition");
        }
        String localVarPath = "/process-definition/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("cascade", cascade));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipIoMappings", skipIoMappings));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteProcessDefinitionsByKey(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteProcessDefinitionsByKey(key, cascade, skipCustomListeners, skipIoMappings, Collections.emptyMap());
    }

    public void deleteProcessDefinitionsByKey(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteProcessDefinitionsByKey");
        }
        String localVarPath = "/process-definition/key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("cascade", cascade));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipIoMappings", skipIoMappings));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteProcessDefinitionsByKeyAndTenantId(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteProcessDefinitionsByKeyAndTenantId(key, tenantId, cascade, skipCustomListeners, skipIoMappings, Collections.emptyMap());
    }

    public void deleteProcessDefinitionsByKeyAndTenantId(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteProcessDefinitionsByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling deleteProcessDefinitionsByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("cascade", cascade));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("skipIoMappings", skipIoMappings));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<ActivityStatisticsResultDto> getActivityStatistics(String id, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        return this.getActivityStatistics(id, failedJobs, incidents, incidentsForType, Collections.emptyMap());
    }

    public List<ActivityStatisticsResultDto> getActivityStatistics(String id, Boolean failedJobs, Boolean incidents, String incidentsForType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getActivityStatistics");
        }
        String localVarPath = "/process-definition/{id}/statistics".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedJobs", failedJobs));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidents", incidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentsForType", incidentsForType));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ActivityStatisticsResultDto>> localVarReturnType = new TypeReference<List<ActivityStatisticsResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKey(String key, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        return this.getActivityStatisticsByProcessDefinitionKey(key, failedJobs, incidents, incidentsForType, Collections.emptyMap());
    }

    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKey(String key, Boolean failedJobs, Boolean incidents, String incidentsForType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getActivityStatisticsByProcessDefinitionKey");
        }
        String localVarPath = "/process-definition/key/{key}/statistics".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedJobs", failedJobs));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidents", incidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentsForType", incidentsForType));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ActivityStatisticsResultDto>> localVarReturnType = new TypeReference<List<ActivityStatisticsResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKeyAndTenantId(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        return this.getActivityStatisticsByProcessDefinitionKeyAndTenantId(key, tenantId, failedJobs, incidents, incidentsForType, Collections.emptyMap());
    }

    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKeyAndTenantId(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getActivityStatisticsByProcessDefinitionKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getActivityStatisticsByProcessDefinitionKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/statistics".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedJobs", failedJobs));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidents", incidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentsForType", incidentsForType));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ActivityStatisticsResultDto>> localVarReturnType = new TypeReference<List<ActivityStatisticsResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getDeployedStartForm(String id) throws ApiException {
        return this.getDeployedStartForm(id, Collections.emptyMap());
    }

    public File getDeployedStartForm(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeployedStartForm");
        }
        String localVarPath = "/process-definition/{id}/deployed-start-form".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getDeployedStartFormByKey(String key) throws ApiException {
        return this.getDeployedStartFormByKey(key, Collections.emptyMap());
    }

    public File getDeployedStartFormByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDeployedStartFormByKey");
        }
        String localVarPath = "/process-definition/key/{key}/deployed-start-form".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getDeployedStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        return this.getDeployedStartFormByKeyAndTenantId(key, tenantId, Collections.emptyMap());
    }

    public File getDeployedStartFormByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getDeployedStartFormByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDeployedStartFormByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/deployed-start-form".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessDefinitionDto getLatestProcessDefinitionByTenantId(String key, String tenantId) throws ApiException {
        return this.getLatestProcessDefinitionByTenantId(key, tenantId, Collections.emptyMap());
    }

    public ProcessDefinitionDto getLatestProcessDefinitionByTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getLatestProcessDefinitionByTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getLatestProcessDefinitionByTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessDefinitionDto> localVarReturnType = new TypeReference<ProcessDefinitionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessDefinitionDto getProcessDefinition(String id) throws ApiException {
        return this.getProcessDefinition(id, Collections.emptyMap());
    }

    public ProcessDefinitionDto getProcessDefinition(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessDefinition");
        }
        String localVarPath = "/process-definition/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessDefinitionDto> localVarReturnType = new TypeReference<ProcessDefinitionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml(String id) throws ApiException {
        return this.getProcessDefinitionBpmn20Xml(id, Collections.emptyMap());
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessDefinitionBpmn20Xml");
        }
        String localVarPath = "/process-definition/{id}/xml".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessDefinitionDiagramDto> localVarReturnType = new TypeReference<ProcessDefinitionDiagramDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKey(String key) throws ApiException {
        return this.getProcessDefinitionBpmn20XmlByKey(key, Collections.emptyMap());
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getProcessDefinitionBpmn20XmlByKey");
        }
        String localVarPath = "/process-definition/key/{key}/xml".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessDefinitionDiagramDto> localVarReturnType = new TypeReference<ProcessDefinitionDiagramDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKeyAndTenantId(String key, String tenantId) throws ApiException {
        return this.getProcessDefinitionBpmn20XmlByKeyAndTenantId(key, tenantId, Collections.emptyMap());
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getProcessDefinitionBpmn20XmlByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getProcessDefinitionBpmn20XmlByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/xml".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessDefinitionDiagramDto> localVarReturnType = new TypeReference<ProcessDefinitionDiagramDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessDefinitionDto getProcessDefinitionByKey(String key) throws ApiException {
        return this.getProcessDefinitionByKey(key, Collections.emptyMap());
    }

    public ProcessDefinitionDto getProcessDefinitionByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getProcessDefinitionByKey");
        }
        String localVarPath = "/process-definition/key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessDefinitionDto> localVarReturnType = new TypeReference<ProcessDefinitionDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getProcessDefinitionDiagram(String id) throws ApiException {
        return this.getProcessDefinitionDiagram(id, Collections.emptyMap());
    }

    public File getProcessDefinitionDiagram(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessDefinitionDiagram");
        }
        String localVarPath = "/process-definition/{id}/diagram".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getProcessDefinitionDiagramByKey(String key) throws ApiException {
        return this.getProcessDefinitionDiagramByKey(key, Collections.emptyMap());
    }

    public File getProcessDefinitionDiagramByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getProcessDefinitionDiagramByKey");
        }
        String localVarPath = "/process-definition/key/{key}/diagram".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getProcessDefinitionDiagramByKeyAndTenantId(String key, String tenantId) throws ApiException {
        return this.getProcessDefinitionDiagramByKeyAndTenantId(key, tenantId, Collections.emptyMap());
    }

    public File getProcessDefinitionDiagramByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getProcessDefinitionDiagramByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getProcessDefinitionDiagramByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/diagram".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ProcessDefinitionStatisticsResultDto> getProcessDefinitionStatistics(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents) throws ApiException {
        return this.getProcessDefinitionStatistics(failedJobs, incidents, incidentsForType, rootIncidents, Collections.emptyMap());
    }

    public List<ProcessDefinitionStatisticsResultDto> getProcessDefinitionStatistics(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/statistics";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("failedJobs", failedJobs));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidents", incidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentsForType", incidentsForType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rootIncidents", rootIncidents));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ProcessDefinitionStatisticsResultDto>> localVarReturnType = new TypeReference<List<ProcessDefinitionStatisticsResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ProcessDefinitionDto> getProcessDefinitions(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getProcessDefinitions(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<ProcessDefinitionDto> getProcessDefinitions(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deploymentId", deploymentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAfter", deployedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAt", deployedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("keysIn", keysIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("keyLike", keyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("categoryLike", categoryLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("latestVersion", latestVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceName", resourceName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceNameLike", resourceNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startableBy", startableBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentId", incidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeProcessDefinitionsWithoutTenantId", includeProcessDefinitionsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTag", versionTag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTagLike", versionTagLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutVersionTag", withoutVersionTag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startableInTasklist", startableInTasklist));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("notStartableInTasklist", notStartableInTasklist));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startablePermissionCheck", startablePermissionCheck));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<ProcessDefinitionDto>> localVarReturnType = new TypeReference<List<ProcessDefinitionDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getProcessDefinitionsCount(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck) throws ApiException {
        return this.getProcessDefinitionsCount(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, Collections.emptyMap());
    }

    public CountResultDto getProcessDefinitionsCount(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("nameLike", nameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deploymentId", deploymentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAfter", deployedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deployedAt", deployedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("keysIn", keysIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("keyLike", keyLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("categoryLike", categoryLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("latestVersion", latestVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceName", resourceName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceNameLike", resourceNameLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startableBy", startableBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentId", incidentId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentType", incidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessage", incidentMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeProcessDefinitionsWithoutTenantId", includeProcessDefinitionsWithoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTag", versionTag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("versionTagLike", versionTagLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutVersionTag", withoutVersionTag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startableInTasklist", startableInTasklist));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("notStartableInTasklist", notStartableInTasklist));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startablePermissionCheck", startablePermissionCheck));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getRenderedStartForm(String id) throws ApiException {
        return this.getRenderedStartForm(id, Collections.emptyMap());
    }

    public File getRenderedStartForm(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRenderedStartForm");
        }
        String localVarPath = "/process-definition/{id}/rendered-form".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getRenderedStartFormByKey(String key) throws ApiException {
        return this.getRenderedStartFormByKey(key, Collections.emptyMap());
    }

    public File getRenderedStartFormByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getRenderedStartFormByKey");
        }
        String localVarPath = "/process-definition/key/{key}/rendered-form".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File getRenderedStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        return this.getRenderedStartFormByKeyAndTenantId(key, tenantId, Collections.emptyMap());
    }

    public File getRenderedStartFormByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getRenderedStartFormByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getRenderedStartFormByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/rendered-form".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<File> localVarReturnType = new TypeReference<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FormDto getStartForm(String id) throws ApiException {
        return this.getStartForm(id, Collections.emptyMap());
    }

    public FormDto getStartForm(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getStartForm");
        }
        String localVarPath = "/process-definition/{id}/startForm".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<FormDto> localVarReturnType = new TypeReference<FormDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FormDto getStartFormByKey(String key) throws ApiException {
        return this.getStartFormByKey(key, Collections.emptyMap());
    }

    public FormDto getStartFormByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getStartFormByKey");
        }
        String localVarPath = "/process-definition/key/{key}/startForm".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<FormDto> localVarReturnType = new TypeReference<FormDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FormDto getStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        return this.getStartFormByKeyAndTenantId(key, tenantId, Collections.emptyMap());
    }

    public FormDto getStartFormByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getStartFormByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getStartFormByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/startForm".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<FormDto> localVarReturnType = new TypeReference<FormDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, VariableValueDto> getStartFormVariables(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        return this.getStartFormVariables(id, variableNames, deserializeValues, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> getStartFormVariables(String id, String variableNames, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getStartFormVariables");
        }
        String localVarPath = "/process-definition/{id}/form-variables".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNames", variableNames));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValues", deserializeValues));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, VariableValueDto> getStartFormVariablesByKey(String key, String variableNames, Boolean deserializeValues) throws ApiException {
        return this.getStartFormVariablesByKey(key, variableNames, deserializeValues, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> getStartFormVariablesByKey(String key, String variableNames, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getStartFormVariablesByKey");
        }
        String localVarPath = "/process-definition/key/{key}/form-variables".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNames", variableNames));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValues", deserializeValues));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, VariableValueDto> getStartFormVariablesByKeyAndTenantId(String key, String tenantId, String variableNames, Boolean deserializeValues) throws ApiException {
        return this.getStartFormVariablesByKeyAndTenantId(key, tenantId, variableNames, deserializeValues, Collections.emptyMap());
    }

    public Map<String, VariableValueDto> getStartFormVariablesByKeyAndTenantId(String key, String tenantId, String variableNames, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getStartFormVariablesByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getStartFormVariablesByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/form-variables".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("variableNames", variableNames));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deserializeValues", deserializeValues));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<CalledProcessDefinitionDto> getStaticCalledProcessDefinitions(String id) throws ApiException {
        return this.getStaticCalledProcessDefinitions(id, Collections.emptyMap());
    }

    public List<CalledProcessDefinitionDto> getStaticCalledProcessDefinitions(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getStaticCalledProcessDefinitions");
        }
        String localVarPath = "/process-definition/{id}/static-called-process-definitions".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<CalledProcessDefinitionDto>> localVarReturnType = new TypeReference<List<CalledProcessDefinitionDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void restartProcessInstance(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        this.restartProcessInstance(id, restartProcessInstanceDto, Collections.emptyMap());
    }

    public void restartProcessInstance(String id, RestartProcessInstanceDto restartProcessInstanceDto, Map<String, String> additionalHeaders) throws ApiException {
        RestartProcessInstanceDto localVarPostBody = restartProcessInstanceDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling restartProcessInstance");
        }
        String localVarPath = "/process-definition/{id}/restart".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BatchDto restartProcessInstanceAsyncOperation(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        return this.restartProcessInstanceAsyncOperation(id, restartProcessInstanceDto, Collections.emptyMap());
    }

    public BatchDto restartProcessInstanceAsyncOperation(String id, RestartProcessInstanceDto restartProcessInstanceDto, Map<String, String> additionalHeaders) throws ApiException {
        RestartProcessInstanceDto localVarPostBody = restartProcessInstanceDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling restartProcessInstanceAsyncOperation");
        }
        String localVarPath = "/process-definition/{id}/restart-async".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessInstanceWithVariablesDto startProcessInstance(String id, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        return this.startProcessInstance(id, startProcessInstanceDto, Collections.emptyMap());
    }

    public ProcessInstanceWithVariablesDto startProcessInstance(String id, StartProcessInstanceDto startProcessInstanceDto, Map<String, String> additionalHeaders) throws ApiException {
        StartProcessInstanceDto localVarPostBody = startProcessInstanceDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling startProcessInstance");
        }
        String localVarPath = "/process-definition/{id}/start".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessInstanceWithVariablesDto> localVarReturnType = new TypeReference<ProcessInstanceWithVariablesDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessInstanceWithVariablesDto startProcessInstanceByKey(String key, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        return this.startProcessInstanceByKey(key, startProcessInstanceDto, Collections.emptyMap());
    }

    public ProcessInstanceWithVariablesDto startProcessInstanceByKey(String key, StartProcessInstanceDto startProcessInstanceDto, Map<String, String> additionalHeaders) throws ApiException {
        StartProcessInstanceDto localVarPostBody = startProcessInstanceDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling startProcessInstanceByKey");
        }
        String localVarPath = "/process-definition/key/{key}/start".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessInstanceWithVariablesDto> localVarReturnType = new TypeReference<ProcessInstanceWithVariablesDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessInstanceWithVariablesDto startProcessInstanceByKeyAndTenantId(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        return this.startProcessInstanceByKeyAndTenantId(key, tenantId, startProcessInstanceDto, Collections.emptyMap());
    }

    public ProcessInstanceWithVariablesDto startProcessInstanceByKeyAndTenantId(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto, Map<String, String> additionalHeaders) throws ApiException {
        StartProcessInstanceDto localVarPostBody = startProcessInstanceDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling startProcessInstanceByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling startProcessInstanceByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/start".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessInstanceWithVariablesDto> localVarReturnType = new TypeReference<ProcessInstanceWithVariablesDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessInstanceDto submitForm(String id, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        return this.submitForm(id, startProcessInstanceFormDto, Collections.emptyMap());
    }

    public ProcessInstanceDto submitForm(String id, StartProcessInstanceFormDto startProcessInstanceFormDto, Map<String, String> additionalHeaders) throws ApiException {
        StartProcessInstanceFormDto localVarPostBody = startProcessInstanceFormDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling submitForm");
        }
        String localVarPath = "/process-definition/{id}/submit-form".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessInstanceDto> localVarReturnType = new TypeReference<ProcessInstanceDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessInstanceDto submitFormByKey(String key, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        return this.submitFormByKey(key, startProcessInstanceFormDto, Collections.emptyMap());
    }

    public ProcessInstanceDto submitFormByKey(String key, StartProcessInstanceFormDto startProcessInstanceFormDto, Map<String, String> additionalHeaders) throws ApiException {
        StartProcessInstanceFormDto localVarPostBody = startProcessInstanceFormDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling submitFormByKey");
        }
        String localVarPath = "/process-definition/key/{key}/submit-form".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessInstanceDto> localVarReturnType = new TypeReference<ProcessInstanceDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessInstanceDto submitFormByKeyAndTenantId(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        return this.submitFormByKeyAndTenantId(key, tenantId, startProcessInstanceFormDto, Collections.emptyMap());
    }

    public ProcessInstanceDto submitFormByKeyAndTenantId(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto, Map<String, String> additionalHeaders) throws ApiException {
        StartProcessInstanceFormDto localVarPostBody = startProcessInstanceFormDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling submitFormByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling submitFormByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/submit-form".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<ProcessInstanceDto> localVarReturnType = new TypeReference<ProcessInstanceDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateHistoryTimeToLiveByProcessDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByProcessDefinitionId(id, historyTimeToLiveDto, Collections.emptyMap());
    }

    public void updateHistoryTimeToLiveByProcessDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateHistoryTimeToLiveByProcessDefinitionId");
        }
        String localVarPath = "/process-definition/{id}/history-time-to-live".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateHistoryTimeToLiveByProcessDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByProcessDefinitionKey(key, historyTimeToLiveDto, Collections.emptyMap());
    }

    public void updateHistoryTimeToLiveByProcessDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateHistoryTimeToLiveByProcessDefinitionKey");
        }
        String localVarPath = "/process-definition/key/{key}/history-time-to-live".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(key, tenantId, historyTimeToLiveDto, Collections.emptyMap());
    }

    public void updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateProcessDefinitionSuspensionState(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionState(processDefinitionSuspensionStateDto, Collections.emptyMap());
    }

    public void updateProcessDefinitionSuspensionState(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        String localVarPath = "/process-definition/suspended";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateProcessDefinitionSuspensionStateById(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionStateById(id, processDefinitionSuspensionStateDto, Collections.emptyMap());
    }

    public void updateProcessDefinitionSuspensionStateById(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateProcessDefinitionSuspensionStateById");
        }
        String localVarPath = "/process-definition/{id}/suspended".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateProcessDefinitionSuspensionStateByKey(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionStateByKey(key, processDefinitionSuspensionStateDto, Collections.emptyMap());
    }

    public void updateProcessDefinitionSuspensionStateByKey(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateProcessDefinitionSuspensionStateByKey");
        }
        String localVarPath = "/process-definition/key/{key}/suspended".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateProcessDefinitionSuspensionStateByKeyAndTenantId(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionStateByKeyAndTenantId(key, tenantId, processDefinitionSuspensionStateDto, Collections.emptyMap());
    }

    public void updateProcessDefinitionSuspensionStateByKeyAndTenantId(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateProcessDefinitionSuspensionStateByKeyAndTenantId");
        }
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling updateProcessDefinitionSuspensionStateByKeyAndTenantId");
        }
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/suspended".replaceAll("\\{key\\}", this.apiClient.escapeString(this.apiClient.parameterToString(key))).replaceAll("\\{tenant-id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tenantId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

