/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.FetchExternalTaskTopicDto;
import org.camunda.community.rest.client.dto.FetchExternalTasksDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"workerId", "maxTasks", "usePriority", "asyncResponseTimeout", "topics", "sorting"})
public class FetchExternalTasksDto {
    public static final String JSON_PROPERTY_WORKER_ID = "workerId";
    @Nonnull
    private String workerId;
    public static final String JSON_PROPERTY_MAX_TASKS = "maxTasks";
    @Nullable
    private Integer maxTasks;
    public static final String JSON_PROPERTY_USE_PRIORITY = "usePriority";
    @Nullable
    private JsonNullable<Boolean> usePriority = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ASYNC_RESPONSE_TIMEOUT = "asyncResponseTimeout";
    @Nullable
    private JsonNullable<Long> asyncResponseTimeout = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TOPICS = "topics";
    @Nullable
    private JsonNullable<List<FetchExternalTaskTopicDto>> topics = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SORTING = "sorting";
    @Nullable
    private JsonNullable<List<FetchExternalTasksDtoSortingInner>> sorting = JsonNullable.undefined();

    public FetchExternalTasksDto workerId(@Nonnull String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="workerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWorkerId() {
        return this.workerId;
    }

    @JsonProperty(value="workerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkerId(@Nonnull String workerId) {
        this.workerId = workerId;
    }

    public FetchExternalTasksDto maxTasks(@Nullable Integer maxTasks) {
        this.maxTasks = maxTasks;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxTasks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getMaxTasks() {
        return this.maxTasks;
    }

    @JsonProperty(value="maxTasks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxTasks(@Nullable Integer maxTasks) {
        this.maxTasks = maxTasks;
    }

    public FetchExternalTasksDto usePriority(@Nullable Boolean usePriority) {
        this.usePriority = JsonNullable.of((Object)usePriority);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getUsePriority() {
        return (Boolean)this.usePriority.orElse(null);
    }

    @JsonProperty(value="usePriority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getUsePriority_JsonNullable() {
        return this.usePriority;
    }

    @JsonProperty(value="usePriority")
    public void setUsePriority_JsonNullable(JsonNullable<Boolean> usePriority) {
        this.usePriority = usePriority;
    }

    public void setUsePriority(@Nullable Boolean usePriority) {
        this.usePriority = JsonNullable.of((Object)usePriority);
    }

    public FetchExternalTasksDto asyncResponseTimeout(@Nullable Long asyncResponseTimeout) {
        this.asyncResponseTimeout = JsonNullable.of((Object)asyncResponseTimeout);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getAsyncResponseTimeout() {
        return (Long)this.asyncResponseTimeout.orElse(null);
    }

    @JsonProperty(value="asyncResponseTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getAsyncResponseTimeout_JsonNullable() {
        return this.asyncResponseTimeout;
    }

    @JsonProperty(value="asyncResponseTimeout")
    public void setAsyncResponseTimeout_JsonNullable(JsonNullable<Long> asyncResponseTimeout) {
        this.asyncResponseTimeout = asyncResponseTimeout;
    }

    public void setAsyncResponseTimeout(@Nullable Long asyncResponseTimeout) {
        this.asyncResponseTimeout = JsonNullable.of((Object)asyncResponseTimeout);
    }

    public FetchExternalTasksDto topics(@Nullable List<FetchExternalTaskTopicDto> topics) {
        this.topics = JsonNullable.of(topics);
        return this;
    }

    public FetchExternalTasksDto addTopicsItem(FetchExternalTaskTopicDto topicsItem) {
        if (this.topics == null || !this.topics.isPresent()) {
            this.topics = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.topics.get()).add(topicsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<FetchExternalTaskTopicDto> getTopics() {
        return (List)this.topics.orElse(null);
    }

    @JsonProperty(value="topics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<FetchExternalTaskTopicDto>> getTopics_JsonNullable() {
        return this.topics;
    }

    @JsonProperty(value="topics")
    public void setTopics_JsonNullable(JsonNullable<List<FetchExternalTaskTopicDto>> topics) {
        this.topics = topics;
    }

    public void setTopics(@Nullable List<FetchExternalTaskTopicDto> topics) {
        this.topics = JsonNullable.of(topics);
    }

    public FetchExternalTasksDto sorting(@Nullable List<FetchExternalTasksDtoSortingInner> sorting) {
        this.sorting = JsonNullable.of(sorting);
        return this;
    }

    public FetchExternalTasksDto addSortingItem(FetchExternalTasksDtoSortingInner sortingItem) {
        if (this.sorting == null || !this.sorting.isPresent()) {
            this.sorting = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.sorting.get()).add(sortingItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<FetchExternalTasksDtoSortingInner> getSorting() {
        return (List)this.sorting.orElse(null);
    }

    @JsonProperty(value="sorting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<FetchExternalTasksDtoSortingInner>> getSorting_JsonNullable() {
        return this.sorting;
    }

    @JsonProperty(value="sorting")
    public void setSorting_JsonNullable(JsonNullable<List<FetchExternalTasksDtoSortingInner>> sorting) {
        this.sorting = sorting;
    }

    public void setSorting(@Nullable List<FetchExternalTasksDtoSortingInner> sorting) {
        this.sorting = JsonNullable.of(sorting);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchExternalTasksDto fetchExternalTasksDto = (FetchExternalTasksDto)o;
        return Objects.equals(this.workerId, fetchExternalTasksDto.workerId) && Objects.equals(this.maxTasks, fetchExternalTasksDto.maxTasks) && FetchExternalTasksDto.equalsNullable(this.usePriority, fetchExternalTasksDto.usePriority) && FetchExternalTasksDto.equalsNullable(this.asyncResponseTimeout, fetchExternalTasksDto.asyncResponseTimeout) && FetchExternalTasksDto.equalsNullable(this.topics, fetchExternalTasksDto.topics) && FetchExternalTasksDto.equalsNullable(this.sorting, fetchExternalTasksDto.sorting);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.workerId, this.maxTasks, FetchExternalTasksDto.hashCodeNullable(this.usePriority), FetchExternalTasksDto.hashCodeNullable(this.asyncResponseTimeout), FetchExternalTasksDto.hashCodeNullable(this.topics), FetchExternalTasksDto.hashCodeNullable(this.sorting));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FetchExternalTasksDto {\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("    maxTasks: ").append(this.toIndentedString(this.maxTasks)).append("\n");
        sb.append("    usePriority: ").append(this.toIndentedString(this.usePriority)).append("\n");
        sb.append("    asyncResponseTimeout: ").append(this.toIndentedString(this.asyncResponseTimeout)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getWorkerId() != null) {
            try {
                joiner.add(String.format("%sworkerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getWorkerId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMaxTasks() != null) {
            try {
                joiner.add(String.format("%smaxTasks%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMaxTasks()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUsePriority() != null) {
            try {
                joiner.add(String.format("%susePriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUsePriority()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAsyncResponseTimeout() != null) {
            try {
                joiner.add(String.format("%sasyncResponseTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAsyncResponseTimeout()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTopics() != null) {
            for (i = 0; i < this.getTopics().size(); ++i) {
                if (this.getTopics().get(i) == null) continue;
                joiner.add(this.getTopics().get(i).toUrlQueryString(String.format("%stopics%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getSorting() != null) {
            for (i = 0; i < this.getSorting().size(); ++i) {
                if (this.getSorting().get(i) == null) continue;
                joiner.add(this.getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

