/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.MigrationInstructionDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"instruction", "failures"})
public class MigrationInstructionValidationReportDto {
    public static final String JSON_PROPERTY_INSTRUCTION = "instruction";
    @Nullable
    private MigrationInstructionDto instruction;
    public static final String JSON_PROPERTY_FAILURES = "failures";
    @Nullable
    private JsonNullable<List<String>> failures = JsonNullable.undefined();

    public MigrationInstructionValidationReportDto instruction(@Nullable MigrationInstructionDto instruction) {
        this.instruction = instruction;
        return this;
    }

    @Nullable
    @JsonProperty(value="instruction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MigrationInstructionDto getInstruction() {
        return this.instruction;
    }

    @JsonProperty(value="instruction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstruction(@Nullable MigrationInstructionDto instruction) {
        this.instruction = instruction;
    }

    public MigrationInstructionValidationReportDto failures(@Nullable List<String> failures) {
        this.failures = JsonNullable.of(failures);
        return this;
    }

    public MigrationInstructionValidationReportDto addFailuresItem(String failuresItem) {
        if (this.failures == null || !this.failures.isPresent()) {
            this.failures = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.failures.get()).add(failuresItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getFailures() {
        return (List)this.failures.orElse(null);
    }

    @JsonProperty(value="failures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getFailures_JsonNullable() {
        return this.failures;
    }

    @JsonProperty(value="failures")
    public void setFailures_JsonNullable(JsonNullable<List<String>> failures) {
        this.failures = failures;
    }

    public void setFailures(@Nullable List<String> failures) {
        this.failures = JsonNullable.of(failures);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInstructionValidationReportDto migrationInstructionValidationReportDto = (MigrationInstructionValidationReportDto)o;
        return Objects.equals(this.instruction, migrationInstructionValidationReportDto.instruction) && MigrationInstructionValidationReportDto.equalsNullable(this.failures, migrationInstructionValidationReportDto.failures);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.instruction, MigrationInstructionValidationReportDto.hashCodeNullable(this.failures));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrationInstructionValidationReportDto {\n");
        sb.append("    instruction: ").append(this.toIndentedString(this.instruction)).append("\n");
        sb.append("    failures: ").append(this.toIndentedString(this.failures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInstruction() != null) {
            joiner.add(this.getInstruction().toUrlQueryString(prefix + JSON_PROPERTY_INSTRUCTION + suffix));
        }
        if (this.getFailures() != null) {
            for (int i = 0; i < this.getFailures().size(); ++i) {
                try {
                    joiner.add(String.format("%sfailures%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getFailures().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

