/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.IncidentStatisticsResultDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "instances", "failedJobs", "incidents", "@class", "definition"})
public class ProcessDefinitionStatisticsResultDto {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private JsonNullable<String> id = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INSTANCES = "instances";
    @Nullable
    private Integer instances;
    public static final String JSON_PROPERTY_FAILED_JOBS = "failedJobs";
    @Nullable
    private Integer failedJobs;
    public static final String JSON_PROPERTY_INCIDENTS = "incidents";
    @Nullable
    private JsonNullable<List<IncidentStatisticsResultDto>> incidents = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AT_CLASS = "@class";
    @Nullable
    private JsonNullable<String> atClass = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFINITION = "definition";
    @Nullable
    private ProcessDefinitionDto definition;

    public ProcessDefinitionStatisticsResultDto id(@Nullable String id) {
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getId() {
        return (String)this.id.orElse(null);
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getId_JsonNullable() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId_JsonNullable(JsonNullable<String> id) {
        this.id = id;
    }

    public void setId(@Nullable String id) {
        this.id = JsonNullable.of((Object)id);
    }

    public ProcessDefinitionStatisticsResultDto instances(@Nullable Integer instances) {
        this.instances = instances;
        return this;
    }

    @Nullable
    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getInstances() {
        return this.instances;
    }

    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstances(@Nullable Integer instances) {
        this.instances = instances;
    }

    public ProcessDefinitionStatisticsResultDto failedJobs(@Nullable Integer failedJobs) {
        this.failedJobs = failedJobs;
        return this;
    }

    @Nullable
    @JsonProperty(value="failedJobs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailedJobs() {
        return this.failedJobs;
    }

    @JsonProperty(value="failedJobs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedJobs(@Nullable Integer failedJobs) {
        this.failedJobs = failedJobs;
    }

    public ProcessDefinitionStatisticsResultDto incidents(@Nullable List<IncidentStatisticsResultDto> incidents) {
        this.incidents = JsonNullable.of(incidents);
        return this;
    }

    public ProcessDefinitionStatisticsResultDto addIncidentsItem(IncidentStatisticsResultDto incidentsItem) {
        if (this.incidents == null || !this.incidents.isPresent()) {
            this.incidents = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.incidents.get()).add(incidentsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<IncidentStatisticsResultDto> getIncidents() {
        return (List)this.incidents.orElse(null);
    }

    @JsonProperty(value="incidents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<IncidentStatisticsResultDto>> getIncidents_JsonNullable() {
        return this.incidents;
    }

    @JsonProperty(value="incidents")
    public void setIncidents_JsonNullable(JsonNullable<List<IncidentStatisticsResultDto>> incidents) {
        this.incidents = incidents;
    }

    public void setIncidents(@Nullable List<IncidentStatisticsResultDto> incidents) {
        this.incidents = JsonNullable.of(incidents);
    }

    public ProcessDefinitionStatisticsResultDto atClass(@Nullable String atClass) {
        this.atClass = JsonNullable.of((Object)atClass);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getAtClass() {
        return (String)this.atClass.orElse(null);
    }

    @JsonProperty(value="@class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAtClass_JsonNullable() {
        return this.atClass;
    }

    @JsonProperty(value="@class")
    public void setAtClass_JsonNullable(JsonNullable<String> atClass) {
        this.atClass = atClass;
    }

    public void setAtClass(@Nullable String atClass) {
        this.atClass = JsonNullable.of((Object)atClass);
    }

    public ProcessDefinitionStatisticsResultDto definition(@Nullable ProcessDefinitionDto definition) {
        this.definition = definition;
        return this;
    }

    @Nullable
    @JsonProperty(value="definition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessDefinitionDto getDefinition() {
        return this.definition;
    }

    @JsonProperty(value="definition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefinition(@Nullable ProcessDefinitionDto definition) {
        this.definition = definition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDefinitionStatisticsResultDto processDefinitionStatisticsResultDto = (ProcessDefinitionStatisticsResultDto)o;
        return ProcessDefinitionStatisticsResultDto.equalsNullable(this.id, processDefinitionStatisticsResultDto.id) && Objects.equals(this.instances, processDefinitionStatisticsResultDto.instances) && Objects.equals(this.failedJobs, processDefinitionStatisticsResultDto.failedJobs) && ProcessDefinitionStatisticsResultDto.equalsNullable(this.incidents, processDefinitionStatisticsResultDto.incidents) && ProcessDefinitionStatisticsResultDto.equalsNullable(this.atClass, processDefinitionStatisticsResultDto.atClass) && Objects.equals(this.definition, processDefinitionStatisticsResultDto.definition);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(ProcessDefinitionStatisticsResultDto.hashCodeNullable(this.id), this.instances, this.failedJobs, ProcessDefinitionStatisticsResultDto.hashCodeNullable(this.incidents), ProcessDefinitionStatisticsResultDto.hashCodeNullable(this.atClass), this.definition);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessDefinitionStatisticsResultDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    instances: ").append(this.toIndentedString(this.instances)).append("\n");
        sb.append("    failedJobs: ").append(this.toIndentedString(this.failedJobs)).append("\n");
        sb.append("    incidents: ").append(this.toIndentedString(this.incidents)).append("\n");
        sb.append("    atClass: ").append(this.toIndentedString(this.atClass)).append("\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInstances() != null) {
            try {
                joiner.add(String.format("%sinstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getInstances()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFailedJobs() != null) {
            try {
                joiner.add(String.format("%sfailedJobs%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFailedJobs()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIncidents() != null) {
            for (int i = 0; i < this.getIncidents().size(); ++i) {
                if (this.getIncidents().get(i) == null) continue;
                joiner.add(this.getIncidents().get(i).toUrlQueryString(String.format("%sincidents%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getAtClass() != null) {
            try {
                joiner.add(String.format("%s@class%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAtClass()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDefinition() != null) {
            joiner.add(this.getDefinition().toUrlQueryString(prefix + JSON_PROPERTY_DEFINITION + suffix));
        }
        return joiner.toString();
    }
}

