/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ProblemDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"errors", "warnings"})
public class ResourceReportDto {
    public static final String JSON_PROPERTY_ERRORS = "errors";
    @Nullable
    private JsonNullable<List<ProblemDto>> errors = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    @Nullable
    private JsonNullable<List<ProblemDto>> warnings = JsonNullable.undefined();

    public ResourceReportDto errors(@Nullable List<ProblemDto> errors) {
        this.errors = JsonNullable.of(errors);
        return this;
    }

    public ResourceReportDto addErrorsItem(ProblemDto errorsItem) {
        if (this.errors == null || !this.errors.isPresent()) {
            this.errors = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.errors.get()).add(errorsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<ProblemDto> getErrors() {
        return (List)this.errors.orElse(null);
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<ProblemDto>> getErrors_JsonNullable() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    public void setErrors_JsonNullable(JsonNullable<List<ProblemDto>> errors) {
        this.errors = errors;
    }

    public void setErrors(@Nullable List<ProblemDto> errors) {
        this.errors = JsonNullable.of(errors);
    }

    public ResourceReportDto warnings(@Nullable List<ProblemDto> warnings) {
        this.warnings = JsonNullable.of(warnings);
        return this;
    }

    public ResourceReportDto addWarningsItem(ProblemDto warningsItem) {
        if (this.warnings == null || !this.warnings.isPresent()) {
            this.warnings = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.warnings.get()).add(warningsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<ProblemDto> getWarnings() {
        return (List)this.warnings.orElse(null);
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<ProblemDto>> getWarnings_JsonNullable() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    public void setWarnings_JsonNullable(JsonNullable<List<ProblemDto>> warnings) {
        this.warnings = warnings;
    }

    public void setWarnings(@Nullable List<ProblemDto> warnings) {
        this.warnings = JsonNullable.of(warnings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceReportDto resourceReportDto = (ResourceReportDto)o;
        return ResourceReportDto.equalsNullable(this.errors, resourceReportDto.errors) && ResourceReportDto.equalsNullable(this.warnings, resourceReportDto.warnings);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(ResourceReportDto.hashCodeNullable(this.errors), ResourceReportDto.hashCodeNullable(this.warnings));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceReportDto {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getErrors() != null) {
            for (i = 0; i < this.getErrors().size(); ++i) {
                if (this.getErrors().get(i) == null) continue;
                joiner.add(this.getErrors().get(i).toUrlQueryString(String.format("%serrors%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getWarnings() != null) {
            for (i = 0; i < this.getWarnings().size(); ++i) {
                if (this.getWarnings().get(i) == null) continue;
                joiner.add(this.getWarnings().get(i).toUrlQueryString(String.format("%swarnings%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

