/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.TelemetryInternalsDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"name", "version", "edition", "internals"})
public class TelemetryProductDto {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private JsonNullable<String> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private JsonNullable<String> version = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EDITION = "edition";
    @Nullable
    private JsonNullable<String> edition = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INTERNALS = "internals";
    @Nullable
    private TelemetryInternalsDto internals;

    public TelemetryProductDto name(@Nullable String name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getName() {
        return (String)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<String> name) {
        this.name = name;
    }

    public void setName(@Nullable String name) {
        this.name = JsonNullable.of((Object)name);
    }

    public TelemetryProductDto version(@Nullable String version) {
        this.version = JsonNullable.of((Object)version);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getVersion() {
        return (String)this.version.orElse(null);
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getVersion_JsonNullable() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion_JsonNullable(JsonNullable<String> version) {
        this.version = version;
    }

    public void setVersion(@Nullable String version) {
        this.version = JsonNullable.of((Object)version);
    }

    public TelemetryProductDto edition(@Nullable String edition) {
        this.edition = JsonNullable.of((Object)edition);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getEdition() {
        return (String)this.edition.orElse(null);
    }

    @JsonProperty(value="edition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getEdition_JsonNullable() {
        return this.edition;
    }

    @JsonProperty(value="edition")
    public void setEdition_JsonNullable(JsonNullable<String> edition) {
        this.edition = edition;
    }

    public void setEdition(@Nullable String edition) {
        this.edition = JsonNullable.of((Object)edition);
    }

    public TelemetryProductDto internals(@Nullable TelemetryInternalsDto internals) {
        this.internals = internals;
        return this;
    }

    @Nullable
    @JsonProperty(value="internals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TelemetryInternalsDto getInternals() {
        return this.internals;
    }

    @JsonProperty(value="internals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternals(@Nullable TelemetryInternalsDto internals) {
        this.internals = internals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryProductDto telemetryProductDto = (TelemetryProductDto)o;
        return TelemetryProductDto.equalsNullable(this.name, telemetryProductDto.name) && TelemetryProductDto.equalsNullable(this.version, telemetryProductDto.version) && TelemetryProductDto.equalsNullable(this.edition, telemetryProductDto.edition) && Objects.equals(this.internals, telemetryProductDto.internals);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(TelemetryProductDto.hashCodeNullable(this.name), TelemetryProductDto.hashCodeNullable(this.version), TelemetryProductDto.hashCodeNullable(this.edition), this.internals);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryProductDto {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    edition: ").append(this.toIndentedString(this.edition)).append("\n");
        sb.append("    internals: ").append(this.toIndentedString(this.internals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVersion() != null) {
            try {
                joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEdition() != null) {
            try {
                joiner.add(String.format("%sedition%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEdition()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInternals() != null) {
            joiner.add(this.getInternals().toUrlQueryString(prefix + JSON_PROPERTY_INTERNALS + suffix));
        }
        return joiner.toString();
    }
}

