/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.springboot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.camunda.community.rest.client.api.DeploymentApi;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.springboot.CamundaAutodeploymentProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.DigestUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={CamundaAutodeploymentProperties.class})
public class CamundaProcessAutodeployment {
    private static final Logger logger = LoggerFactory.getLogger(CamundaProcessAutodeployment.class);
    private final DeploymentApi deploymentApi;
    private final ResourcePatternResolver patternResolver;
    private final CamundaAutodeploymentProperties properties;
    private final String applicationName;

    public CamundaProcessAutodeployment(DeploymentApi deploymentApi, ResourcePatternResolver patternResolver, CamundaAutodeploymentProperties properties, @Value(value="${spring.application.name:spring-app}") String applicationName) {
        this.deploymentApi = deploymentApi;
        this.patternResolver = patternResolver;
        this.properties = properties;
        this.applicationName = applicationName;
    }

    @EventListener(value={ApplicationStartedEvent.class})
    public void deployCamundaResources() throws IOException, ApiException {
        if (!this.properties.getEnabled().booleanValue()) {
            return;
        }
        this.deployResources(Arrays.asList(this.patternResolver.getResources(this.properties.getBpmnResources())), "bpmn");
        this.deployResources(Arrays.asList(this.patternResolver.getResources(this.properties.getDmnResources())), "dmn");
        this.deployResources(Arrays.asList(this.patternResolver.getResources(this.properties.getFormResources())), "form");
    }

    private void deployResources(List<Resource> resourcesToDeploy, String type) throws IOException, ApiException {
        logger.info("Found resources for deployment of type " + type + ": " + resourcesToDeploy);
        for (Resource camundaResource : resourcesToDeploy) {
            try {
                String tempDirectoryName = FileUtils.getTempDirectory().getAbsolutePath();
                String filename = this.getResourceFilename(camundaResource, type);
                File tempFile = new File(tempDirectoryName + File.separator + filename);
                tempFile.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(tempFile);){
                    IOUtils.copy((InputStream)camundaResource.getInputStream(), (OutputStream)out);
                }
                logger.info("  - Now deploying: " + camundaResource);
                this.deploymentApi.createDeployment(null, null, Boolean.valueOf(true), Boolean.valueOf(true), this.applicationName + "-" + filename, null, tempFile);
            }
            catch (Exception exception) {
                logger.error("Error Deploying resources for deployment of type " + type + ": " + resourcesToDeploy);
                if (!this.properties.getFailStartupOnError().booleanValue()) continue;
                throw exception;
            }
        }
    }

    private String getResourceFilename(Resource camundaResource, String type) throws IOException {
        if (camundaResource.getFilename() != null) {
            return camundaResource.getFilename();
        }
        return DigestUtils.md5DigestAsHex((InputStream)camundaResource.getInputStream()) + '.' + type;
    }
}

