/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.engine;

import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.engine.EzeLogStream;
import org.camunda.community.eze.engine.InMemoryLogStorage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/camunda/community/eze/engine/EzeLogStreamFactory;", "", "()V", "createLogStorage", "Lio/camunda/zeebe/logstreams/storage/LogStorage;", "createLogStream", "Lio/camunda/zeebe/logstreams/log/LogStream;", "partitionId", "", "logStorage", "scheduler", "Lio/camunda/zeebe/scheduler/ActorSchedulingService;", "Lorg/camunda/community/eze/engine/EzeLogStream;", "eze"})
public final class EzeLogStreamFactory {
    @NotNull
    public static final EzeLogStreamFactory INSTANCE = new EzeLogStreamFactory();

    private EzeLogStreamFactory() {
    }

    @NotNull
    public final EzeLogStream createLogStream(int partitionId, @NotNull ActorSchedulingService scheduler) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        LogStorage logStorage = this.createLogStorage();
        LogStream logStream = this.createLogStream(partitionId, logStorage, scheduler);
        return new EzeLogStream(logStream);
    }

    private final LogStorage createLogStorage() {
        return new InMemoryLogStorage();
    }

    private final LogStream createLogStream(int partitionId, LogStorage logStorage, ActorSchedulingService scheduler) {
        LogStreamBuilder builder = LogStream.builder().withPartitionId(partitionId).withLogStorage(logStorage).withLogName("EZE-LOG").withActorSchedulingService(scheduler);
        CompletableFuture theFuture = new CompletableFuture();
        scheduler.submitActor(Actor.wrap(arg_0 -> EzeLogStreamFactory.createLogStream$lambda$1(builder, theFuture, arg_0)));
        Object t = theFuture.join();
        Intrinsics.checkNotNullExpressionValue(t, (String)"theFuture.join()");
        return (LogStream)t;
    }

    private static final void createLogStream$lambda$1$lambda$0(CompletableFuture $theFuture, LogStream logStream, Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)$theFuture, (String)"$theFuture");
        if (failure != null) {
            $theFuture.completeExceptionally(failure);
        } else {
            $theFuture.complete(logStream);
        }
    }

    private static final void createLogStream$lambda$1(LogStreamBuilder $builder, CompletableFuture $theFuture, ActorControl it) {
        Intrinsics.checkNotNullParameter((Object)$theFuture, (String)"$theFuture");
        $builder.buildAsync().onComplete((arg_0, arg_1) -> EzeLogStreamFactory.createLogStream$lambda$1$lambda$0($theFuture, arg_0, arg_1));
    }
}

