/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.http.impl.auth;

import connectjar.org.apache.http.Header;
import connectjar.org.apache.http.HttpRequest;
import connectjar.org.apache.http.annotation.NotThreadSafe;
import connectjar.org.apache.http.auth.AuthenticationException;
import connectjar.org.apache.http.auth.Credentials;
import connectjar.org.apache.http.impl.auth.GGSSchemeBase;
import connectjar.org.apache.http.protocol.HttpContext;
import connectjar.org.apache.http.util.Args;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@NotThreadSafe
public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(boolean stripPort) {
        super(stripPort);
    }

    public KerberosScheme() {
        super(false);
    }

    public String getSchemeName() {
        return "Kerberos";
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return super.authenticate(credentials, request, context);
    }

    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return this.generateGSSToken(input, new Oid(KERBEROS_OID), authServer);
    }

    public String getParameter(String name) {
        Args.notNull(name, "Parameter name");
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }
}

