/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.http.impl.conn;

import connectjar.org.apache.http.HttpResponse;
import connectjar.org.apache.http.HttpResponseFactory;
import connectjar.org.apache.http.annotation.Immutable;
import connectjar.org.apache.http.config.MessageConstraints;
import connectjar.org.apache.http.impl.DefaultHttpResponseFactory;
import connectjar.org.apache.http.impl.conn.DefaultHttpResponseParser;
import connectjar.org.apache.http.io.HttpMessageParser;
import connectjar.org.apache.http.io.HttpMessageParserFactory;
import connectjar.org.apache.http.io.SessionInputBuffer;
import connectjar.org.apache.http.message.BasicLineParser;
import connectjar.org.apache.http.message.LineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

