/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.http.client.protocol;

import connectjar.org.apache.http.Header;
import connectjar.org.apache.http.HttpException;
import connectjar.org.apache.http.HttpRequest;
import connectjar.org.apache.http.HttpRequestInterceptor;
import connectjar.org.apache.http.annotation.Contract;
import connectjar.org.apache.http.annotation.ThreadingBehavior;
import connectjar.org.apache.http.protocol.HttpContext;
import connectjar.org.apache.http.util.Args;
import java.io.IOException;
import java.util.Collection;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

