/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.httpclient.impl;

import java.util.Collection;
import java.util.function.BiConsumer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public enum RequestConfigOption {
    AUTHENTICATION_ENABLED("authentication-enabled", (builder, value) -> builder.setAuthenticationEnabled(((Boolean)value).booleanValue())),
    CIRCULAR_REDIRECTS_ALLOWED("circular-redirects-allowed", (builder, value) -> builder.setCircularRedirectsAllowed(((Boolean)value).booleanValue())),
    CONNECTION_TIMEOUT("connection-timeout", (builder, value) -> builder.setConnectTimeout((Timeout)value)),
    CONNECTION_KEEP_ALIVE("connection-keep-alive", (builder, value) -> builder.setConnectionKeepAlive((TimeValue)((Timeout)value))),
    CONNECTION_REQUEST_TIMEOUT("connection-request-timeout", (builder, value) -> builder.setConnectionRequestTimeout((Timeout)value)),
    CONTENT_COMPRESSION_ENABLED("content-compression-enabled", (builder, value) -> builder.setContentCompressionEnabled(((Boolean)value).booleanValue())),
    COOKIE_SPEC("cookie-spec", (builder, value) -> builder.setCookieSpec((String)value)),
    EXPECT_CONTINUE_ENABLED("expect-continue-enabled", (builder, value) -> builder.setExpectContinueEnabled(((Boolean)value).booleanValue())),
    HARD_CANCELLATION_ENABLED("hard-cancellation-enabled", (builder, value) -> builder.setHardCancellationEnabled(((Boolean)value).booleanValue())),
    MAX_REDIRECTS("max-redirects", (builder, value) -> builder.setMaxRedirects(((Integer)value).intValue())),
    PROXY("proxy", (builder, value) -> builder.setProxy((HttpHost)value)),
    PROXY_PREFERRED_AUTH_SCHEMES("proxy-preferred-auth-scheme", (builder, value) -> builder.setProxyPreferredAuthSchemes((Collection)value)),
    REDIRECTS_ENABLED("redirects-enabled", (builder, value) -> builder.setRedirectsEnabled(((Boolean)value).booleanValue())),
    RESPONSE_TIMEOUT("response-timeout", (builder, value) -> builder.setResponseTimeout((Timeout)value)),
    TARGET_PREFERRED_AUTH_SCHEMES("target-preferred-auth-schemes", (builder, value) -> builder.setTargetPreferredAuthSchemes((Collection)value));

    private final String name;
    private final BiConsumer<RequestConfig.Builder, Object> consumer;

    private RequestConfigOption(String name, BiConsumer<RequestConfig.Builder, Object> consumer) {
        this.name = name;
        this.consumer = consumer;
    }

    public String getName() {
        return this.name;
    }

    public void apply(RequestConfig.Builder configBuilder, Object value) {
        this.consumer.accept(configBuilder, value);
    }
}

