/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.fasterxml.uuid;

import camundajar.impl.com.fasterxml.uuid.EthernetAddress;
import camundajar.impl.com.fasterxml.uuid.TimestampSynchronizer;
import camundajar.impl.com.fasterxml.uuid.UUIDClock;
import camundajar.impl.com.fasterxml.uuid.UUIDTimer;
import camundajar.impl.com.fasterxml.uuid.UUIDType;
import camundajar.impl.com.fasterxml.uuid.impl.NameBasedGenerator;
import camundajar.impl.com.fasterxml.uuid.impl.RandomBasedGenerator;
import camundajar.impl.com.fasterxml.uuid.impl.TimeBasedEpochGenerator;
import camundajar.impl.com.fasterxml.uuid.impl.TimeBasedEpochRandomGenerator;
import camundajar.impl.com.fasterxml.uuid.impl.TimeBasedGenerator;
import camundajar.impl.com.fasterxml.uuid.impl.TimeBasedReorderedGenerator;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.UUID;

public class Generators {
    protected static UUIDTimer _sharedTimer;
    protected static EthernetAddress _preferredIfAddr;

    public static RandomBasedGenerator randomBasedGenerator() {
        return Generators.randomBasedGenerator(null);
    }

    public static RandomBasedGenerator randomBasedGenerator(Random rnd) {
        return new RandomBasedGenerator(rnd);
    }

    public static NameBasedGenerator nameBasedGenerator() {
        return Generators.nameBasedGenerator(null);
    }

    public static NameBasedGenerator nameBasedGenerator(UUID namespace) {
        return Generators.nameBasedGenerator(namespace, null);
    }

    public static NameBasedGenerator nameBasedGenerator(UUID namespace, MessageDigest digester) {
        UUIDType type = null;
        if (digester == null) {
            try {
                digester = MessageDigest.getInstance("SHA-1");
                type = UUIDType.NAME_BASED_SHA1;
            }
            catch (NoSuchAlgorithmException nex) {
                throw new IllegalArgumentException("Couldn't instantiate SHA-1 MessageDigest instance: " + nex.toString());
            }
        }
        return new NameBasedGenerator(namespace, digester, type);
    }

    public static TimeBasedEpochGenerator timeBasedEpochGenerator() {
        return Generators.timeBasedEpochGenerator(null);
    }

    public static TimeBasedEpochGenerator timeBasedEpochGenerator(Random random) {
        return new TimeBasedEpochGenerator(random);
    }

    public static TimeBasedEpochGenerator timeBasedEpochGenerator(Random random, UUIDClock clock) {
        return new TimeBasedEpochGenerator(random, clock);
    }

    public static TimeBasedEpochRandomGenerator timeBasedEpochRandomGenerator() {
        return Generators.timeBasedEpochRandomGenerator(null);
    }

    public static TimeBasedEpochRandomGenerator timeBasedEpochRandomGenerator(Random random) {
        return new TimeBasedEpochRandomGenerator(random);
    }

    public static TimeBasedEpochRandomGenerator timeBasedEpochRandomGenerator(Random random, UUIDClock clock) {
        return new TimeBasedEpochRandomGenerator(random, clock);
    }

    public static TimeBasedGenerator defaultTimeBasedGenerator() {
        return Generators.timeBasedGenerator(Generators.preferredInterfaceAddress());
    }

    public static TimeBasedGenerator timeBasedGenerator() {
        return Generators.timeBasedGenerator(null);
    }

    public static TimeBasedGenerator timeBasedGenerator(EthernetAddress ethernetAddress) {
        return Generators.timeBasedGenerator(ethernetAddress, (UUIDTimer)null);
    }

    public static TimeBasedGenerator timeBasedGenerator(EthernetAddress ethernetAddress, TimestampSynchronizer sync) {
        UUIDTimer timer;
        try {
            timer = new UUIDTimer(new Random(System.currentTimeMillis()), sync);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to create UUIDTimer with specified synchronizer: " + e.getMessage(), e);
        }
        return Generators.timeBasedGenerator(ethernetAddress, timer);
    }

    public static TimeBasedGenerator timeBasedGenerator(EthernetAddress ethernetAddress, UUIDTimer timer) {
        if (timer == null) {
            timer = Generators.sharedTimer();
        }
        return new TimeBasedGenerator(ethernetAddress, timer);
    }

    public static TimeBasedReorderedGenerator timeBasedReorderedGenerator() {
        return Generators.timeBasedReorderedGenerator(null);
    }

    public static TimeBasedReorderedGenerator timeBasedReorderedGenerator(EthernetAddress ethernetAddress) {
        return Generators.timeBasedReorderedGenerator(ethernetAddress, null);
    }

    public static TimeBasedReorderedGenerator timeBasedReorderedGenerator(EthernetAddress ethernetAddress, UUIDTimer timer) {
        if (timer == null) {
            timer = Generators.sharedTimer();
        }
        return new TimeBasedReorderedGenerator(ethernetAddress, timer);
    }

    private static synchronized UUIDTimer sharedTimer() {
        if (_sharedTimer == null) {
            try {
                _sharedTimer = new UUIDTimer(new Random(System.currentTimeMillis()), null);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to create UUIDTimer with specified synchronizer: " + e.getMessage(), e);
            }
        }
        return _sharedTimer;
    }

    private static synchronized EthernetAddress preferredInterfaceAddress() {
        if (_preferredIfAddr == null) {
            _preferredIfAddr = EthernetAddress.fromPreferredInterface();
        }
        return _preferredIfAddr;
    }

    static {
        _preferredIfAddr = null;
    }
}

