/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.fasterxml.uuid.impl;

import camundajar.impl.com.fasterxml.uuid.NoArgGenerator;
import camundajar.impl.com.fasterxml.uuid.UUIDClock;
import camundajar.impl.com.fasterxml.uuid.UUIDType;
import camundajar.impl.com.fasterxml.uuid.impl.LazyRandom;
import camundajar.impl.com.fasterxml.uuid.impl.UUIDUtil;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimeBasedEpochRandomGenerator
extends NoArgGenerator {
    private static final int ENTROPY_BYTE_LENGTH = 10;
    protected final Random _random;
    protected final UUIDClock _clock;
    private final byte[] _lastEntropy = new byte[10];
    private final Lock lock = new ReentrantLock();

    public TimeBasedEpochRandomGenerator(Random rnd) {
        this(rnd, UUIDClock.systemTimeClock());
    }

    public TimeBasedEpochRandomGenerator(Random rnd, UUIDClock clock) {
        if (rnd == null) {
            rnd = LazyRandom.sharedSecureRandom();
        }
        this._random = rnd;
        this._clock = clock;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED_EPOCH;
    }

    @Override
    public UUID generate() {
        return this.construct(this._clock.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID construct(long rawTimestamp) {
        this.lock.lock();
        try {
            this._random.nextBytes(this._lastEntropy);
            UUID uUID = UUIDUtil.constructUUID(UUIDType.TIME_BASED_EPOCH, rawTimestamp << 16 | TimeBasedEpochRandomGenerator._toShort(this._lastEntropy, 0), TimeBasedEpochRandomGenerator._toLong(this._lastEntropy, 2));
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }
}

