/*
 * Decompiled with CFR 0.152.
 */
package spinjar.javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import spinjar.javax.xml.bind.GetPropertyAction;
import spinjar.javax.xml.bind.JAXBContext;
import spinjar.javax.xml.bind.JAXBException;
import spinjar.javax.xml.bind.Messages;

class ContextFinder {
    private static final Logger logger = Logger.getLogger("spinjar.javax.xml.bind");
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.internal.bind.v2.ContextFactory";

    ContextFinder() {
    }

    private static void handleInvocationTargetException(InvocationTargetException x) throws JAXBException {
        Throwable t = x.getTargetException();
        if (t != null) {
            if (t instanceof JAXBException) {
                throw (JAXBException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
    }

    private static JAXBException handleClassCastException(Class originalType, Class targetType) {
        URL targetTypeURL = ContextFinder.which(targetType);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", originalType.getClassLoader().getResource("spinjar/javax/xml/bind/JAXBContext.class"), targetTypeURL));
    }

    static JAXBContext newInstance(String contextPath, String className, ClassLoader classLoader, Map properties) throws JAXBException {
        try {
            Class spFactory = ContextFinder.safeLoadClass(className, classLoader);
            return ContextFinder.newInstance(contextPath, spFactory, classLoader, properties);
        }
        catch (ClassNotFoundException x) {
            throw new JAXBException(Messages.format("ContextFinder.ProviderNotFound", className), x);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", className, x), x);
        }
    }

    static JAXBContext newInstance(String contextPath, Class spFactory, ClassLoader classLoader, Map properties) throws JAXBException {
        try {
            Method m;
            Object context = null;
            try {
                m = spFactory.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                context = m.invoke(null, contextPath, classLoader, properties);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (context == null) {
                m = spFactory.getMethod("createContext", String.class, ClassLoader.class);
                context = m.invoke(null, contextPath, classLoader);
            }
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (InvocationTargetException x) {
            ContextFinder.handleInvocationTargetException(x);
            Throwable e = x;
            if (x.getTargetException() != null) {
                e = x.getTargetException();
            }
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, e), e);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, x), x);
        }
    }

    static JAXBContext newInstance(Class[] classes, Map properties, String className) throws JAXBException {
        Class spi;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            spi = ContextFinder.safeLoadClass(className, cl);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException(e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{className, ContextFinder.which(spi)});
        }
        return ContextFinder.newInstance(classes, properties, spi);
    }

    static JAXBContext newInstance(Class[] classes, Map properties, Class spFactory) throws JAXBException {
        Method m;
        try {
            m = spFactory.getMethod("createContext", Class[].class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new JAXBException(e);
        }
        try {
            Object context = m.invoke(null, classes, properties);
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (IllegalAccessException e) {
            throw new JAXBException(e);
        }
        catch (InvocationTargetException e) {
            ContextFinder.handleInvocationTargetException(e);
            Throwable x = e;
            if (e.getTargetException() != null) {
                x = e.getTargetException();
            }
            throw new JAXBException(x);
        }
    }

    static JAXBContext find(String factoryId, String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        Class factory;
        String jaxbContextFQCN = JAXBContext.class.getName();
        StringTokenizer packages = new StringTokenizer(contextPath, ":");
        if (!packages.hasMoreTokens()) {
            throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
        }
        logger.fine("Searching jaxb.properties");
        while (packages.hasMoreTokens()) {
            String packageName = packages.nextToken(":").replace('.', '/');
            StringBuilder propFileName = new StringBuilder().append(packageName).append("/jaxb.properties");
            Properties props = ContextFinder.loadJAXBProperties(classLoader, propFileName.toString());
            if (props == null) continue;
            if (props.containsKey(factoryId)) {
                String factoryClassName = props.getProperty(factoryId);
                return ContextFinder.newInstance(contextPath, factoryClassName, classLoader, properties);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", packageName, factoryId));
        }
        logger.fine("Searching the system property");
        String factoryClassName = AccessController.doPrivileged(new GetPropertyAction("spinjar.javax.xml.bind.context.factory"));
        if (factoryClassName != null) {
            return ContextFinder.newInstance(contextPath, factoryClassName, classLoader, properties);
        }
        factoryClassName = AccessController.doPrivileged(new GetPropertyAction(jaxbContextFQCN));
        if (factoryClassName != null) {
            return ContextFinder.newInstance(contextPath, factoryClassName, classLoader, properties);
        }
        if (Thread.currentThread().getContextClassLoader() == classLoader && (factory = ContextFinder.lookupUsingOSGiServiceLoader("spinjar.javax.xml.bind.JAXBContext")) != null) {
            logger.fine("OSGi environment detected");
            return ContextFinder.newInstance(contextPath, factory, classLoader, properties);
        }
        logger.fine("Searching META-INF/services");
        try {
            StringBuilder resource = new StringBuilder().append("META-INF/services/").append(jaxbContextFQCN);
            InputStream resourceStream = classLoader.getResourceAsStream(resource.toString());
            if (resourceStream != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
                factoryClassName = r.readLine().trim();
                r.close();
                return ContextFinder.newInstance(contextPath, factoryClassName, classLoader, properties);
            }
            logger.log(Level.FINE, "Unable to load:{0}", resource.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new JAXBException(e);
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(contextPath, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader, properties);
    }

    static JAXBContext find(Class[] classes, Map properties) throws JAXBException {
        String jaxbContextFQCN = JAXBContext.class.getName();
        for (final Class c : classes) {
            ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return c.getClassLoader();
                }
            });
            Package pkg = c.getPackage();
            if (pkg == null) continue;
            String packageName = pkg.getName().replace('.', '/');
            String resourceName = packageName + "/jaxb.properties";
            logger.log(Level.FINE, "Trying to locate {0}", resourceName);
            Properties props = ContextFinder.loadJAXBProperties(classLoader, resourceName);
            if (props == null) {
                logger.fine("  not found");
                continue;
            }
            logger.fine("  found");
            if (props.containsKey("spinjar.javax.xml.bind.context.factory")) {
                String factoryClassName = props.getProperty("spinjar.javax.xml.bind.context.factory").trim();
                return ContextFinder.newInstance(classes, properties, factoryClassName);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", packageName, "spinjar.javax.xml.bind.context.factory"));
        }
        logger.log(Level.FINE, "Checking system property {0}", "spinjar.javax.xml.bind.context.factory");
        String factoryClassName = AccessController.doPrivileged(new GetPropertyAction("spinjar.javax.xml.bind.context.factory"));
        if (factoryClassName != null) {
            logger.log(Level.FINE, "  found {0}", factoryClassName);
            return ContextFinder.newInstance(classes, properties, factoryClassName);
        }
        logger.fine("  not found");
        logger.log(Level.FINE, "Checking system property {0}", jaxbContextFQCN);
        factoryClassName = AccessController.doPrivileged(new GetPropertyAction(jaxbContextFQCN));
        if (factoryClassName != null) {
            logger.log(Level.FINE, "  found {0}", factoryClassName);
            return ContextFinder.newInstance(classes, properties, factoryClassName);
        }
        logger.fine("  not found");
        Class factory = ContextFinder.lookupUsingOSGiServiceLoader("spinjar.javax.xml.bind.JAXBContext");
        if (factory != null) {
            logger.fine("OSGi environment detected");
            return ContextFinder.newInstance(classes, properties, factory);
        }
        logger.fine("Checking META-INF/services");
        try {
            String resource = "META-INF/services/" + jaxbContextFQCN;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resourceURL = classLoader == null ? ClassLoader.getSystemResource(resource) : classLoader.getResource(resource);
            if (resourceURL != null) {
                logger.log(Level.FINE, "Reading {0}", resourceURL);
                BufferedReader r = new BufferedReader(new InputStreamReader(resourceURL.openStream(), "UTF-8"));
                factoryClassName = r.readLine().trim();
                return ContextFinder.newInstance(classes, properties, factoryClassName);
            }
            logger.log(Level.FINE, "Unable to find: {0}", resource);
        }
        catch (UnsupportedEncodingException e) {
            throw new JAXBException(e);
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(classes, properties, PLATFORM_DEFAULT_FACTORY_CLASS);
    }

    private static Class lookupUsingOSGiServiceLoader(String factoryId) {
        try {
            Class<?> serviceClass = Class.forName(factoryId);
            Class<?> target = Class.forName("org.glassfish.hk2.osgiresourcelocator.ServiceLoader");
            Method m = target.getMethod("lookupProviderClasses", Class.class);
            Iterator iter = ((Iterable)m.invoke(null, serviceClass)).iterator();
            return iter.hasNext() ? (Class)iter.next() : null;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Unable to find from OSGi: {0}", factoryId);
            return null;
        }
    }

    private static Properties loadJAXBProperties(ClassLoader classLoader, String propFileName) throws JAXBException {
        Properties props = null;
        try {
            URL url = classLoader == null ? ClassLoader.getSystemResource(propFileName) : classLoader.getResource(propFileName);
            if (url != null) {
                logger.log(Level.FINE, "loading props from {0}", url);
                props = new Properties();
                InputStream is = url.openStream();
                props.load(is);
                is.close();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Unable to load " + propFileName, ioe);
            throw new JAXBException(ioe.toString(), ioe);
        }
        return props;
    }

    static URL which(Class clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    static URL which(Class clazz) {
        return ContextFinder.which(clazz, clazz.getClassLoader());
    }

    private static Class safeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        logger.log(Level.FINE, "Trying to load {0}", className);
        try {
            int i;
            SecurityManager s = System.getSecurityManager();
            if (s != null && (i = className.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(className.substring(0, i));
            }
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (SecurityException se) {
            if (PLATFORM_DEFAULT_FACTORY_CLASS.equals(className)) {
                return Class.forName(className);
            }
            throw se;
        }
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

