/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal.filter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import spinjar.com.jayway.jsonpath.JsonPathException;
import spinjar.com.jayway.jsonpath.Predicate;
import spinjar.com.jayway.jsonpath.internal.filter.Evaluator;
import spinjar.com.jayway.jsonpath.internal.filter.RelationalOperator;
import spinjar.com.jayway.jsonpath.internal.filter.ValueNode;
import spinjar.com.jayway.jsonpath.internal.filter.ValueNodes;

public class EvaluatorFactory {
    private static final Map<RelationalOperator, Evaluator> evaluators = new HashMap<RelationalOperator, Evaluator>();

    public static Evaluator createEvaluator(RelationalOperator operator) {
        return evaluators.get((Object)operator);
    }

    static {
        evaluators.put(RelationalOperator.EXISTS, new ExistsEvaluator());
        evaluators.put(RelationalOperator.NE, new NotEqualsEvaluator());
        evaluators.put(RelationalOperator.TSNE, new TypeSafeNotEqualsEvaluator());
        evaluators.put(RelationalOperator.EQ, new EqualsEvaluator());
        evaluators.put(RelationalOperator.TSEQ, new TypeSafeEqualsEvaluator());
        evaluators.put(RelationalOperator.LT, new LessThanEvaluator());
        evaluators.put(RelationalOperator.LTE, new LessThanEqualsEvaluator());
        evaluators.put(RelationalOperator.GT, new GreaterThanEvaluator());
        evaluators.put(RelationalOperator.GTE, new GreaterThanEqualsEvaluator());
        evaluators.put(RelationalOperator.REGEX, new RegexpEvaluator());
        evaluators.put(RelationalOperator.SIZE, new SizeEvaluator());
        evaluators.put(RelationalOperator.EMPTY, new EmptyEvaluator());
        evaluators.put(RelationalOperator.IN, new InEvaluator());
        evaluators.put(RelationalOperator.NIN, new NotInEvaluator());
        evaluators.put(RelationalOperator.ALL, new AllEvaluator());
        evaluators.put(RelationalOperator.CONTAINS, new ContainsEvaluator());
        evaluators.put(RelationalOperator.MATCHES, new PredicateMatchEvaluator());
        evaluators.put(RelationalOperator.TYPE, new TypeEvaluator());
        evaluators.put(RelationalOperator.SUBSETOF, new SubsetOfEvaluator());
        evaluators.put(RelationalOperator.ANYOF, new AnyOfEvaluator());
        evaluators.put(RelationalOperator.NONEOF, new NoneOfEvaluator());
    }

    private static class NoneOfEvaluator
    implements Evaluator {
        private NoneOfEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            ValueNodes.ValueListNode leftValueListNode;
            ValueNodes.ValueListNode rightValueListNode;
            if (right.isJsonNode()) {
                ValueNode vn = right.asJsonNode().asValueListNode(ctx);
                if (vn.isUndefinedNode()) {
                    return false;
                }
                rightValueListNode = vn.asValueListNode();
            } else {
                rightValueListNode = right.asValueListNode();
            }
            if (left.isJsonNode()) {
                ValueNode vn = left.asJsonNode().asValueListNode(ctx);
                if (vn.isUndefinedNode()) {
                    return false;
                }
                leftValueListNode = vn.asValueListNode();
            } else {
                leftValueListNode = left.asValueListNode();
            }
            for (ValueNode leftValueNode : leftValueListNode) {
                for (ValueNode rightValueNode : rightValueListNode) {
                    if (!leftValueNode.equals(rightValueNode)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class AnyOfEvaluator
    implements Evaluator {
        private AnyOfEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            ValueNodes.ValueListNode leftValueListNode;
            ValueNodes.ValueListNode rightValueListNode;
            if (right.isJsonNode()) {
                ValueNode vn = right.asJsonNode().asValueListNode(ctx);
                if (vn.isUndefinedNode()) {
                    return false;
                }
                rightValueListNode = vn.asValueListNode();
            } else {
                rightValueListNode = right.asValueListNode();
            }
            if (left.isJsonNode()) {
                ValueNode vn = left.asJsonNode().asValueListNode(ctx);
                if (vn.isUndefinedNode()) {
                    return false;
                }
                leftValueListNode = vn.asValueListNode();
            } else {
                leftValueListNode = left.asValueListNode();
            }
            for (ValueNode leftValueNode : leftValueListNode) {
                for (ValueNode rightValueNode : rightValueListNode) {
                    if (!leftValueNode.equals(rightValueNode)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class SubsetOfEvaluator
    implements Evaluator {
        private SubsetOfEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            ValueNodes.ValueListNode leftValueListNode;
            ValueNodes.ValueListNode rightValueListNode;
            if (right.isJsonNode()) {
                ValueNode vn = right.asJsonNode().asValueListNode(ctx);
                if (vn.isUndefinedNode()) {
                    return false;
                }
                rightValueListNode = vn.asValueListNode();
            } else {
                rightValueListNode = right.asValueListNode();
            }
            if (left.isJsonNode()) {
                ValueNode vn = left.asJsonNode().asValueListNode(ctx);
                if (vn.isUndefinedNode()) {
                    return false;
                }
                leftValueListNode = vn.asValueListNode();
            } else {
                leftValueListNode = left.asValueListNode();
            }
            return leftValueListNode.subsetof(rightValueListNode);
        }
    }

    private static class RegexpEvaluator
    implements Evaluator {
        private RegexpEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (!(left.isPatternNode() ^ right.isPatternNode())) {
                return false;
            }
            if (left.isPatternNode()) {
                if (right.isValueListNode() || right.isJsonNode() && right.asJsonNode().isArray(ctx)) {
                    return this.matchesAny(left.asPatternNode(), right.asJsonNode().asValueListNode(ctx));
                }
                return this.matches(left.asPatternNode(), this.getInput(right));
            }
            if (left.isValueListNode() || left.isJsonNode() && left.asJsonNode().isArray(ctx)) {
                return this.matchesAny(right.asPatternNode(), left.asJsonNode().asValueListNode(ctx));
            }
            return this.matches(right.asPatternNode(), this.getInput(left));
        }

        private boolean matches(ValueNodes.PatternNode patternNode, String inputToMatch) {
            return patternNode.getCompiledPattern().matcher(inputToMatch).matches();
        }

        private boolean matchesAny(ValueNodes.PatternNode patternNode, ValueNode valueNode) {
            if (!valueNode.isValueListNode()) {
                return false;
            }
            ValueNodes.ValueListNode listNode = valueNode.asValueListNode();
            Pattern pattern = patternNode.getCompiledPattern();
            Iterator<ValueNode> it = listNode.iterator();
            while (it.hasNext()) {
                String input = this.getInput(it.next());
                if (!pattern.matcher(input).matches()) continue;
                return true;
            }
            return false;
        }

        private String getInput(ValueNode valueNode) {
            String input = "";
            if (valueNode.isStringNode() || valueNode.isNumberNode()) {
                input = valueNode.asStringNode().getString();
            } else if (valueNode.isBooleanNode()) {
                input = valueNode.asBooleanNode().toString();
            }
            return input;
        }
    }

    private static class PredicateMatchEvaluator
    implements Evaluator {
        private PredicateMatchEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            return right.asPredicateNode().getPredicate().apply(ctx);
        }
    }

    private static class ContainsEvaluator
    implements Evaluator {
        private ContainsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (left.isStringNode() && right.isStringNode()) {
                return left.asStringNode().contains(right.asStringNode().getString());
            }
            if (left.isJsonNode()) {
                ValueNode valueNode = left.asJsonNode().asValueListNode(ctx);
                if (valueNode.isUndefinedNode()) {
                    return false;
                }
                boolean res = valueNode.asValueListNode().contains(right);
                return res;
            }
            return false;
        }
    }

    private static class AllEvaluator
    implements Evaluator {
        private AllEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            ValueNodes.ValueListNode requiredValues = right.asValueListNode();
            if (left.isJsonNode()) {
                ValueNode valueNode = left.asJsonNode().asValueListNode(ctx);
                if (valueNode.isValueListNode()) {
                    ValueNodes.ValueListNode shouldContainAll = valueNode.asValueListNode();
                    for (ValueNode required : requiredValues) {
                        if (shouldContainAll.contains(required)) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class NotInEvaluator
    implements Evaluator {
        private NotInEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            return !((Evaluator)evaluators.get((Object)RelationalOperator.IN)).evaluate(left, right, ctx);
        }
    }

    private static class InEvaluator
    implements Evaluator {
        private InEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            ValueNodes.ValueListNode valueListNode;
            if (right.isJsonNode()) {
                ValueNode vn = right.asJsonNode().asValueListNode(ctx);
                if (vn.isUndefinedNode()) {
                    return false;
                }
                valueListNode = vn.asValueListNode();
            } else {
                valueListNode = right.asValueListNode();
            }
            return valueListNode.contains(left);
        }
    }

    private static class EmptyEvaluator
    implements Evaluator {
        private EmptyEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (left.isStringNode()) {
                return left.asStringNode().isEmpty() == right.asBooleanNode().getBoolean();
            }
            if (left.isJsonNode()) {
                return left.asJsonNode().isEmpty(ctx) == right.asBooleanNode().getBoolean();
            }
            return false;
        }
    }

    private static class SizeEvaluator
    implements Evaluator {
        private SizeEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (!right.isNumberNode()) {
                return false;
            }
            int expectedSize = right.asNumberNode().getNumber().intValue();
            if (left.isStringNode()) {
                return left.asStringNode().length() == expectedSize;
            }
            if (left.isJsonNode()) {
                return left.asJsonNode().length(ctx) == expectedSize;
            }
            return false;
        }
    }

    private static class GreaterThanEqualsEvaluator
    implements Evaluator {
        private GreaterThanEqualsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (left.isNumberNode() && right.isNumberNode()) {
                return left.asNumberNode().getNumber().compareTo(right.asNumberNode().getNumber()) >= 0;
            }
            if (left.isStringNode() && right.isStringNode()) {
                return left.asStringNode().getString().compareTo(right.asStringNode().getString()) >= 0;
            }
            if (left.isOffsetDateTimeNode() && right.isOffsetDateTimeNode()) {
                return left.asOffsetDateTimeNode().getDate().compareTo(right.asOffsetDateTimeNode().getDate()) >= 0;
            }
            return false;
        }
    }

    private static class GreaterThanEvaluator
    implements Evaluator {
        private GreaterThanEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (left.isNumberNode() && right.isNumberNode()) {
                return left.asNumberNode().getNumber().compareTo(right.asNumberNode().getNumber()) > 0;
            }
            if (left.isStringNode() && right.isStringNode()) {
                return left.asStringNode().getString().compareTo(right.asStringNode().getString()) > 0;
            }
            if (left.isOffsetDateTimeNode() && right.isOffsetDateTimeNode()) {
                return left.asOffsetDateTimeNode().getDate().compareTo(right.asOffsetDateTimeNode().getDate()) > 0;
            }
            return false;
        }
    }

    private static class LessThanEqualsEvaluator
    implements Evaluator {
        private LessThanEqualsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (left.isNumberNode() && right.isNumberNode()) {
                return left.asNumberNode().getNumber().compareTo(right.asNumberNode().getNumber()) <= 0;
            }
            if (left.isStringNode() && right.isStringNode()) {
                return left.asStringNode().getString().compareTo(right.asStringNode().getString()) <= 0;
            }
            if (left.isOffsetDateTimeNode() && right.isOffsetDateTimeNode()) {
                return left.asOffsetDateTimeNode().getDate().compareTo(right.asOffsetDateTimeNode().getDate()) <= 0;
            }
            return false;
        }
    }

    private static class LessThanEvaluator
    implements Evaluator {
        private LessThanEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (left.isNumberNode() && right.isNumberNode()) {
                return left.asNumberNode().getNumber().compareTo(right.asNumberNode().getNumber()) < 0;
            }
            if (left.isStringNode() && right.isStringNode()) {
                return left.asStringNode().getString().compareTo(right.asStringNode().getString()) < 0;
            }
            if (left.isOffsetDateTimeNode() && right.isOffsetDateTimeNode()) {
                return left.asOffsetDateTimeNode().getDate().compareTo(right.asOffsetDateTimeNode().getDate()) < 0;
            }
            return false;
        }
    }

    private static class TypeEvaluator
    implements Evaluator {
        private TypeEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            return right.asClassNode().getClazz() == left.type(ctx);
        }
    }

    private static class TypeSafeEqualsEvaluator
    implements Evaluator {
        private TypeSafeEqualsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (!left.getClass().equals(right.getClass())) {
                return false;
            }
            return ((Evaluator)evaluators.get((Object)RelationalOperator.EQ)).evaluate(left, right, ctx);
        }
    }

    private static class EqualsEvaluator
    implements Evaluator {
        private EqualsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (left.isJsonNode() && right.isJsonNode()) {
                return left.asJsonNode().equals(right.asJsonNode(), ctx);
            }
            return left.equals(right);
        }
    }

    private static class TypeSafeNotEqualsEvaluator
    implements Evaluator {
        private TypeSafeNotEqualsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            return !((Evaluator)evaluators.get((Object)RelationalOperator.TSEQ)).evaluate(left, right, ctx);
        }
    }

    private static class NotEqualsEvaluator
    implements Evaluator {
        private NotEqualsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            return !((Evaluator)evaluators.get((Object)RelationalOperator.EQ)).evaluate(left, right, ctx);
        }
    }

    private static class ExistsEvaluator
    implements Evaluator {
        private ExistsEvaluator() {
        }

        @Override
        public boolean evaluate(ValueNode left, ValueNode right, Predicate.PredicateContext ctx) {
            if (!left.isBooleanNode() && !right.isBooleanNode()) {
                throw new JsonPathException("Failed to evaluate exists expression");
            }
            return left.asBooleanNode().getBoolean() == right.asBooleanNode().getBoolean();
        }
    }
}

