/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.templateengines;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.camunda.templateengines.VelocityScriptEngineFactory;

public class VelocityScriptEngine
extends AbstractScriptEngine {
    protected ScriptEngineFactory scriptEngineFactory;
    protected VelocityEngine velocityEngine;

    public VelocityScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public VelocityScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader script, ScriptContext context) throws ScriptException {
        this.initVelocityEngine();
        String filename = this.getFilename(context);
        StringWriter writer = new StringWriter();
        Bindings bindings = context.getBindings(100);
        try {
            this.velocityEngine.evaluate((Context)new VelocityContext((Map)bindings), (Writer)writer, filename, script);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return ((Object)writer).toString();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        if (this.scriptEngineFactory == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.scriptEngineFactory == null) {
                    this.scriptEngineFactory = new VelocityScriptEngineFactory();
                }
            }
        }
        return this.scriptEngineFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVelocityEngine() {
        if (this.velocityEngine == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.velocityEngine == null) {
                    this.velocityEngine = new VelocityEngine();
                    this.velocityEngine.init();
                }
            }
        }
    }

    protected String getFilename(ScriptContext context) {
        String filename = (String)context.getAttribute("javax.script.filename");
        if (filename != null) {
            return filename;
        }
        return "unknown";
    }
}

