/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.StructSize;
import org.capnproto.WirePointer;

final class StructPointer {
    StructPointer() {
    }

    public static short dataSize(long l) {
        return (short)(WirePointer.upper32Bits(l) & 0xFFFF);
    }

    public static short ptrCount(long l) {
        return (short)(WirePointer.upper32Bits(l) >>> 16);
    }

    public static int wordSize(long l) {
        return StructPointer.dataSize(l) + StructPointer.ptrCount(l);
    }

    public static void setFromStructSize(ByteBuffer byteBuffer, int n, StructSize structSize) {
        byteBuffer.putShort(8 * n + 4, structSize.data);
        byteBuffer.putShort(8 * n + 6, structSize.pointers);
    }

    public static void set(ByteBuffer byteBuffer, int n, short s, short s2) {
        byteBuffer.putShort(8 * n + 4, s);
        byteBuffer.putShort(8 * n + 6, s2);
    }
}

