/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;

final class WirePointer {
    public static final byte STRUCT = 0;
    public static final byte LIST = 1;
    public static final byte FAR = 2;
    public static final byte OTHER = 3;

    WirePointer() {
    }

    public static boolean isNull(long l) {
        return l == 0L;
    }

    public static int offsetAndKind(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte kind(long l) {
        return (byte)(WirePointer.offsetAndKind(l) & 3);
    }

    public static int target(int n, long l) {
        return n + 1 + (WirePointer.offsetAndKind(l) >>> 2);
    }

    public static void setKindAndTarget(ByteBuffer byteBuffer, int n, byte by, int n2) {
        byteBuffer.putInt(n * 8, n2 - n - 1 << 2 | by);
    }

    public static void setKindWithZeroOffset(ByteBuffer byteBuffer, int n, byte by) {
        byteBuffer.putInt(n * 8, by);
    }

    public static void setKindAndTargetForEmptyStruct(ByteBuffer byteBuffer, int n) {
        byteBuffer.putInt(n * 8, -4);
    }

    public static void setOffsetAndKind(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.putInt(n * 8, n2);
    }

    public static int inlineCompositeListElementCount(long l) {
        return WirePointer.offsetAndKind(l) >>> 2;
    }

    public static void setKindAndInlineCompositeListElementCount(ByteBuffer byteBuffer, int n, byte by, int n2) {
        byteBuffer.putInt(n * 8, n2 << 2 | by);
    }

    public static int upper32Bits(long l) {
        return (int)(l >>> 32);
    }
}

