/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.Allocator;
import org.capnproto.BuilderArena;

public class DefaultAllocator
implements Allocator {
    private int nextSize = 1024;
    public ByteBufferAllocationStyle allocationStyle = ByteBufferAllocationStyle.REGULAR;
    public BuilderArena.AllocationStrategy allocationStrategy = BuilderArena.AllocationStrategy.GROW_HEURISTICALLY;
    public int maxSegmentBytes = 0x7FFFFFFD;

    public DefaultAllocator() {
    }

    public DefaultAllocator(BuilderArena.AllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public DefaultAllocator(ByteBufferAllocationStyle style) {
        this.allocationStyle = style;
    }

    public DefaultAllocator(BuilderArena.AllocationStrategy allocationStrategy, ByteBufferAllocationStyle style) {
        this.allocationStrategy = allocationStrategy;
        this.allocationStyle = style;
    }

    public void setNextAllocationSizeBytes(int nextSize) {
        this.nextSize = nextSize;
    }

    @Override
    public ByteBuffer allocateSegment(int minimumSize) {
        int size = Math.max(minimumSize, this.nextSize);
        ByteBuffer result = null;
        switch (this.allocationStyle) {
            case REGULAR: {
                result = ByteBuffer.allocate(size);
                break;
            }
            case DIRECT: {
                result = ByteBuffer.allocateDirect(size);
            }
        }
        switch (this.allocationStrategy) {
            case GROW_HEURISTICALLY: {
                if (size < this.maxSegmentBytes - this.nextSize) {
                    this.nextSize += size;
                    break;
                }
                this.nextSize = this.maxSegmentBytes;
                break;
            }
        }
        return result;
    }

    public static enum ByteBufferAllocationStyle {
        REGULAR,
        DIRECT;

    }
}

