/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import org.capnproto.FromPointerBuilder;
import org.capnproto.SegmentBuilder;
import org.capnproto.SetPointerBuilder;
import org.capnproto.StructBuilder;

public class ListBuilder {
    final SegmentBuilder segment;
    final int ptr;
    final int elementCount;
    final int step;
    final int structDataSize;
    final short structPointerCount;

    public ListBuilder(SegmentBuilder segment, int ptr, int elementCount, int step, int structDataSize, short structPointerCount) {
        this.segment = segment;
        this.ptr = ptr;
        this.elementCount = elementCount;
        this.step = step;
        this.structDataSize = structDataSize;
        this.structPointerCount = structPointerCount;
    }

    public int size() {
        return this.elementCount;
    }

    protected boolean _getBooleanElement(int index) {
        long bindex = (long)index * (long)this.step;
        byte b = this.segment.buffer.get(this.ptr + (int)(bindex / 8L));
        return (b & 1 << (int)(bindex % 8L)) != 0;
    }

    protected byte _getByteElement(int index) {
        return this.segment.buffer.get(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected short _getShortElement(int index) {
        return this.segment.buffer.getShort(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected int _getIntElement(int index) {
        return this.segment.buffer.getInt(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected long _getLongElement(int index) {
        return this.segment.buffer.getLong(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected float _getFloatElement(int index) {
        return this.segment.buffer.getFloat(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected double _getDoubleElement(int index) {
        return this.segment.buffer.getDouble(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected void _setBooleanElement(int index, boolean value) {
        long bitOffset = index * this.step;
        byte bitnum = (byte)(bitOffset % 8L);
        int position = (int)((long)this.ptr + bitOffset / 8L);
        byte oldValue = this.segment.buffer.get(position);
        this.segment.buffer.put(position, (byte)(oldValue & ~(1 << bitnum) | (value ? (byte)1 : 0) << bitnum));
    }

    protected void _setByteElement(int index, byte value) {
        this.segment.buffer.put(this.ptr + (int)((long)index * (long)this.step / 8L), value);
    }

    protected void _setShortElement(int index, short value) {
        this.segment.buffer.putShort(this.ptr + (int)((long)index * (long)this.step / 8L), value);
    }

    protected void _setIntElement(int index, int value) {
        this.segment.buffer.putInt(this.ptr + (int)((long)index * (long)this.step / 8L), value);
    }

    protected void _setLongElement(int index, long value) {
        this.segment.buffer.putLong(this.ptr + (int)((long)index * (long)this.step / 8L), value);
    }

    protected void _setFloatElement(int index, float value) {
        this.segment.buffer.putFloat(this.ptr + (int)((long)index * (long)this.step / 8L), value);
    }

    protected void _setDoubleElement(int index, double value) {
        this.segment.buffer.putDouble(this.ptr + (int)((long)index * (long)this.step / 8L), value);
    }

    protected final <T> T _getStructElement(StructBuilder.Factory<T> factory, int index) {
        long indexBit = (long)index * (long)this.step;
        int structData = this.ptr + (int)(indexBit / 8L);
        int structPointers = (structData + this.structDataSize / 8) / 8;
        return factory.constructBuilder(this.segment, structData, structPointers, this.structDataSize, this.structPointerCount);
    }

    protected final <T> T _getPointerElement(FromPointerBuilder<T> factory, int index) {
        return factory.fromPointerBuilder(this.segment, (this.ptr + (int)((long)index * (long)this.step / 8L)) / 8);
    }

    protected final <T> T _initPointerElement(FromPointerBuilder<T> factory, int index, int elementCount) {
        return factory.initFromPointerBuilder(this.segment, (this.ptr + (int)((long)index * (long)this.step / 8L)) / 8, elementCount);
    }

    protected final <Builder, Reader> void _setPointerElement(SetPointerBuilder<Builder, Reader> factory, int index, Reader value) {
        factory.setPointerBuilder(this.segment, (this.ptr + (int)((long)index * (long)this.step / 8L)) / 8, value);
    }

    public static interface Factory<T> {
        public T constructBuilder(SegmentBuilder var1, int var2, int var3, int var4, int var5, short var6);
    }
}

