/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.capnproto.BufferedOutputStream;

public final class PackedOutputStream
implements WritableByteChannel {
    final BufferedOutputStream inner;

    public PackedOutputStream(BufferedOutputStream output) {
        this.inner = output;
    }

    @Override
    public int write(ByteBuffer inBuf) throws IOException {
        int length = inBuf.remaining();
        ByteBuffer out = this.inner.getWriteBuffer();
        ByteBuffer slowBuffer = ByteBuffer.allocate(20);
        int inPtr = inBuf.position();
        int inEnd = inPtr + length;
        while (inPtr < inEnd) {
            ByteBuffer slice;
            int limit;
            int runStart;
            if (out.remaining() < 10) {
                if (out == slowBuffer) {
                    int oldLimit = out.limit();
                    out.limit(out.position());
                    out.rewind();
                    this.inner.write(out);
                    out.limit(oldLimit);
                }
                out = slowBuffer;
                out.rewind();
            }
            int tagPos = out.position();
            out.position(tagPos + 1);
            byte curByte = inBuf.get(inPtr);
            int bit0 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit0 - 1);
            curByte = inBuf.get(++inPtr);
            int bit1 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit1 - 1);
            curByte = inBuf.get(++inPtr);
            int bit2 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit2 - 1);
            curByte = inBuf.get(++inPtr);
            int bit3 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit3 - 1);
            curByte = inBuf.get(++inPtr);
            int bit4 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit4 - 1);
            curByte = inBuf.get(++inPtr);
            int bit5 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit5 - 1);
            curByte = inBuf.get(++inPtr);
            int bit6 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit6 - 1);
            curByte = inBuf.get(++inPtr);
            int bit7 = curByte != 0 ? 1 : 0;
            out.put(curByte);
            out.position(out.position() + bit7 - 1);
            ++inPtr;
            byte tag = (byte)(bit0 << 0 | bit1 << 1 | bit2 << 2 | bit3 << 3 | bit4 << 4 | bit5 << 5 | bit6 << 6 | bit7 << 7);
            out.put(tagPos, tag);
            if (tag == 0) {
                runStart = inPtr;
                limit = inEnd;
                if (limit - inPtr > 2040) {
                    limit = inPtr + 2040;
                }
                while (inPtr < limit && inBuf.getLong(inPtr) == 0L) {
                    inPtr += 8;
                }
                out.put((byte)((inPtr - runStart) / 8));
                continue;
            }
            if (tag != -1) continue;
            runStart = inPtr;
            limit = inEnd;
            if (limit - inPtr > 2040) {
                limit = inPtr + 2040;
            }
            while (inPtr < limit) {
                int c = 0;
                for (int ii = 0; ii < 8; ++ii) {
                    c = (byte)(c + (inBuf.get(inPtr) == 0 ? 1 : 0));
                    ++inPtr;
                }
                if (c < 2) continue;
                inPtr -= 8;
                break;
            }
            int count = inPtr - runStart;
            out.put((byte)(count / 8));
            if (count <= out.remaining()) {
                inBuf.position(runStart);
                slice = inBuf.slice();
                slice.limit(count);
                out.put(slice);
                continue;
            }
            if (out == slowBuffer) {
                int oldLimit = out.limit();
                out.limit(out.position());
                out.rewind();
                this.inner.write(out);
                out.limit(oldLimit);
            }
            inBuf.position(runStart);
            slice = inBuf.slice();
            slice.limit(count);
            while (slice.hasRemaining()) {
                this.inner.write(slice);
            }
            out = this.inner.getWriteBuffer();
        }
        if (out == slowBuffer) {
            out.limit(out.position());
            out.rewind();
            this.inner.write(out);
        }
        inBuf.position(inPtr);
        return length;
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    @Override
    public boolean isOpen() {
        return this.inner.isOpen();
    }
}

