/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.Arena;

public class SegmentReader {
    public final ByteBuffer buffer;
    final Arena arena;
    public static final SegmentReader EMPTY = new SegmentReader(ByteBuffer.allocate(8), null);

    public SegmentReader(ByteBuffer buffer, Arena arena) {
        this.buffer = buffer;
        this.arena = arena;
    }

    public final long get(int index) {
        return this.buffer.getLong(index * 8);
    }

    public final boolean in_bounds(int start, int size) {
        if (start < 0 || size < 0) {
            return false;
        }
        long sizeInWords = size * 8;
        return (long)start + sizeInWords < (long)this.buffer.capacity();
    }
}

