/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.capnproto.DecodeException;
import org.capnproto.MessageBuilder;
import org.capnproto.MessageReader;
import org.capnproto.ReaderOptions;

public final class Serialize {
    static int MAX_SEGMENT_WORDS = 0xFFFFFFF;

    static ByteBuffer makeByteBuffer(int bytes) {
        ByteBuffer result = ByteBuffer.allocate(bytes);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.mark();
        return result;
    }

    static ByteBuffer makeByteBufferForWords(int words) throws IOException {
        if (words > MAX_SEGMENT_WORDS) {
            throw new DecodeException("segment has too many words (" + words + ")");
        }
        return Serialize.makeByteBuffer(words * 8);
    }

    public static void fillBuffer(ByteBuffer buffer, ReadableByteChannel bc) throws IOException {
        while (buffer.hasRemaining()) {
            int r = bc.read(buffer);
            if (r < 0) {
                throw new IOException("premature EOF");
            }
            if (r != 0) continue;
            throw new IOException("Read zero bytes. Is the channel in non-blocking mode?");
        }
    }

    public static MessageReader read(ReadableByteChannel bc) throws IOException {
        return Serialize.read(bc, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ReadableByteChannel bc, ReaderOptions options) throws IOException {
        ByteBuffer firstWord = Serialize.makeByteBufferForWords(1);
        Serialize.fillBuffer(firstWord, bc);
        int rawSegmentCount = firstWord.getInt(0);
        if (rawSegmentCount < 0 || rawSegmentCount > 511) {
            throw new DecodeException("segment count must be between 0 and 512");
        }
        int segmentCount = 1 + rawSegmentCount;
        int segment0Size = 0;
        if (segmentCount > 0) {
            segment0Size = firstWord.getInt(4);
        }
        if (segment0Size < 0) {
            throw new DecodeException("segment 0 has more than 2^31 words, which is unsupported");
        }
        long totalWords = segment0Size;
        ArrayList<Integer> moreSizes = new ArrayList<Integer>();
        if (segmentCount > 1) {
            ByteBuffer moreSizesRaw = Serialize.makeByteBuffer(4 * (segmentCount & 0xFFFFFFFE));
            Serialize.fillBuffer(moreSizesRaw, bc);
            for (int ii = 0; ii < segmentCount - 1; ++ii) {
                int size = moreSizesRaw.getInt(ii * 4);
                if (size < 0) {
                    throw new DecodeException("segment " + (ii + 1) + " has more than 2^31 words, which is unsupported");
                }
                moreSizes.add(size);
                totalWords += (long)size;
            }
        }
        if (totalWords > options.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        ByteBuffer[] segmentSlices = new ByteBuffer[segmentCount];
        segmentSlices[0] = Serialize.makeByteBufferForWords(segment0Size);
        Serialize.fillBuffer(segmentSlices[0], bc);
        segmentSlices[0].rewind();
        int offset = segment0Size;
        for (int ii = 1; ii < segmentCount; ++ii) {
            segmentSlices[ii] = Serialize.makeByteBufferForWords((Integer)moreSizes.get(ii - 1));
            Serialize.fillBuffer(segmentSlices[ii], bc);
            segmentSlices[ii].rewind();
        }
        return new MessageReader(segmentSlices, options);
    }

    public static MessageReader read(ByteBuffer bb) throws IOException {
        return Serialize.read(bb, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ByteBuffer bb, ReaderOptions options) throws IOException {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int rawSegmentCount = bb.getInt();
        int segmentCount = 1 + rawSegmentCount;
        if (rawSegmentCount < 0 || rawSegmentCount > 511) {
            throw new DecodeException("segment count must be between 0 and 512");
        }
        ByteBuffer[] segmentSlices = new ByteBuffer[segmentCount];
        int segmentSizesBase = bb.position();
        int segmentSizesSize = segmentCount * 4;
        int align = 7;
        int segmentBase = segmentSizesBase + segmentSizesSize + align & ~align;
        int totalWords = 0;
        for (int ii = 0; ii < segmentCount; ++ii) {
            int segmentSize = bb.getInt(segmentSizesBase + ii * 4);
            if (segmentSize > MAX_SEGMENT_WORDS - (totalWords + segmentBase / 8)) {
                throw new DecodeException("segment size is too large");
            }
            bb.position(segmentBase + totalWords * 8);
            segmentSlices[ii] = bb.slice();
            segmentSlices[ii].limit(segmentSize * 8);
            segmentSlices[ii].order(ByteOrder.LITTLE_ENDIAN);
            totalWords += segmentSize;
        }
        bb.position(segmentBase + totalWords * 8);
        if (options.traversalLimitInWords != -1L && (long)totalWords > options.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        return new MessageReader(segmentSlices, options);
    }

    public static long computeSerializedSizeInWords(MessageBuilder message) {
        ByteBuffer[] segments = message.getSegmentsForOutput();
        long bytes = 0L;
        bytes += 4L;
        if ((bytes += (long)(segments.length * 4)) % 8L != 0L) {
            bytes += 4L;
        }
        for (int i = 0; i < segments.length; ++i) {
            ByteBuffer s = segments[i];
            bytes += (long)s.limit();
        }
        return bytes / 8L;
    }

    private static void writeSegmentTable(WritableByteChannel outputChannel, ByteBuffer[] segments) throws IOException {
        int tableSize = segments.length + 2 & 0xFFFFFFFE;
        ByteBuffer table = ByteBuffer.allocate(4 * tableSize);
        table.order(ByteOrder.LITTLE_ENDIAN);
        table.putInt(0, segments.length - 1);
        for (int i = 0; i < segments.length; ++i) {
            table.putInt(4 * (i + 1), segments[i].limit() / 8);
        }
        while (table.hasRemaining()) {
            outputChannel.write(table);
        }
    }

    public static void write(WritableByteChannel outputChannel, MessageBuilder message) throws IOException {
        ByteBuffer[] segments = message.getSegmentsForOutput();
        Serialize.writeSegmentTable(outputChannel, segments);
        for (ByteBuffer buffer : segments) {
            while (buffer.hasRemaining()) {
                outputChannel.write(buffer);
            }
        }
    }

    public static void write(WritableByteChannel outputChannel, MessageReader message) throws IOException {
        ByteBuffer[] segments = new ByteBuffer[message.arena.segments.size()];
        for (int ii = 0; ii < message.arena.segments.size(); ++ii) {
            segments[ii] = message.arena.segments.get((int)ii).buffer.duplicate();
        }
        Serialize.writeSegmentTable(outputChannel, segments);
        for (ByteBuffer buffer : segments) {
            while (buffer.hasRemaining()) {
                outputChannel.write(buffer);
            }
        }
    }
}

