/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.BuilderArena;
import org.capnproto.Data;
import org.capnproto.DecodeException;
import org.capnproto.ElementSize;
import org.capnproto.FarPointer;
import org.capnproto.ListBuilder;
import org.capnproto.ListPointer;
import org.capnproto.ListReader;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.StructBuilder;
import org.capnproto.StructPointer;
import org.capnproto.StructReader;
import org.capnproto.StructSize;
import org.capnproto.Text;
import org.capnproto.WirePointer;

final class WireHelpers {
    WireHelpers() {
    }

    static int roundBytesUpToWords(int bytes) {
        return (bytes + 7) / 8;
    }

    static int roundBitsUpToBytes(int bits) {
        return (bits + 7) / 8;
    }

    static int roundBitsUpToWords(long bits) {
        return (int)((bits + 63L) / 64L);
    }

    static boolean bounds_check(SegmentReader segment, int start, int size) {
        return segment == null || segment.in_bounds(start, size);
    }

    static AllocateResult allocate(int refOffset, SegmentBuilder segment, int amount, byte kind) {
        long ref = segment.get(refOffset);
        if (!WirePointer.isNull(ref)) {
            WireHelpers.zeroObject(segment, refOffset);
        }
        if (amount == 0 && kind == 0) {
            WirePointer.setKindAndTargetForEmptyStruct(segment.buffer, refOffset);
            return new AllocateResult(refOffset, refOffset, segment);
        }
        int ptr = segment.allocate(amount);
        if (ptr == -1) {
            int amountPlusRef = amount + 1;
            BuilderArena.AllocateResult allocation = segment.getArena().allocate(amountPlusRef);
            FarPointer.set(segment.buffer, refOffset, false, allocation.offset);
            FarPointer.setSegmentId(segment.buffer, refOffset, allocation.segment.id);
            int resultRefOffset = allocation.offset;
            int ptr1 = allocation.offset + 1;
            WirePointer.setKindAndTarget(allocation.segment.buffer, resultRefOffset, kind, ptr1);
            return new AllocateResult(ptr1, resultRefOffset, allocation.segment);
        }
        WirePointer.setKindAndTarget(segment.buffer, refOffset, kind, ptr);
        return new AllocateResult(ptr, refOffset, segment);
    }

    static FollowBuilderFarsResult followBuilderFars(long ref, int refTarget, SegmentBuilder segment) {
        if (WirePointer.kind(ref) == 2) {
            SegmentBuilder resultSegment = segment.getArena().getSegment(FarPointer.getSegmentId(ref));
            int padOffset = FarPointer.positionInSegment(ref);
            long pad = resultSegment.get(padOffset);
            if (!FarPointer.isDoubleFar(ref)) {
                return new FollowBuilderFarsResult(WirePointer.target(padOffset, pad), pad, resultSegment);
            }
            int refOffset = padOffset + 1;
            ref = resultSegment.get(refOffset);
            resultSegment = resultSegment.getArena().getSegment(FarPointer.getSegmentId(pad));
            return new FollowBuilderFarsResult(FarPointer.positionInSegment(pad), ref, resultSegment);
        }
        return new FollowBuilderFarsResult(refTarget, ref, segment);
    }

    static FollowFarsResult followFars(long ref, int refTarget, SegmentReader segment) {
        if (segment != null && WirePointer.kind(ref) == 2) {
            int padWords;
            SegmentReader resultSegment = segment.arena.tryGetSegment(FarPointer.getSegmentId(ref));
            int padOffset = FarPointer.positionInSegment(ref);
            long pad = resultSegment.get(padOffset);
            int n = padWords = FarPointer.isDoubleFar(ref) ? 2 : 1;
            if (!FarPointer.isDoubleFar(ref)) {
                return new FollowFarsResult(WirePointer.target(padOffset, pad), pad, resultSegment);
            }
            long tag = resultSegment.get(padOffset + 1);
            resultSegment = resultSegment.arena.tryGetSegment(FarPointer.getSegmentId(pad));
            return new FollowFarsResult(FarPointer.positionInSegment(pad), tag, resultSegment);
        }
        return new FollowFarsResult(refTarget, ref, segment);
    }

    static void zeroObject(SegmentBuilder segment, int refOffset) {
        if (!segment.isWritable()) {
            return;
        }
        long ref = segment.get(refOffset);
        switch (WirePointer.kind(ref)) {
            case 0: 
            case 1: {
                WireHelpers.zeroObject(segment, ref, WirePointer.target(refOffset, ref));
                break;
            }
            case 2: {
                segment = segment.getArena().getSegment(FarPointer.getSegmentId(ref));
                if (!segment.isWritable()) break;
                int padOffset = FarPointer.positionInSegment(ref);
                long pad = segment.get(padOffset);
                if (FarPointer.isDoubleFar(ref)) {
                    SegmentBuilder otherSegment = segment.getArena().getSegment(FarPointer.getSegmentId(ref));
                    if (otherSegment.isWritable()) {
                        WireHelpers.zeroObject(otherSegment, padOffset + 1, FarPointer.positionInSegment(pad));
                    }
                    segment.buffer.putLong(padOffset * 8, 0L);
                    segment.buffer.putLong((padOffset + 1) * 8, 0L);
                    break;
                }
                WireHelpers.zeroObject(segment, padOffset);
                segment.buffer.putLong(padOffset * 8, 0L);
                break;
            }
        }
    }

    static void zeroObject(SegmentBuilder segment, long tag, int ptr) {
        if (!segment.isWritable()) {
            return;
        }
        block0 : switch (WirePointer.kind(tag)) {
            case 0: {
                int pointerSection = ptr + StructPointer.dataSize(tag);
                int count = StructPointer.ptrCount(tag);
                for (int ii = 0; ii < count; ++ii) {
                    WireHelpers.zeroObject(segment, pointerSection + ii);
                }
                WireHelpers.memset(segment.buffer, ptr * 8, (byte)0, StructPointer.wordSize(tag) * 8);
                break;
            }
            case 1: {
                switch (ListPointer.elementSize(tag)) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        WireHelpers.memset(segment.buffer, ptr * 8, (byte)0, WireHelpers.roundBitsUpToWords(ListPointer.elementCount(tag) * ElementSize.dataBitsPerElement(ListPointer.elementSize(tag))) * 8);
                        break block0;
                    }
                    case 6: {
                        int count = ListPointer.elementCount(tag);
                        for (int ii = 0; ii < count; ++ii) {
                            WireHelpers.zeroObject(segment, ptr + ii);
                        }
                        WireHelpers.memset(segment.buffer, ptr * 8, (byte)0, count * 8);
                        break block0;
                    }
                    case 7: {
                        long elementTag = segment.get(ptr);
                        if (WirePointer.kind(elementTag) != 0) {
                            throw new RuntimeException("Don't know how to handle non-STRUCT inline composite.");
                        }
                        int dataSize = StructPointer.dataSize(elementTag);
                        int pointerCount = StructPointer.ptrCount(elementTag);
                        int pos = ptr + 1;
                        int count = WirePointer.inlineCompositeListElementCount(elementTag);
                        for (int ii = 0; ii < count; ++ii) {
                            pos += dataSize;
                            for (int jj = 0; jj < pointerCount; ++jj) {
                                WireHelpers.zeroObject(segment, pos);
                                ++pos;
                            }
                        }
                        WireHelpers.memset(segment.buffer, ptr * 8, (byte)0, (StructPointer.wordSize(elementTag) * count + 1) * 8);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Unexpected FAR pointer.");
            }
            case 3: {
                throw new IllegalArgumentException("Unexpected OTHER pointer.");
            }
        }
    }

    static void zeroPointerAndFars(SegmentBuilder segment, int refOffset) {
        SegmentBuilder padSegment;
        long ref = segment.get(refOffset);
        if (WirePointer.kind(ref) == 2 && (padSegment = segment.getArena().getSegment(FarPointer.getSegmentId(ref))).isWritable()) {
            int padOffset = FarPointer.positionInSegment(ref);
            padSegment.buffer.putLong(padOffset * 8, 0L);
            if (FarPointer.isDoubleFar(ref)) {
                padSegment.buffer.putLong(padOffset * 8 + 1, 0L);
            }
        }
        segment.put(refOffset, 0L);
    }

    static void transferPointer(SegmentBuilder dstSegment, int dstOffset, SegmentBuilder srcSegment, int srcOffset) {
        long src = srcSegment.get(srcOffset);
        if (WirePointer.isNull(src)) {
            dstSegment.put(dstOffset, 0L);
        } else if (WirePointer.kind(src) == 2) {
            dstSegment.put(dstOffset, srcSegment.get(srcOffset));
        } else {
            WireHelpers.transferPointer(dstSegment, dstOffset, srcSegment, srcOffset, WirePointer.target(srcOffset, src));
        }
    }

    static void transferPointer(SegmentBuilder dstSegment, int dstOffset, SegmentBuilder srcSegment, int srcOffset, int srcTargetOffset) {
        long src = srcSegment.get(srcOffset);
        long srcTarget = srcSegment.get(srcTargetOffset);
        if (dstSegment == srcSegment) {
            if (WirePointer.kind(src) == 0 && StructPointer.wordSize(src) == 0) {
                WirePointer.setKindAndTargetForEmptyStruct(dstSegment.buffer, dstOffset);
            } else {
                WirePointer.setKindAndTarget(dstSegment.buffer, dstOffset, WirePointer.kind(src), srcTargetOffset);
            }
            dstSegment.buffer.putInt(dstOffset * 8 + 4, srcSegment.buffer.getInt(srcOffset * 8 + 4));
        } else {
            int landingPadOffset = srcSegment.allocate(1);
            if (landingPadOffset == -1) {
                BuilderArena.AllocateResult allocation = srcSegment.getArena().allocate(2);
                SegmentBuilder farSegment = allocation.segment;
                landingPadOffset = allocation.offset;
                FarPointer.set(farSegment.buffer, landingPadOffset, false, srcTargetOffset);
                FarPointer.setSegmentId(farSegment.buffer, landingPadOffset, srcSegment.id);
                WirePointer.setKindWithZeroOffset(farSegment.buffer, landingPadOffset + 1, WirePointer.kind(src));
                farSegment.buffer.putInt((landingPadOffset + 1) * 8 + 4, srcSegment.buffer.getInt(srcOffset * 8 + 4));
                FarPointer.set(dstSegment.buffer, dstOffset, true, landingPadOffset);
                FarPointer.setSegmentId(dstSegment.buffer, dstOffset, farSegment.id);
            } else {
                WirePointer.setKindAndTarget(srcSegment.buffer, landingPadOffset, WirePointer.kind(srcTarget), srcTargetOffset);
                srcSegment.buffer.putInt(landingPadOffset * 8 + 4, srcSegment.buffer.getInt(srcOffset * 8 + 4));
                FarPointer.set(dstSegment.buffer, dstOffset, false, landingPadOffset);
                FarPointer.setSegmentId(dstSegment.buffer, dstOffset, srcSegment.id);
            }
        }
    }

    static <T> T initStructPointer(StructBuilder.Factory<T> factory, int refOffset, SegmentBuilder segment, StructSize size) {
        AllocateResult allocation = WireHelpers.allocate(refOffset, segment, size.total(), (byte)0);
        StructPointer.setFromStructSize(allocation.segment.buffer, allocation.refOffset, size);
        return factory.constructBuilder(allocation.segment, allocation.ptr * 8, allocation.ptr + size.data, size.data * 64, size.pointers);
    }

    static <T> T getWritableStructPointer(StructBuilder.Factory<T> factory, int refOffset, SegmentBuilder segment, StructSize size, SegmentReader defaultSegment, int defaultOffset) {
        long ref = segment.get(refOffset);
        int target = WirePointer.target(refOffset, ref);
        if (WirePointer.isNull(ref)) {
            if (defaultSegment == null) {
                return WireHelpers.initStructPointer(factory, refOffset, segment, size);
            }
            throw new RuntimeException("unimplemented");
        }
        FollowBuilderFarsResult resolved = WireHelpers.followBuilderFars(ref, target, segment);
        int oldDataSize = StructPointer.dataSize(resolved.ref);
        int oldPointerCount = StructPointer.ptrCount(resolved.ref);
        int oldPointerSection = resolved.ptr + oldDataSize;
        if (oldDataSize < size.data || oldPointerCount < size.pointers) {
            short newDataSize = (short)Math.max(oldDataSize, size.data);
            short newPointerCount = (short)Math.max(oldPointerCount, size.pointers);
            int totalSize = newDataSize + newPointerCount * 1;
            WireHelpers.zeroPointerAndFars(segment, refOffset);
            AllocateResult allocation = WireHelpers.allocate(refOffset, segment, totalSize, (byte)0);
            StructPointer.set(allocation.segment.buffer, allocation.refOffset, newDataSize, newPointerCount);
            WireHelpers.memcpy(allocation.segment.buffer, allocation.ptr * 8, resolved.segment.buffer, resolved.ptr * 8, oldDataSize * 8);
            int newPointerSection = allocation.ptr + newDataSize;
            for (int ii = 0; ii < oldPointerCount; ++ii) {
                WireHelpers.transferPointer(allocation.segment, newPointerSection + ii, resolved.segment, oldPointerSection + ii);
            }
            WireHelpers.memset(resolved.segment.buffer, resolved.ptr * 8, (byte)0, (oldDataSize + oldPointerCount * 1) * 8);
            return factory.constructBuilder(allocation.segment, allocation.ptr * 8, newPointerSection, newDataSize * 64, newPointerCount);
        }
        return factory.constructBuilder(resolved.segment, resolved.ptr * 8, oldPointerSection, oldDataSize * 64, (short)oldPointerCount);
    }

    static <T> T initListPointer(ListBuilder.Factory<T> factory, int refOffset, SegmentBuilder segment, int elementCount, byte elementSize) {
        assert (elementSize != 7) : "Should have called initStructListPointer instead";
        int dataSize = ElementSize.dataBitsPerElement(elementSize);
        short pointerCount = ElementSize.pointersPerElement(elementSize);
        int step = dataSize + pointerCount * 64;
        int wordCount = WireHelpers.roundBitsUpToWords((long)elementCount * (long)step);
        AllocateResult allocation = WireHelpers.allocate(refOffset, segment, wordCount, (byte)1);
        ListPointer.set(allocation.segment.buffer, allocation.refOffset, elementSize, elementCount);
        return factory.constructBuilder(allocation.segment, allocation.ptr * 8, elementCount, step, dataSize, pointerCount);
    }

    static <T> T initStructListPointer(ListBuilder.Factory<T> factory, int refOffset, SegmentBuilder segment, int elementCount, StructSize elementSize) {
        int wordsPerElement = elementSize.total();
        int wordCount = elementCount * wordsPerElement;
        AllocateResult allocation = WireHelpers.allocate(refOffset, segment, 1 + wordCount, (byte)1);
        ListPointer.setInlineComposite(allocation.segment.buffer, allocation.refOffset, wordCount);
        WirePointer.setKindAndInlineCompositeListElementCount(allocation.segment.buffer, allocation.ptr, (byte)0, elementCount);
        StructPointer.setFromStructSize(allocation.segment.buffer, allocation.ptr, elementSize);
        return factory.constructBuilder(allocation.segment, (allocation.ptr + 1) * 8, elementCount, wordsPerElement * 64, elementSize.data * 64, elementSize.pointers);
    }

    static <T> T getWritableListPointer(ListBuilder.Factory<T> factory, int origRefOffset, SegmentBuilder origSegment, byte elementSize, SegmentReader defaultSegment, int defaultOffset) {
        assert (elementSize != 7) : "Use getWritableStructListPointer() for struct lists";
        long origRef = origSegment.get(origRefOffset);
        int origRefTarget = WirePointer.target(origRefOffset, origRef);
        if (WirePointer.isNull(origRef)) {
            throw new RuntimeException("unimplemented");
        }
        FollowBuilderFarsResult resolved = WireHelpers.followBuilderFars(origRef, origRefTarget, origSegment);
        if (WirePointer.kind(resolved.ref) != 1) {
            throw new DecodeException("Called getList{Field,Element}() but existing pointer is not a list");
        }
        byte oldSize = ListPointer.elementSize(resolved.ref);
        if (oldSize == 7) {
            throw new RuntimeException("unimplemented");
        }
        int dataSize = ElementSize.dataBitsPerElement(oldSize);
        short pointerCount = ElementSize.pointersPerElement(oldSize);
        if (dataSize < ElementSize.dataBitsPerElement(elementSize)) {
            throw new DecodeException("Existing list value is incompatible with expected type.");
        }
        if (pointerCount < ElementSize.pointersPerElement(elementSize)) {
            throw new DecodeException("Existing list value is incompatible with expected type.");
        }
        int step = dataSize + pointerCount * 64;
        return factory.constructBuilder(resolved.segment, resolved.ptr * 8, ListPointer.elementCount(resolved.ref), step, dataSize, pointerCount);
    }

    static <T> T getWritableStructListPointer(ListBuilder.Factory<T> factory, int origRefOffset, SegmentBuilder origSegment, StructSize elementSize, SegmentReader defaultSegment, int defaultOffset) {
        long origRef = origSegment.get(origRefOffset);
        int origRefTarget = WirePointer.target(origRefOffset, origRef);
        if (WirePointer.isNull(origRef)) {
            throw new RuntimeException("unimplemented");
        }
        FollowBuilderFarsResult resolved = WireHelpers.followBuilderFars(origRef, origRefTarget, origSegment);
        if (WirePointer.kind(resolved.ref) != 1) {
            throw new DecodeException("Called getList{Field,Element}() but existing pointer is not a list");
        }
        byte oldSize = ListPointer.elementSize(resolved.ref);
        if (oldSize == 7) {
            long oldTag = resolved.segment.get(resolved.ptr);
            int oldPtr = resolved.ptr + 1;
            if (WirePointer.kind(oldTag) != 0) {
                throw new DecodeException("INLINE_COMPOSITE list with non-STRUCT elements not supported.");
            }
            int oldDataSize = StructPointer.dataSize(oldTag);
            int oldPointerCount = StructPointer.ptrCount(oldTag);
            int oldStep = oldDataSize + oldPointerCount * 1;
            int elementCount = WirePointer.inlineCompositeListElementCount(oldTag);
            if (oldDataSize >= elementSize.data && oldPointerCount >= elementSize.pointers) {
                return factory.constructBuilder(resolved.segment, oldPtr * 8, elementCount, oldStep * 64, oldDataSize * 64, (short)oldPointerCount);
            }
            short newDataSize = (short)Math.max(oldDataSize, elementSize.data);
            short newPointerCount = (short)Math.max(oldPointerCount, elementSize.pointers);
            int newStep = newDataSize + newPointerCount * 1;
            int totalSize = newStep * elementCount;
            WireHelpers.zeroPointerAndFars(origSegment, origRefOffset);
            AllocateResult allocation = WireHelpers.allocate(origRefOffset, origSegment, totalSize + 1, (byte)1);
            ListPointer.setInlineComposite(allocation.segment.buffer, allocation.refOffset, totalSize);
            long tag = allocation.segment.get(allocation.ptr);
            WirePointer.setKindAndInlineCompositeListElementCount(allocation.segment.buffer, allocation.ptr, (byte)0, elementCount);
            StructPointer.set(allocation.segment.buffer, allocation.ptr, newDataSize, newPointerCount);
            int newPtr = allocation.ptr + 1;
            int src = oldPtr;
            int dst = newPtr;
            for (int ii = 0; ii < elementCount; ++ii) {
                WireHelpers.memcpy(allocation.segment.buffer, dst * 8, resolved.segment.buffer, src * 8, oldDataSize * 8);
                int newPointerSection = dst + newDataSize;
                int oldPointerSection = src + oldDataSize;
                for (int jj = 0; jj < oldPointerCount; ++jj) {
                    WireHelpers.transferPointer(allocation.segment, newPointerSection + jj, resolved.segment, oldPointerSection + jj);
                }
                dst += newStep;
                src += oldStep;
            }
            WireHelpers.memset(resolved.segment.buffer, resolved.ptr * 8, (byte)0, (1 + oldStep * elementCount) * 8);
            return factory.constructBuilder(allocation.segment, newPtr * 8, elementCount, newStep * 64, newDataSize * 64, newPointerCount);
        }
        int oldDataSize = ElementSize.dataBitsPerElement(oldSize);
        short oldPointerCount = ElementSize.pointersPerElement(oldSize);
        int oldStep = oldDataSize + oldPointerCount * 64;
        int elementCount = ListPointer.elementCount(origRef);
        if (oldSize == 0) {
            return WireHelpers.initStructListPointer(factory, origRefOffset, origSegment, elementCount, elementSize);
        }
        if (oldSize == 1) {
            throw new RuntimeException("Found bit list where struct list was expected; upgrading boolean lists to struct is no longer supported.");
        }
        short newDataSize = elementSize.data;
        short newPointerCount = elementSize.pointers;
        if (oldSize == 6) {
            newPointerCount = (short)Math.max(newPointerCount, 1);
        } else {
            newDataSize = (short)Math.max(newDataSize, 1);
        }
        int newStep = newDataSize + newPointerCount * 1;
        int totalWords = elementCount * newStep;
        WireHelpers.zeroPointerAndFars(origSegment, origRefOffset);
        AllocateResult allocation = WireHelpers.allocate(origRefOffset, origSegment, totalWords + 1, (byte)1);
        ListPointer.setInlineComposite(allocation.segment.buffer, allocation.refOffset, totalWords);
        long tag = allocation.segment.get(allocation.ptr);
        WirePointer.setKindAndInlineCompositeListElementCount(allocation.segment.buffer, allocation.ptr, (byte)0, elementCount);
        StructPointer.set(allocation.segment.buffer, allocation.ptr, newDataSize, newPointerCount);
        int newPtr = allocation.ptr + 1;
        if (oldSize == 6) {
            int dst = newPtr + newDataSize;
            int src = resolved.ptr;
            for (int ii = 0; ii < elementCount; ++ii) {
                WireHelpers.transferPointer(origSegment, dst, resolved.segment, src);
                dst += newStep / 1;
                ++src;
            }
        } else {
            int dst = newPtr;
            int srcByteOffset = resolved.ptr * 8;
            int oldByteStep = oldDataSize / 8;
            for (int ii = 0; ii < elementCount; ++ii) {
                WireHelpers.memcpy(allocation.segment.buffer, dst * 8, resolved.segment.buffer, srcByteOffset, oldByteStep);
                srcByteOffset += oldByteStep;
                dst += newStep;
            }
        }
        WireHelpers.memset(resolved.segment.buffer, resolved.ptr * 8, (byte)0, WireHelpers.roundBitsUpToBytes(oldStep * elementCount));
        return factory.constructBuilder(allocation.segment, newPtr * 8, elementCount, newStep * 64, newDataSize * 64, newPointerCount);
    }

    static Text.Builder initTextPointer(int refOffset, SegmentBuilder segment, int size) {
        int byteSize = size + 1;
        AllocateResult allocation = WireHelpers.allocate(refOffset, segment, WireHelpers.roundBytesUpToWords(byteSize), (byte)1);
        ListPointer.set(allocation.segment.buffer, allocation.refOffset, (byte)2, byteSize);
        return new Text.Builder(allocation.segment.buffer, allocation.ptr * 8, size);
    }

    static Text.Builder setTextPointer(int refOffset, SegmentBuilder segment, Text.Reader value) {
        Text.Builder builder = WireHelpers.initTextPointer(refOffset, segment, value.size);
        ByteBuffer slice = value.buffer.duplicate();
        slice.position(value.offset);
        slice.limit(value.offset + value.size);
        builder.buffer.position(builder.offset);
        builder.buffer.put(slice);
        return builder;
    }

    static Text.Builder getWritableTextPointer(int refOffset, SegmentBuilder segment, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
        long ref = segment.get(refOffset);
        if (WirePointer.isNull(ref)) {
            if (defaultBuffer == null) {
                return new Text.Builder();
            }
            Text.Builder builder = WireHelpers.initTextPointer(refOffset, segment, defaultSize);
            for (int i = 0; i < builder.size; ++i) {
                builder.buffer.put(builder.offset + i, defaultBuffer.get(defaultOffset * 8 + i));
            }
            return builder;
        }
        int refTarget = WirePointer.target(refOffset, ref);
        FollowBuilderFarsResult resolved = WireHelpers.followBuilderFars(ref, refTarget, segment);
        if (WirePointer.kind(resolved.ref) != 1) {
            throw new DecodeException("Called getText{Field,Element} but existing pointer is not a list.");
        }
        if (ListPointer.elementSize(resolved.ref) != 2) {
            throw new DecodeException("Called getText{Field,Element} but existing list pointer is not byte-sized.");
        }
        int size = ListPointer.elementCount(resolved.ref);
        if (size == 0 || resolved.segment.buffer.get(resolved.ptr * 8 + size - 1) != 0) {
            throw new DecodeException("Text blob missing NUL terminator.");
        }
        return new Text.Builder(resolved.segment.buffer, resolved.ptr * 8, size - 1);
    }

    static Data.Builder initDataPointer(int refOffset, SegmentBuilder segment, int size) {
        AllocateResult allocation = WireHelpers.allocate(refOffset, segment, WireHelpers.roundBytesUpToWords(size), (byte)1);
        ListPointer.set(allocation.segment.buffer, allocation.refOffset, (byte)2, size);
        return new Data.Builder(allocation.segment.buffer, allocation.ptr * 8, size);
    }

    static Data.Builder setDataPointer(int refOffset, SegmentBuilder segment, Data.Reader value) {
        Data.Builder builder = WireHelpers.initDataPointer(refOffset, segment, value.size);
        for (int i = 0; i < builder.size; ++i) {
            builder.buffer.put(builder.offset + i, value.buffer.get(value.offset + i));
        }
        return builder;
    }

    static Data.Builder getWritableDataPointer(int refOffset, SegmentBuilder segment, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
        long ref = segment.get(refOffset);
        if (WirePointer.isNull(ref)) {
            if (defaultBuffer == null) {
                return new Data.Builder();
            }
            Data.Builder builder = WireHelpers.initDataPointer(refOffset, segment, defaultSize);
            for (int i = 0; i < builder.size; ++i) {
                builder.buffer.put(builder.offset + i, defaultBuffer.get(defaultOffset * 8 + i));
            }
            return builder;
        }
        int refTarget = WirePointer.target(refOffset, ref);
        FollowBuilderFarsResult resolved = WireHelpers.followBuilderFars(ref, refTarget, segment);
        if (WirePointer.kind(resolved.ref) != 1) {
            throw new DecodeException("Called getData{Field,Element} but existing pointer is not a list.");
        }
        if (ListPointer.elementSize(resolved.ref) != 2) {
            throw new DecodeException("Called getData{Field,Element} but existing list pointer is not byte-sized.");
        }
        return new Data.Builder(resolved.segment.buffer, resolved.ptr * 8, ListPointer.elementCount(resolved.ref));
    }

    static <T> T readStructPointer(StructReader.Factory<T> factory, SegmentReader segment, int refOffset, SegmentReader defaultSegment, int defaultOffset, int nestingLimit) {
        long ref = segment.get(refOffset);
        if (WirePointer.isNull(ref)) {
            if (defaultSegment == null) {
                return factory.constructReader(SegmentReader.EMPTY, 0, 0, 0, (short)0, Integer.MAX_VALUE);
            }
            segment = defaultSegment;
            refOffset = defaultOffset;
            ref = segment.get(refOffset);
        }
        if (nestingLimit <= 0) {
            throw new DecodeException("Message is too deeply nested or contains cycles.");
        }
        int refTarget = WirePointer.target(refOffset, ref);
        FollowFarsResult resolved = WireHelpers.followFars(ref, refTarget, segment);
        int dataSizeWords = StructPointer.dataSize(resolved.ref);
        if (WirePointer.kind(resolved.ref) != 0) {
            throw new DecodeException("Message contains non-struct pointer where struct pointer was expected.");
        }
        resolved.segment.arena.checkReadLimit(StructPointer.wordSize(resolved.ref));
        return factory.constructReader(resolved.segment, resolved.ptr * 8, resolved.ptr + dataSizeWords, dataSizeWords * 64, (short)StructPointer.ptrCount(resolved.ref), nestingLimit - 1);
    }

    static SegmentBuilder setStructPointer(SegmentBuilder segment, int refOffset, StructReader value) {
        int dataSize = WireHelpers.roundBitsUpToWords(value.dataSize);
        int totalSize = dataSize + value.pointerCount * 1;
        AllocateResult allocation = WireHelpers.allocate(refOffset, segment, totalSize, (byte)0);
        StructPointer.set(allocation.segment.buffer, allocation.refOffset, (short)dataSize, value.pointerCount);
        if (value.dataSize == 1) {
            throw new RuntimeException("single bit case not handled");
        }
        WireHelpers.memcpy(allocation.segment.buffer, allocation.ptr * 8, value.segment.buffer, value.data, value.dataSize / 8);
        int pointerSection = allocation.ptr + dataSize;
        for (int i = 0; i < value.pointerCount; ++i) {
            WireHelpers.copyPointer(allocation.segment, pointerSection + i, value.segment, value.pointers + i, value.nestingLimit);
        }
        return allocation.segment;
    }

    static SegmentBuilder setListPointer(SegmentBuilder segment, int refOffset, ListReader value) {
        int totalSize = WireHelpers.roundBitsUpToWords(value.elementCount * value.step);
        if (value.step <= 64) {
            AllocateResult allocation = WireHelpers.allocate(refOffset, segment, totalSize, (byte)1);
            if (value.structPointerCount == 1) {
                ListPointer.set(allocation.segment.buffer, allocation.refOffset, (byte)6, value.elementCount);
                for (int i = 0; i < value.elementCount; ++i) {
                    WireHelpers.copyPointer(allocation.segment, allocation.ptr + i, value.segment, value.ptr / 8 + i, value.nestingLimit);
                }
            } else {
                byte elementSize = 0;
                switch (value.step) {
                    case 0: {
                        elementSize = 0;
                        break;
                    }
                    case 1: {
                        elementSize = 1;
                        break;
                    }
                    case 8: {
                        elementSize = 2;
                        break;
                    }
                    case 16: {
                        elementSize = 3;
                        break;
                    }
                    case 32: {
                        elementSize = 4;
                        break;
                    }
                    case 64: {
                        elementSize = 5;
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid list step size: " + value.step);
                    }
                }
                ListPointer.set(allocation.segment.buffer, allocation.refOffset, elementSize, value.elementCount);
                WireHelpers.memcpy(allocation.segment.buffer, allocation.ptr * 8, value.segment.buffer, value.ptr, totalSize * 8);
            }
            return allocation.segment;
        }
        AllocateResult allocation = WireHelpers.allocate(refOffset, segment, totalSize + 1, (byte)1);
        ListPointer.setInlineComposite(allocation.segment.buffer, allocation.refOffset, totalSize);
        short dataSize = (short)WireHelpers.roundBitsUpToWords(value.structDataSize);
        int pointerCount = value.structPointerCount;
        WirePointer.setKindAndInlineCompositeListElementCount(allocation.segment.buffer, allocation.ptr, (byte)0, value.elementCount);
        StructPointer.set(allocation.segment.buffer, allocation.ptr, dataSize, (short)pointerCount);
        int dstOffset = allocation.ptr + 1;
        int srcOffset = value.ptr / 8;
        for (int i = 0; i < value.elementCount; ++i) {
            WireHelpers.memcpy(allocation.segment.buffer, dstOffset * 8, value.segment.buffer, srcOffset * 8, value.structDataSize / 8);
            dstOffset += dataSize;
            srcOffset += dataSize;
            for (int j = 0; j < pointerCount; ++j) {
                WireHelpers.copyPointer(allocation.segment, dstOffset, value.segment, srcOffset, value.nestingLimit);
                ++dstOffset;
                ++srcOffset;
            }
        }
        return allocation.segment;
    }

    static void memset(ByteBuffer dstBuffer, int dstByteOffset, byte value, int length) {
        for (int ii = dstByteOffset; ii < dstByteOffset + length; ++ii) {
            dstBuffer.put(ii, value);
        }
    }

    static void memcpy(ByteBuffer dstBuffer, int dstByteOffset, ByteBuffer srcBuffer, int srcByteOffset, int length) {
        ByteBuffer dstDup = dstBuffer.duplicate();
        dstDup.position(dstByteOffset);
        dstDup.limit(dstByteOffset + length);
        ByteBuffer srcDup = srcBuffer.duplicate();
        srcDup.position(srcByteOffset);
        srcDup.limit(srcByteOffset + length);
        dstDup.put(srcDup);
    }

    static SegmentBuilder copyPointer(SegmentBuilder dstSegment, int dstOffset, SegmentReader srcSegment, int srcOffset, int nestingLimit) {
        long srcRef = srcSegment.get(srcOffset);
        if (WirePointer.isNull(srcRef)) {
            dstSegment.buffer.putLong(dstOffset * 8, 0L);
            return dstSegment;
        }
        int srcTarget = WirePointer.target(srcOffset, srcRef);
        FollowFarsResult resolved = WireHelpers.followFars(srcRef, srcTarget, srcSegment);
        switch (WirePointer.kind(resolved.ref)) {
            case 0: {
                if (nestingLimit <= 0) {
                    throw new DecodeException("Message is too deeply nested or contains cycles. See org.capnproto.ReaderOptions.");
                }
                resolved.segment.arena.checkReadLimit(StructPointer.wordSize(resolved.ref));
                return WireHelpers.setStructPointer(dstSegment, dstOffset, new StructReader(resolved.segment, resolved.ptr * 8, resolved.ptr + StructPointer.dataSize(resolved.ref), StructPointer.dataSize(resolved.ref) * 64, (short)StructPointer.ptrCount(resolved.ref), nestingLimit - 1));
            }
            case 1: {
                byte elementSize = ListPointer.elementSize(resolved.ref);
                if (nestingLimit <= 0) {
                    throw new DecodeException("Message is too deeply nested or contains cycles. See org.capnproto.ReaderOptions.");
                }
                if (elementSize == 7) {
                    int wordCount = ListPointer.inlineCompositeWordCount(resolved.ref);
                    long tag = resolved.segment.get(resolved.ptr);
                    int ptr = resolved.ptr + 1;
                    resolved.segment.arena.checkReadLimit(wordCount + 1);
                    if (WirePointer.kind(tag) != 0) {
                        throw new DecodeException("INLINE_COMPOSITE lists of non-STRUCT type are not supported.");
                    }
                    int elementCount = WirePointer.inlineCompositeListElementCount(tag);
                    int wordsPerElement = StructPointer.wordSize(tag);
                    if ((long)wordsPerElement * (long)elementCount > (long)wordCount) {
                        throw new DecodeException("INLINE_COMPOSITE list's elements overrun its word count.");
                    }
                    if (wordsPerElement == 0) {
                        resolved.segment.arena.checkReadLimit(elementCount);
                    }
                    return WireHelpers.setListPointer(dstSegment, dstOffset, new ListReader(resolved.segment, ptr * 8, elementCount, wordsPerElement * 64, StructPointer.dataSize(tag) * 64, (short)StructPointer.ptrCount(tag), nestingLimit - 1));
                }
                int dataSize = ElementSize.dataBitsPerElement(elementSize);
                short pointerCount = ElementSize.pointersPerElement(elementSize);
                int step = dataSize + pointerCount * 64;
                int elementCount = ListPointer.elementCount(resolved.ref);
                int wordCount = WireHelpers.roundBitsUpToWords((long)elementCount * (long)step);
                resolved.segment.arena.checkReadLimit(wordCount);
                if (elementSize == 0) {
                    resolved.segment.arena.checkReadLimit(elementCount);
                }
                return WireHelpers.setListPointer(dstSegment, dstOffset, new ListReader(resolved.segment, resolved.ptr * 8, elementCount, step, dataSize, pointerCount, nestingLimit - 1));
            }
            case 2: {
                throw new DecodeException("Unexpected FAR pointer.");
            }
            case 3: {
                throw new RuntimeException("copyPointer is unimplemented for OTHER pointers");
            }
        }
        throw new RuntimeException("unreachable");
    }

    static <T> T readListPointer(ListReader.Factory<T> factory, SegmentReader segment, int refOffset, SegmentReader defaultSegment, int defaultOffset, byte expectedElementSize, int nestingLimit) {
        long ref = segment.get(refOffset);
        if (WirePointer.isNull(ref)) {
            if (defaultSegment == null) {
                return factory.constructReader(SegmentReader.EMPTY, 0, 0, 0, 0, (short)0, Integer.MAX_VALUE);
            }
            segment = defaultSegment;
            refOffset = defaultOffset;
            ref = segment.get(refOffset);
        }
        if (nestingLimit <= 0) {
            throw new DecodeException("nesting limit exceeded");
        }
        int refTarget = WirePointer.target(refOffset, ref);
        FollowFarsResult resolved = WireHelpers.followFars(ref, refTarget, segment);
        if (WirePointer.kind(resolved.ref) != 1) {
            throw new DecodeException("Message contains non-list pointer where list was expected.");
        }
        byte elementSize = ListPointer.elementSize(resolved.ref);
        switch (elementSize) {
            case 7: {
                int wordsPerElement;
                int wordCount = ListPointer.inlineCompositeWordCount(resolved.ref);
                long tag = resolved.segment.get(resolved.ptr);
                int ptr = resolved.ptr + 1;
                resolved.segment.arena.checkReadLimit(wordCount + 1);
                if (!WireHelpers.bounds_check(resolved.segment, resolved.ptr, wordCount + 1)) {
                    throw new DecodeException("Message contains out-of-bounds list pointer");
                }
                int size = WirePointer.inlineCompositeListElementCount(tag);
                if ((long)size * (long)(wordsPerElement = StructPointer.wordSize(tag)) > (long)wordCount) {
                    throw new DecodeException("INLINE_COMPOSITE list's elements overrun its word count.");
                }
                if (wordsPerElement == 0) {
                    resolved.segment.arena.checkReadLimit(size);
                }
                return factory.constructReader(resolved.segment, ptr * 8, size, wordsPerElement * 64, StructPointer.dataSize(tag) * 64, (short)StructPointer.ptrCount(tag), nestingLimit - 1);
            }
        }
        int dataSize = ElementSize.dataBitsPerElement(ListPointer.elementSize(resolved.ref));
        short pointerCount = ElementSize.pointersPerElement(ListPointer.elementSize(resolved.ref));
        int elementCount = ListPointer.elementCount(resolved.ref);
        int step = dataSize + pointerCount * 64;
        int wordCount = WireHelpers.roundBitsUpToWords((long)elementCount * (long)step);
        resolved.segment.arena.checkReadLimit(wordCount);
        if (!WireHelpers.bounds_check(resolved.segment, resolved.ptr, wordCount)) {
            throw new DecodeException("Message contains out-of-bounds list pointer");
        }
        if (elementSize == 0) {
            resolved.segment.arena.checkReadLimit(elementCount);
        }
        int expectedDataBitsPerElement = ElementSize.dataBitsPerElement(expectedElementSize);
        short expectedPointersPerElement = ElementSize.pointersPerElement(expectedElementSize);
        if (expectedDataBitsPerElement > dataSize) {
            throw new DecodeException("Message contains list with incompatible element type.");
        }
        if (expectedPointersPerElement > pointerCount) {
            throw new DecodeException("Message contains list with incompatible element type.");
        }
        return factory.constructReader(resolved.segment, resolved.ptr * 8, ListPointer.elementCount(resolved.ref), step, dataSize, pointerCount, nestingLimit - 1);
    }

    static Text.Reader readTextPointer(SegmentReader segment, int refOffset, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
        long ref = segment.get(refOffset);
        if (WirePointer.isNull(ref)) {
            if (defaultBuffer == null) {
                return new Text.Reader();
            }
            return new Text.Reader(defaultBuffer, defaultOffset, defaultSize);
        }
        int refTarget = WirePointer.target(refOffset, ref);
        FollowFarsResult resolved = WireHelpers.followFars(ref, refTarget, segment);
        int size = ListPointer.elementCount(resolved.ref);
        if (WirePointer.kind(resolved.ref) != 1) {
            throw new DecodeException("Message contains non-list pointer where text was expected.");
        }
        if (ListPointer.elementSize(resolved.ref) != 2) {
            throw new DecodeException("Message contains list pointer of non-bytes where text was expected.");
        }
        resolved.segment.arena.checkReadLimit(WireHelpers.roundBytesUpToWords(size));
        if (size == 0 || resolved.segment.buffer.get(8 * resolved.ptr + size - 1) != 0) {
            throw new DecodeException("Message contains text that is not NUL-terminated.");
        }
        return new Text.Reader(resolved.segment.buffer, resolved.ptr, size - 1);
    }

    static Data.Reader readDataPointer(SegmentReader segment, int refOffset, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
        long ref = segment.get(refOffset);
        if (WirePointer.isNull(ref)) {
            if (defaultBuffer == null) {
                return new Data.Reader();
            }
            return new Data.Reader(defaultBuffer, defaultOffset, defaultSize);
        }
        int refTarget = WirePointer.target(refOffset, ref);
        FollowFarsResult resolved = WireHelpers.followFars(ref, refTarget, segment);
        int size = ListPointer.elementCount(resolved.ref);
        if (WirePointer.kind(resolved.ref) != 1) {
            throw new DecodeException("Message contains non-list pointer where data was expected.");
        }
        if (ListPointer.elementSize(resolved.ref) != 2) {
            throw new DecodeException("Message contains list pointer of non-bytes where data was expected.");
        }
        resolved.segment.arena.checkReadLimit(WireHelpers.roundBytesUpToWords(size));
        return new Data.Reader(resolved.segment.buffer, resolved.ptr, size);
    }

    static class FollowFarsResult {
        public final int ptr;
        public final long ref;
        public final SegmentReader segment;

        FollowFarsResult(int ptr, long ref, SegmentReader segment) {
            this.ptr = ptr;
            this.ref = ref;
            this.segment = segment;
        }
    }

    static class FollowBuilderFarsResult {
        public final int ptr;
        public final long ref;
        public final SegmentBuilder segment;

        FollowBuilderFarsResult(int ptr, long ref, SegmentBuilder segment) {
            this.ptr = ptr;
            this.ref = ref;
            this.segment = segment;
        }
    }

    static class AllocateResult {
        public final int ptr;
        public final int refOffset;
        public final SegmentBuilder segment;

        AllocateResult(int ptr, int refOffset, SegmentBuilder segment) {
            this.ptr = ptr;
            this.refOffset = refOffset;
            this.segment = segment;
        }
    }
}

