/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.capnproto.BufferedOutputStream;

public final class ArrayOutputStream
implements BufferedOutputStream {
    public final ByteBuffer buf;

    public ArrayOutputStream(ByteBuffer buf) {
        this.buf = buf.duplicate();
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        int size;
        int available = this.buf.remaining();
        if (available < (size = src.remaining())) {
            throw new IOException("backing buffer was not large enough");
        }
        this.buf.put(src);
        return size;
    }

    @Override
    public final ByteBuffer getWriteBuffer() {
        return this.buf;
    }

    @Override
    public final void close() throws IOException {
    }

    @Override
    public final boolean isOpen() {
        return true;
    }

    @Override
    public final void flush() {
    }
}

