/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.capnproto.Allocator;
import org.capnproto.Arena;
import org.capnproto.DefaultAllocator;
import org.capnproto.ReaderArena;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;

public final class BuilderArena
implements Arena {
    public static final int SUGGESTED_FIRST_SEGMENT_WORDS = 1024;
    public static final AllocationStrategy SUGGESTED_ALLOCATION_STRATEGY = AllocationStrategy.GROW_HEURISTICALLY;
    public final ArrayList<SegmentBuilder> segments = new ArrayList();
    private final Allocator allocator;

    public BuilderArena(int firstSegmentSizeWords, AllocationStrategy allocationStrategy) {
        DefaultAllocator allocator = new DefaultAllocator(allocationStrategy);
        allocator.setNextAllocationSizeBytes(firstSegmentSizeWords * 8);
        this.allocator = allocator;
    }

    public BuilderArena(Allocator allocator) {
        this.allocator = allocator;
    }

    public BuilderArena(Allocator allocator, ByteBuffer firstSegment) {
        SegmentBuilder newSegment = new SegmentBuilder(firstSegment, this);
        newSegment.buffer.order(ByteOrder.LITTLE_ENDIAN);
        newSegment.id = 0;
        this.segments.add(newSegment);
        this.allocator = allocator;
    }

    BuilderArena(ReaderArena arena) {
        int largestSegment = 8192;
        int ii = 0;
        while (ii < arena.segments.size()) {
            SegmentReader segment = arena.segments.get(ii);
            SegmentBuilder segmentBuilder = new SegmentBuilder(segment.buffer, this);
            segmentBuilder.id = ii++;
            segmentBuilder.pos = segmentBuilder.capacity();
            this.segments.add(segmentBuilder);
            largestSegment = Math.max(largestSegment, segment.buffer.capacity());
        }
        DefaultAllocator defaultAllocator = new DefaultAllocator(SUGGESTED_ALLOCATION_STRATEGY);
        defaultAllocator.setNextAllocationSizeBytes(largestSegment);
        this.allocator = defaultAllocator;
    }

    @Override
    public final SegmentReader tryGetSegment(int id) {
        return this.segments.get(id);
    }

    public final SegmentBuilder getSegment(int id) {
        return this.segments.get(id);
    }

    @Override
    public final void checkReadLimit(int numBytes) {
    }

    public AllocateResult allocate(int amount) {
        int result;
        int len = this.segments.size();
        if (len > 0 && (result = this.segments.get(len - 1).allocate(amount)) != -1) {
            return new AllocateResult(this.segments.get(len - 1), result);
        }
        if (amount >= 0x10000000) {
            throw new RuntimeException("Too many words to allocate: " + amount);
        }
        SegmentBuilder newSegment = new SegmentBuilder(this.allocator.allocateSegment(amount * 8), this);
        newSegment.buffer.order(ByteOrder.LITTLE_ENDIAN);
        newSegment.id = len;
        this.segments.add(newSegment);
        return new AllocateResult(newSegment, newSegment.allocate(amount));
    }

    public final ByteBuffer[] getSegmentsForOutput() {
        ByteBuffer[] result = new ByteBuffer[this.segments.size()];
        for (int ii = 0; ii < this.segments.size(); ++ii) {
            SegmentBuilder segment = this.segments.get(ii);
            segment.buffer.rewind();
            ByteBuffer slice = segment.buffer.slice();
            slice.limit(segment.currentSize() * 8);
            slice.order(ByteOrder.LITTLE_ENDIAN);
            result[ii] = slice;
        }
        return result;
    }

    public static class AllocateResult {
        public final SegmentBuilder segment;
        public final int offset;

        public AllocateResult(SegmentBuilder segment, int offset) {
            this.segment = segment;
            this.offset = offset;
        }
    }

    public static enum AllocationStrategy {
        FIXED_SIZE,
        GROW_HEURISTICALLY;

    }
}

