/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerReader;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.SegmentReader;
import org.capnproto.StructReader;

public class ListReader {
    final SegmentReader segment;
    final int ptr;
    final int elementCount;
    final int step;
    final int structDataSize;
    final short structPointerCount;
    final int nestingLimit;

    public ListReader() {
        this.segment = null;
        this.ptr = 0;
        this.elementCount = 0;
        this.step = 0;
        this.structDataSize = 0;
        this.structPointerCount = 0;
        this.nestingLimit = Integer.MAX_VALUE;
    }

    public ListReader(SegmentReader segment, int ptr, int elementCount, int step, int structDataSize, short structPointerCount, int nestingLimit) {
        this.segment = segment;
        this.ptr = ptr;
        this.elementCount = elementCount;
        this.step = step;
        this.structDataSize = structDataSize;
        this.structPointerCount = structPointerCount;
        this.nestingLimit = nestingLimit;
    }

    public int size() {
        return this.elementCount;
    }

    protected boolean _getBooleanElement(int index) {
        long bindex = (long)index * (long)this.step;
        byte b = this.segment.buffer.get(this.ptr + (int)(bindex / 8L));
        return (b & 1 << (int)(bindex % 8L)) != 0;
    }

    protected byte _getByteElement(int index) {
        return this.segment.buffer.get(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected short _getShortElement(int index) {
        return this.segment.buffer.getShort(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected int _getIntElement(int index) {
        return this.segment.buffer.getInt(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected long _getLongElement(int index) {
        return this.segment.buffer.getLong(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected float _getFloatElement(int index) {
        return this.segment.buffer.getFloat(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected double _getDoubleElement(int index) {
        return this.segment.buffer.getDouble(this.ptr + (int)((long)index * (long)this.step / 8L));
    }

    protected <T> T _getStructElement(StructReader.Factory<T> factory, int index) {
        long indexBit = (long)index * (long)this.step;
        int structData = this.ptr + (int)(indexBit / 8L);
        int structPointers = structData + this.structDataSize / 8;
        return factory.constructReader(this.segment, structData, structPointers / 8, this.structDataSize, this.structPointerCount, this.nestingLimit - 1);
    }

    protected <T> T _getPointerElement(FromPointerReader<T> factory, int index) {
        return factory.fromPointerReader(this.segment, (this.ptr + this.structDataSize / 8 + (int)((long)index * (long)this.step / 8L)) / 8, this.nestingLimit);
    }

    protected <T> T _getPointerElement(FromPointerReaderBlobDefault<T> factory, int index, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
        return factory.fromPointerReaderBlobDefault(this.segment, (this.ptr + (int)((long)index * (long)this.step / 8L)) / 8, defaultBuffer, defaultOffset, defaultSize);
    }

    public static interface Factory<T> {
        public T constructReader(SegmentReader var1, int var2, int var3, int var4, int var5, short var6, int var7);
    }
}

